/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.notifications;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.helper.DocoDocaHelper;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.RecordLocatorInfo;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.booking.ReservationSystemInfo;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.ibecorp.notifications.VisaInformationNotification;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.LongRunningTasksManager;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class DocoDocaMailRequestTask
extends BaseLongRunningTask<ReservationSystemInfo> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ReservationSystemInfo rsi;
    @Deprecated
    private String pnr;

    public void configure(ReservationSystemInfo configuration) {
        this.rsi = configuration;
    }

    public boolean isSingleton() {
        return false;
    }

    public L10nMessage getDescription() {
        if (TextUtil.nonBlank((String)this.pnr)) {
            return L10nResourcesManager.createL10nMessage((String)("\u043e\u0442\u0441\u044b\u043b\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u0432\u0438\u0437\u043e\u0432\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u0434\u043b\u044f pnr " + this.pnr), (Object[])new Object[0]);
        }
        return L10nResourcesManager.createL10nMessage((String)"\u043e\u0442\u0441\u044b\u043b\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u0432\u0438\u0437\u043e\u0432\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u0434\u043b\u044f pnr {0}, ({1})", (Object[])new Object[]{this.rsi.getRecordLocators().stream().map(RecordLocatorInfo::getRecordLocator).collect(Collectors.joining("-")), this.rsi.getGdsName()});
    }

    public void toXML(Element elm) {
        XHelper.writeString((Element)elm, (String)"pnr", (String)this.pnr);
        XHelper.writeObject((Element)elm, (String)"pnrInfo", (Object)this.rsi);
    }

    public void fromXML(Element elm) {
        this.pnr = XHelper.readString((Element)elm, (String)"pnr");
        this.rsi = (ReservationSystemInfo)XHelper.readObject((Element)elm, (String)"pnrInfo");
    }

    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        List recordLocators;
        if (TextUtil.nonBlank((String)this.pnr)) {
            this.doJobOld(callback);
        }
        if ((recordLocators = this.rsi.getRecordLocators().stream().map(rli -> com.gridnine.xtrip.common.model.helpers.SearchQueryHelper.getRecordLocatorSearchValue((String)rli.getRecordLocator(), (GdsName)this.rsi.getGdsName(), (RecordLocatorType)rli.getType())).collect(Collectors.toList())).isEmpty()) {
            throw new Exception("invalid recordLocators list");
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrContainsStringCriterion((String)BookingFileIndex.Property.recordLocators.name(), recordLocators));
        query.getPreferredProperties().add(BookingFileIndex.Property.fullNumber.name());
        List searchResult = LogicalStorage.get().getEntityStorage().search(BookingFileIndex.class, query).getData();
        boolean processed = false;
        ArrayList<String> bookingFileNumbers = new ArrayList<String>();
        for (BookingFileIndex bookingFileIndex : searchResult) {
            bookingFileNumbers.add(bookingFileIndex.getFullNumber());
            EntityContainer bfCtr = EntityStorage.get().resolve(bookingFileIndex.getSource());
            for (Reservation res : ((BookingFile)bfCtr.getEntity()).getReservations()) {
                ReservationSystemInfo currentRsi = CommonReservationGdsNameInfoHelper.getReservationSystemInfo((Reservation)res, (GdsName)this.rsi.getGdsName());
                if (!CommonReservationGdsNameInfoHelper.isSameReservationSystemInfo((ReservationSystemInfo)this.rsi, (ReservationSystemInfo)currentRsi)) continue;
                this.processReservation(callback, (EntityContainer<BookingFile>)bfCtr, res);
                processed = true;
                break;
            }
            if (!processed) continue;
            break;
        }
        if (!processed) {
            throw Xeption.forDeveloper((String)"can't find reservation {0} ({1}), founded booking files: {2}", (Object[])new Object[]{this.rsi.getRecordLocators().stream().map(RecordLocatorInfo::getRecordLocator).collect(Collectors.joining("-")), this.rsi.getGdsName(), bookingFileNumbers});
        }
        callback.taskFinished();
    }

    private void doJobOld(LongRunningTask.EventsCallback callback) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(com.gridnine.xtrip.common.model.helpers.SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)this.pnr, (boolean)true));
        query.getPreferredProperties().add(BookingFileIndex.Property.fullNumber.name());
        List searchResult = LogicalStorage.get().getEntityStorage().search(BookingFileIndex.class, query).getData();
        if (searchResult.size() != 1) {
            throw new Exception(String.format("%d results found for pnr %s", searchResult.size(), this.pnr));
        }
        EntityContainer bfCtr = EntityStorage.get().resolve(((BookingFileIndex)searchResult.get(0)).getSource());
        for (Reservation res : ((BookingFile)bfCtr.getEntity()).getReservations()) {
            if (!CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)res, (String)this.pnr)) continue;
            this.processReservation(callback, (EntityContainer<BookingFile>)bfCtr, res);
            break;
        }
        callback.taskFinished();
    }

    private void processReservation(LongRunningTask.EventsCallback callback, EntityContainer<BookingFile> bfCtr, Reservation res) throws Exception {
        if (CommonIbecorpHelper.getReservationStatus((Reservation)res) != ReservationStatus.BOOKING) {
            this.log.debug("ignoring pnr " + this.pnr + ", status = " + CommonIbecorpHelper.getReservationStatus((Reservation)res));
            callback.addEvent(null, MessageHelper.createMessage((String)"\u0417\u0430\u0434\u0430\u0447\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430 \u0434\u043e\u0441\u0440\u043e\u0447\u043d\u043e, \u0442\u0430\u043a \u043a\u0430\u043a \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0438\u043c\u0435\u0435\u0442 \u0441\u0442\u0430\u0442\u0443\u0441 \u043e\u0442\u043b\u0438\u0447\u043d\u044b\u0439 \u043e\u0442 \"\u041d\u043e\u0432\u043e\u0435\"", (Object[])new Object[0]));
            return;
        }
        if (res.getVisaRequirements().size() > 0 && !DocoDocaHelper.isVisaInformationReceived((Reservation)res)) {
            EntityReference bookingRef = bfCtr.toReference();
            NotificationParameters parameters = new NotificationParameters((EntityReference<Organization>)((BookingFile)bfCtr.getEntity()).getAgency(), (EntityReference<Organization>)((BookingFile)bfCtr.getEntity()).getCustomerProfile(), (EntityReference<SMSite>)res.getBookingFile().getSite(), ((BookingFile)bfCtr.getEntity()).getCustomer().getPreferredLocale(), bookingRef, SalesContextHandler.get().createSalesContext(res));
            NotificationHelper.sendNotification(() -> new VisaInformationNotification(parameters, res), bookingRef, true);
            Date nextTaskDate = this.getNextTaskDate(res);
            if (nextTaskDate != null) {
                EntityContainer gdsAccountCtr = EntityStorage.get().resolve(res.getGdsNameInfo().getOnlineGdsAccount());
                ((LongRunningTasksManager)Environment.getPublished(LongRunningTasksManager.class)).addTask(DocoDocaMailRequestTask.class, nextTaskDate, (Serializable)CommonReservationGdsNameInfoHelper.getReservationSystemInfo((Reservation)res, (GdsName)((BaseGdsAccount)gdsAccountCtr.getEntity()).getGds()));
            }
        }
    }

    private Date getNextTaskDate(Reservation res) {
        for (BaseProduct bp : res.getProducts()) {
            if (!(bp instanceof Product)) continue;
            Date firstTravelDate = HandlersRegistry.get().findProductHandler(Product.class).findFirstTravelDate((BaseProduct)((Product)bp));
            if (firstTravelDate.getTime() - new Date().getTime() < 86400000L) {
                return null;
            }
            if (firstTravelDate.getTime() - new Date().getTime() < 604800000L) {
                return new Date(new Date().getTime() + 86400000L);
            }
            return new Date(new Date().getTime() + 216000000L);
        }
        return null;
    }
}

