/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.notifications;

import com.gridnine.xtrip.common.ibecorp.rules.NotificationFinDocsActionSet;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.ExternalFinanceDocumentIndex;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.MailTemplate;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.helpers.IbecorpRulesHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.Notification;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public class FinanceDocumentNotification
extends Notification {
    private MailTemplate template;

    public FinanceDocumentNotification(NotificationParameters parameters, MailTemplate template, BookingFile booking, Collection<BaseFileDocument> newDocuments) {
        super(parameters);
        this.ignoreAvailableRecipientTypes = true;
        this.template = template;
        try {
            String customerEmail;
            Reservation reservation = (Reservation)booking.getReservations().get(0);
            this.addProperty("orderNumber", booking.getNumber());
            this.buildResumeLink(reservation, Optional.ofNullable(booking.getSite()).flatMap(ref -> Optional.ofNullable(EntityStorage.get().resolve(ref))).flatMap(s -> Optional.ofNullable(((SMSite)s.getEntity()).getSiteType())).orElse(null));
            NotificationFinDocsActionSet actionSet = IbecorpRulesHelper.getNotificationFinDocsActionSet(reservation);
            if (actionSet.isNotifyBookingAgent()) {
                booking.getReservations().forEach(this::addAgentRecipients);
            }
            if (actionSet.isNotifyBookingCustomer() && TextUtil.nonBlank((String)(customerEmail = ProfileHelper.getCommunicationEmail((List)booking.getCustomer().getCommunications())))) {
                this.addCustomerRecipient(customerEmail);
            }
            if (actionSet.isNotifyBookingTravellers()) {
                this.addTravellersRecipients(booking);
            }
            if (CollectionUtil.isNotEmpty((Collection)actionSet.getEmails())) {
                actionSet.getEmails().stream().filter(TextUtil::nonBlank).forEach(this::addOtherRecipient);
            }
            if (CollectionUtil.isNotEmpty((Collection)actionSet.getPersonRefs())) {
                List uids = CollectionUtil.getUids((Collection)actionSet.getPersonRefs());
                SearchQuery query = new SearchQuery();
                query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqStringCriterion((String)"containerUid", (Collection)uids));
                query.getCriteria().getCriterions().add(SearchCriterion.isNotEmpty((String)PersonIndex.Property.emails.name()));
                query.getPreferredProperties().add(PersonIndex.Property.name.name());
                query.getPreferredProperties().add(PersonIndex.Property.emails.name());
                List personIndexes = EntityStorage.get().search(PersonIndex.class, query).getData();
                personIndexes.stream().map(PersonIndex::getEmails).flatMap(Collection::stream).filter(TextUtil::nonBlank).forEach(this::addOtherRecipient);
            }
            if (this.getRecipients().length > 0) {
                if (actionSet.isSendOnlyNewDocuments()) {
                    newDocuments.forEach(this::addDocument);
                } else {
                    SearchQuery query = new SearchQuery();
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ExternalFinanceDocumentIndex.Property.bookingFile.name(), (Object)this.owner));
                    query.getPreferredProperties().add(ExternalFinanceDocumentIndex.Property.number.name());
                    List extFinDocIndexes = EntityStorage.get().search(ExternalFinanceDocumentIndex.class, query).getData();
                    extFinDocIndexes.stream().map(ExternalFinanceDocumentIndex::getSource).map(arg_0 -> ((EntityStorage)EntityStorage.get()).resolve(arg_0)).filter(Objects::nonNull).map(EntityContainer::getEntity).forEach(this::addDocument);
                }
            }
        }
        catch (Throwable ex) {
            SysLogHelper.audit((EntityReference)this.owner, (String)"ext-fin-doc-notification", (Message[])new Message[]{MessagesHelper.createMessageWithDetails((MessageType)MessageType.ERROR, (String)"send notification failed", (String)TextUtil.getExceptionStackTrace((Throwable)ex), (Object[])new Object[0])});
        }
    }

    @Override
    public String getDefaultSubject(Locale locale) {
        return L10nResourcesManager.getStr((String)"FinanceDocumentNotification_Subject", (Locale)locale, (Object[])new Object[0]);
    }

    @Override
    public MailTemplate getTemplate() {
        return this.template;
    }
}

