/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.notifications;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.ibecorp.NotificationRecipientType;
import com.gridnine.xtrip.common.model.ibecorp.NotificationType;
import com.gridnine.xtrip.common.model.ibecorp.sm.MailTemplate;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.ibecorp.notifications.SiteReservationNotification;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;

public class HasChangedTimeLimitNotification
extends SiteReservationNotification {
    @Override
    protected NotificationType getNotificationType() {
        return NotificationType.TIME_LIMIT_CHANGED;
    }

    public HasChangedTimeLimitNotification(NotificationParameters parameters, Reservation bfReservation, Reservation oldReservation) {
        super(parameters, bfReservation, Arrays.asList(NotificationRecipientType.BOOKING_AGENT, NotificationRecipientType.TRAVELLERS));
        SMGeneralSettings smGeneralSettings;
        LocalDateTime oldTimeLimit;
        if (oldReservation != null && (oldTimeLimit = CommonHelper.getCorrectTimeLimit(oldReservation, smGeneralSettings = this.getSmGeneralSettings(bfReservation.getBookingFile()))) != null) {
            Calendar oldCal = Calendar.getInstance();
            oldCal.setTime(DateUtils.toJavaDate((LocalDateTime)oldTimeLimit));
            this.addProperty("oldTimeLimitDate", this.dateF.format(oldCal.getTime()));
            this.addProperty("oldTimeLimitTime", this.timeF.format(oldCal.getTime()));
        }
    }

    @Override
    public String getDefaultSubject(Locale locale) {
        return L10nResourcesManager.getStr((String)"HasChangedTimeLimitNotification_Subject", (Locale)locale, (Object[])new Object[0]);
    }

    @Override
    protected MailTemplate getTemplateByOldLogic() {
        ProductType productType = this.getProductType();
        if (productType == ProductType.AIR_TICKET) {
            return this.getNotificationSettings().getHasChangedTimeLimitNotification();
        }
        return null;
    }
}

