/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.notifications;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.helper.DocoDocaHelper;
import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.ibecorp.notifications.VisaInformationNotification;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.LongRunningTasksManager;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;

@Deprecated
public class IbecorpDocoDocaMailRequestTask
extends BaseLongRunningTask<String> {
    private String pnr;

    public void configure(String configuration) {
        this.pnr = configuration;
    }

    public boolean isSingleton() {
        return false;
    }

    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)("\u043e\u0442\u0441\u044b\u043b\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u0432\u0438\u0437\u043e\u0432\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u0434\u043b\u044f pnr " + this.pnr), (Object[])new Object[0]);
    }

    public void toXML(Element elm) {
        XHelper.writeObject((Element)elm, (String)"config", (Object)this.pnr);
    }

    public void fromXML(Element elm) {
        this.pnr = (String)XHelper.readObject((Element)elm, (String)"config");
    }

    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)this.pnr, (boolean)true));
        List searchResult = LogicalStorage.get().getEntityStorage().search(BookingFileIndex.class, query).getData();
        if (searchResult.size() != 1) {
            throw new Exception(String.format("%d results found for pnr %s", searchResult.size(), this.pnr));
        }
        EntityContainer bfCtr = EntityStorage.get().resolve(((BookingFileIndex)searchResult.get(0)).getSource());
        for (Reservation res : ((BookingFile)bfCtr.getEntity()).getReservations()) {
            if (!CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)res, (String)this.pnr)) continue;
            if (CommonIbecorpHelper.getReservationStatus((Reservation)res) != ReservationStatus.BOOKING) {
                this.log.debug("ignoring pnr " + this.pnr + ", status = " + CommonIbecorpHelper.getReservationStatus((Reservation)res));
                callback.addEvent(null, MessageHelper.createMessage((String)"\u0417\u0430\u0434\u0430\u0447\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430 \u0434\u043e\u0441\u0440\u043e\u0447\u043d\u043e, \u0442\u0430\u043a \u043a\u0430\u043a \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0438\u043c\u0435\u0435\u0442 \u0441\u0442\u0430\u0442\u0443\u0441 \u043e\u0442\u043b\u0438\u0447\u043d\u044b\u0439 \u043e\u0442 \"\u041d\u043e\u0432\u043e\u0435\"", (Object[])new Object[0]));
                callback.taskFinished();
                return;
            }
            if (res.getVisaRequirements().size() <= 0 || DocoDocaHelper.isVisaInformationReceived((Reservation)res)) break;
            EntityReference bookingRef = bfCtr.toReference();
            NotificationParameters parameters = new NotificationParameters(this.findSubagency((BookingFile)bfCtr.getEntity()), (EntityReference<Organization>)((BookingFile)bfCtr.getEntity()).getCustomerProfile(), (EntityReference<SMSite>)res.getBookingFile().getSite(), ((BookingFile)bfCtr.getEntity()).getCustomer().getPreferredLocale(), bookingRef, SalesContextHandler.get().createSalesContext(res));
            NotificationHelper.sendNotification(() -> new VisaInformationNotification(parameters, res), bookingRef, true);
            ((LongRunningTasksManager)Environment.getPublished(LongRunningTasksManager.class)).addTask(IbecorpDocoDocaMailRequestTask.class, this.getNextTaskDate(res), (Serializable)((Object)this.pnr));
            break;
        }
        callback.taskFinished();
    }

    private EntityReference<Organization> findSubagency(BookingFile entity) {
        for (Reservation item : entity.getReservations()) {
            for (BaseProduct prod : item.getProducts()) {
                if (!(prod instanceof Product)) continue;
                Product product = (Product)prod;
                return AirProductHelper.getSubagency((Product)product);
            }
        }
        return null;
    }

    private Date getNextTaskDate(Reservation res) {
        for (BaseProduct bp : res.getProducts()) {
            if (!(bp instanceof Product)) continue;
            if (((Segment)((SegmentTariff)((Product)bp).getSegmentTariffs().get(0)).getSegments().get(0)).getStartDate().getTime() - new Date().getTime() < 604800000L) {
                return new Date(new Date().getTime() + 86400000L);
            }
            return new Date(new Date().getTime() + 216000000L);
        }
        return null;
    }
}

