/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.notifications;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.NotificationRecipientType;
import com.gridnine.xtrip.common.model.ibecorp.sm.MailTemplate;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibecorp.notifications.Notification;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class InsuranceIssueNotification
extends Notification {
    private static final long serialVersionUID = -4024786963236183467L;

    public InsuranceIssueNotification(NotificationParameters parameters, Reservation reservation) {
        super(parameters, Arrays.asList(NotificationRecipientType.BOOKING_AGENT, NotificationRecipientType.CUSTOMER));
        this.addReservationProperties(reservation);
        try {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), parameters.getOwnerRef()));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.type.name(), (Object)DocumentType.INSURANCE));
            List docs = LogicalStorage.get().getEntityStorage().search(BasicDocumentIndex.class, query).getData();
            for (BasicDocumentIndex basicDocumentIndex : docs) {
                BaseFileDocument doc = (BaseFileDocument)((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(basicDocumentIndex.getSource()).getEntity();
                this.addDocument(doc);
            }
        }
        catch (Throwable t) {
            throw Xeption.forDeveloper((String)"failed generating InsuranceIssueNotification", (Throwable)t, (Object[])new Object[0]);
        }
    }

    @Override
    public String getDefaultSubject(Locale locale) {
        return L10nResourcesManager.getStr((String)"InsuranceIssueNotification_Subject", (Locale)locale, (Object[])new Object[0]);
    }

    @Override
    public MailTemplate getTemplate() {
        return this.getNotificationSettings().getInsuranceIssueNotification();
    }
}

