/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.notifications;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.ibecorp.NotificationRecipientType;
import com.gridnine.xtrip.common.model.ibecorp.NotificationType;
import com.gridnine.xtrip.common.model.ibecorp.sm.MailTemplate;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMNotificationsSettings;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.ibecorp.notifications.SiteReservationNotification;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.util.Arrays;
import java.util.Locale;

public class IntentionCancelledNotification
extends SiteReservationNotification {
    private static final long serialVersionUID = -3821631554686465823L;
    private boolean getTemplateByOldLogicCalled;

    @Override
    protected NotificationType getNotificationType() {
        return NotificationType.INTENTION_CANCELLED;
    }

    @Override
    protected NotificationType getOldNotificationType() {
        return NotificationType.RESERVATION_CANCELLED;
    }

    public IntentionCancelledNotification(NotificationParameters parameters, Reservation reservation) {
        super(parameters, reservation, Arrays.asList(NotificationRecipientType.BOOKING_AGENT, NotificationRecipientType.CUSTOMER));
    }

    @Override
    public String getDefaultSubject(Locale locale) {
        return L10nResourcesManager.getStr((String)"IntentionCancelledNotification_Subject", (Locale)locale, (Object[])new Object[0]);
    }

    @Override
    protected MailTemplate getTemplateByOldLogic() {
        SMNotificationsSettings notificationsSettings = this.getNotificationSettings();
        if (!notificationsSettings.isTurnOnCancellationNotification()) {
            if (!this.getTemplateByOldLogicCalled) {
                SysLogHelper.audit(this.getOwner(), (String)"notification-settings", (Message[])new Message[]{MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)L10n.get((String)"VoidIntentionNotificationDisabled"), (Object[])new Object[0])});
                this.getTemplateByOldLogicCalled = true;
            }
            return null;
        }
        ProductType productType = this.getProductType();
        if (productType == ProductType.RAILWAY_PRODUCT) {
            return notificationsSettings.getRailwayTemplates().getReservationCancelledNotification();
        }
        if (productType == ProductType.AIR_TICKET) {
            return notificationsSettings.getReservationCancelledNotification();
        }
        return null;
    }
}

