/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.notifications;

import com.gridnine.xtrip.common.ibecorp.rules.NotificationsActionSet;
import com.gridnine.xtrip.common.ibecorp.rules.Targets;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleString;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.ibecorp.IssueMailTemplate;
import com.gridnine.xtrip.common.model.ibecorp.NotificationSettings;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.BaseIssue;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.NotificationEvent;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.Post;
import com.gridnine.xtrip.common.model.ibecorp.sm.MailTemplate;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.Predicates;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.correspondence.storage.NotificationPropertySetImpl;
import com.gridnine.xtrip.server.ibecorp.notifications.Notification;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import com.gridnine.xtrip.server.model.rules.RulesHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class IssueNotification
extends Notification {
    private BaseIssue issue;
    private BaseIssue oldIssue;
    private NotificationEvent event;
    private IssueMailTemplate template;

    @Override
    protected boolean isOldLogic() {
        return false;
    }

    public IssueNotification(BaseIssue issue, BaseIssue oldIssue, NotificationEvent event, BookingFile booking) {
        super(new NotificationParameters((EntityReference<Organization>)issue.getSubagency(), (EntityReference<Organization>)issue.getClient(), (EntityReference<SMSite>)booking.getSite(), LocaleHelper.getCurrentLocale(), issue.getBooking()));
        this.issue = issue;
        this.oldIssue = oldIssue;
        this.event = event;
        Targets notificationTarget = Targets.NOTIFICATION_TEMPLATE_ISSUE;
        try {
            NotificationSettings notificationSettings = NotificationHelper.getNotificationSettings((EntityReference<Organization>)issue.getClient(), (EntityReference<Organization>)issue.getSubagency(), (EntityReference<Organization>)issue.getAgency(), NotificationSettings::isUseIssueSettings);
            StringBuilder appliedRulesInfo = new StringBuilder();
            if (notificationSettings != null) {
                RuleProxy proxy = new RuleProxy();
                proxy.getTracer().setDisabled(true);
                proxy.setProxyType(notificationTarget.getId());
                proxy.setProxyDate(new Date());
                proxy.setPropertySet((Object)new NotificationPropertySetImpl(issue, event, booking));
                proxy.setActionSet((Object)new NotificationsActionSet());
                RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)notificationSettings.getRuleSet());
                RulesHelper.getAppliedRuleSettings((RuleProxy)proxy, (RuleSet)notificationSettings.getRuleSet()).stream().forEach(rs -> {
                    int ruleNmb = notificationSettings.getRuleSet().getRules().indexOf(rs) + 1;
                    appliedRulesInfo.append(L10n.getWithParams((String)"NotificationSettingsRule", (Object[])new Object[]{rs.getName(), ruleNmb})).append("\n").append(rs.getRestrictionsInfoNoHtml()).append("\n\n");
                });
                this.template = ((NotificationsActionSet)proxy.getActionSet()).getIssueNotificationTemplate();
                if (event == NotificationEvent.ATTACHMENT_ADDED) {
                    Set oldAttachments = oldIssue == null ? Collections.emptySet() : oldIssue.getPosts().stream().map(Post::getAttachments).flatMap(Collection::stream).collect(Collectors.toSet());
                    issue.getPosts().stream().map(Post::getAttachments).flatMap(Collection::stream).filter(Predicates.not(oldAttachments::contains)).map(arg_0 -> ((EntityStorage)EntityStorage.get()).resolve(arg_0)).filter(Objects::nonNull).map(EntityContainer::getEntity).forEach(this::addDocument);
                }
                this.addProperties();
                this.buildResumeLink(!booking.getReservations().isEmpty() ? (Reservation)booking.getReservations().get(0) : null, Optional.ofNullable(EntityStorage.get().resolve(booking.getSite())).map(s -> ((SMSite)s.getEntity()).getSiteType()).orElse(null));
            }
            if (issue.getBooking() != null) {
                Message message = notificationSettings == null ? MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)L10n.getWithParams((String)"NotificationSettingsNotFound", (Object[])new Object[]{notificationTarget.getDisplayName()}), (Object[])new Object[0]) : MessagesHelper.createMessageWithDetails((MessageType)MessageType.MESSAGE, (String)L10n.getWithParams((String)"NotificationSettingsAreUsed", (Object[])new Object[]{notificationSettings.toString()}), (String)appliedRulesInfo.toString(), (Object[])new Object[0]);
                SysLogHelper.audit((EntityReference)issue.getBooking(), (String)"notification", (Message[])new Message[]{message});
            }
        }
        catch (Exception ex) {
            throw Xeption.forDeveloper((String)"create IssueNotification failed", (Throwable)ex, (Object[])new Object[0]);
        }
    }

    private void addProperties() {
        EntityContainer authorCtr;
        EntityContainer assigneeCtr;
        EntityContainer clientCtr;
        Locale locale = this.getLocale();
        this.addProperty("currentUser", this.toString(ProfileHelper.getCurrentUser()));
        this.addProperty("notificationEvent", this.toString((LocaleString)this.event));
        this.addProperty("issueNumber", this.issue.getNumber());
        this.addProperty("issueTitle", this.issue.getTitle());
        this.addProperty("clientOrgShortName", this.toString(this.issue.getClient()));
        this.addProperty("issueAssignee", this.toString(this.issue.getAssignee()));
        this.addProperty("issueDescription", this.issue.getDescription());
        this.addProperty("issueStatus", this.toString((LocaleString)this.issue.getStatus()));
        int size = this.issue.getPosts().size();
        if (size > 0) {
            this.addProperty("issueLastComment", ((Post)this.issue.getPosts().get(size - 1)).getContent());
        }
        if (this.oldIssue != null) {
            this.addProperty("issueTitleOld", this.oldIssue.getTitle());
            this.addProperty("clientOrgShortNameOld", this.toString(this.oldIssue.getClient()));
            this.addProperty("issueAssigneeOld", this.toString(this.oldIssue.getAssignee()));
            this.addProperty("issueDescriptionOld", this.oldIssue.getDescription());
            this.addProperty("issueStatusOld", this.toString((LocaleString)this.oldIssue.getStatus()));
        }
        if ((clientCtr = EntityStorage.get().resolve(this.issue.getClient())) != null) {
            Organization client = (Organization)clientCtr.getEntity();
            this.addProperty("clientOrgCode", client.getCode());
        }
        if ((assigneeCtr = EntityStorage.get().resolve(this.issue.getAssignee())) != null) {
            this.addProperty("issueAssigneeFull", ProfileHelper.getFullName((Person)((Person)assigneeCtr.getEntity()), (Locale)locale, (boolean)false));
        }
        if ((authorCtr = EntityStorage.get().resolve(this.issue.getAuthor())) != null) {
            this.addProperty("issueAuthorFull", ProfileHelper.getFullName((Person)((Person)authorCtr.getEntity()), (Locale)locale, (boolean)false));
            String email = ((Person)authorCtr.getEntity()).getCommunications().stream().filter(communication -> communication.getType() == CommunicationType.EMAIL).map(Communication::getSense).filter(TextUtil::nonBlank).collect(Collectors.joining(", "));
            this.addProperty("issueAuthorEmail", email);
            String phone = ((Person)authorCtr.getEntity()).getCommunications().stream().filter(communication -> TextUtil.nonBlank((String)communication.getSense()) && (communication.getType() == CommunicationType.WORK_PHONE || communication.getType() == CommunicationType.AGENCY || communication.getType() == CommunicationType.MOBILE || communication.getType() == CommunicationType.CELL)).map(ProfileHelper::buildFullPhoneNumber).collect(Collectors.joining("; "));
            this.addProperty("issueAuthorPhone", phone);
        }
    }

    private String toString(EntityReference ref) {
        return ref == null ? null : ref.toString();
    }

    private String toString(LocaleString lString) {
        return lString == null ? null : lString.toString(this.getLocale());
    }

    @Override
    public String getDefaultSubject(Locale locale) {
        return L10nResourcesManager.getStr((String)"IssueNotification_Subject", (Locale)locale, (Object[])new Object[0]);
    }

    @Override
    public MailTemplate getTemplate() {
        return this.template;
    }
}

