/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.notifications;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssuingFailedNotificationHelper {
    private static final transient Logger log = LoggerFactory.getLogger(IssuingFailedNotificationHelper.class);

    public static String getSubject(String pnr) {
        return IssuingFailedNotificationHelper.getLocalizedString("NotificationIssueFailed_Subject", pnr);
    }

    public static final String getText(EntityContainer<?> bfCtr, Reservation reservation, Payment payment) {
        StringBuilder text = new StringBuilder();
        try {
            BookingFile bf = (BookingFile)bfCtr.getEntity();
            text.append(IssuingFailedNotificationHelper.getLocalizedString("NotificationIssueFailed_PNR", CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation))).append("\n").append(IssuingFailedNotificationHelper.getLocalizedString("NotificationIssueFailed_Contact", TextUtil.buildFullName((PersonalName)bf.getCustomer().getPassport()))).append("\n");
            String mobilePhone = "";
            String email = "";
            for (Communication comm : bf.getCustomer().getCommunications()) {
                if (comm.getType() == CommunicationType.EMAIL) {
                    email = comm.getSense();
                    continue;
                }
                if (comm.getType() != CommunicationType.CELL && comm.getType() != CommunicationType.MOBILE && comm.getType() != CommunicationType.HOME_PHONE) continue;
                mobilePhone = "+" + comm.getCountryCode() + comm.getCityCode() + comm.getSense();
            }
            if (!mobilePhone.isEmpty()) {
                text.append(IssuingFailedNotificationHelper.getLocalizedString("NotificationIssueFailed_Contact", mobilePhone)).append("\n");
            }
            if (!email.isEmpty()) {
                text.append(IssuingFailedNotificationHelper.getLocalizedString("NotificationIssueFailed_CustomerEmail", email)).append("\n");
            }
            text.append(IssuingFailedNotificationHelper.getLocalizedString("NotificationIssueFailed_FOP", payment.getPaymentType()));
        }
        catch (Throwable t) {
            log.error("failed creating issuing error info email", t);
        }
        return text.toString();
    }

    private static String getLocalizedString(String key, Object ... parameters) {
        return L10nResourcesManager.createL10nMessage((String)key, (Object[])parameters).toString();
    }
}

