/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.notifications;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.ibecorp.l10n.Messages;
import com.gridnine.xtrip.common.ibecorp.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.ibecorp.rules.NotificationSettingsActions;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.ibecorp.NotificationRecipientType;
import com.gridnine.xtrip.common.model.ibecorp.NotificationType;
import com.gridnine.xtrip.common.model.ibecorp.sm.BaseSMProfile;
import com.gridnine.xtrip.common.model.ibecorp.sm.BaseSMProfileIndex;
import com.gridnine.xtrip.common.model.ibecorp.sm.MailTemplate;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMNotificationsSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMProfileType;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMVisualSettings;
import com.gridnine.xtrip.common.model.mail.MailPart;
import com.gridnine.xtrip.common.model.mail.MailServerParameters;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonNotificationSettings;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.DownloadableData;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.SiteConverterHelper;
import com.gridnine.xtrip.server.ibecorp.helpers.IbecorpRulesHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.ibecorp.notifications.handlers.NotificationHandler;
import com.gridnine.xtrip.server.ibecorp.notifications.handlers.NotificationHandlerFactory;
import com.gridnine.xtrip.server.ibecorp.notifications.handlers.NotificationHandlerParameters;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import com.gridnine.xtrip.server.model.mail.MailConfigUtil;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Notification
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Notification.class);
    private static final long serialVersionUID = 1750218346716705431L;
    private final Map<String, Object> context = new HashMap<String, Object>();
    private final Set<MailPart> attachments = new HashSet<MailPart>();
    private final Set<String> agentRecipients = new HashSet<String>();
    private final Set<String> customerRecipients = new HashSet<String>();
    private final Set<String> travellersRecipients = new HashSet<String>();
    private final Set<String> otherRecipients = new HashSet<String>();
    private final Locale curLocale;
    protected final DateFormat dateF;
    protected final DateFormat timeF;
    protected final EntityReference<?> owner;
    private EntityReference<BaseSMProfile> notificationSettingsRef;
    private SMNotificationsSettings notificationSettings;
    private MailServerParameters mailServerParameters;
    private String fromAddress;
    private boolean related = false;
    private boolean important = false;
    private final SalesContext ctx;
    private ProductType productType;
    private final NotificationParameters notificationParameters;
    protected final Set<NotificationRecipientType> availableRecipientTypes = new HashSet<NotificationRecipientType>();
    protected boolean ignoreAvailableRecipientTypes = false;
    private Map<EntityReference<Person>, Boolean> disabledByPersonMap = new HashMap<EntityReference<Person>, Boolean>();
    private SMGeneralSettings smGeneralSettings;
    private boolean getRecipientsCalled;

    protected NotificationType getNotificationType() {
        return null;
    }

    protected NotificationType getOldNotificationType() {
        return null;
    }

    protected boolean isOldLogic() {
        return true;
    }

    protected Notification(NotificationParameters parameters) {
        this(parameters, Collections.emptyList());
    }

    protected Notification(NotificationParameters parameters, Collection<NotificationRecipientType> defaultRecipientTypes) {
        this.notificationParameters = parameters;
        this.owner = parameters.getOwnerRef();
        this.curLocale = (Locale)MiscUtil.guarded((Object)parameters.getLocale(), LocaleHelper::getCurrentLocale);
        this.ctx = parameters.getSalesContext();
        this.dateF = new SimpleDateFormat("dd.MM.yyyy");
        this.timeF = new SimpleDateFormat("HH:mm");
        this.addContextAgency(parameters);
        this.addContextClient(parameters);
        this.buildAvailableRecipientTypes(defaultRecipientTypes);
        try {
            EntityReference<SMSite> siteRef = parameters.getSiteRef();
            if (siteRef != null) {
                SearchQuery query = new SearchQuery();
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BaseSMProfileIndex.Property.site.name(), siteRef));
                List indexes = EntityStorage.get().search(BaseSMProfileIndex.class, query).getData();
                for (BaseSMProfileIndex index : indexes) {
                    EntityContainer siteCont;
                    if (index.getProfileType() == SMProfileType.ACCESS_SETTINGS && (siteCont = EntityStorage.get().resolve(siteRef)) != null && siteCont.getEntity() != null) {
                        this.addProperty("domain", ((SMSite)siteCont.getEntity()).getDomain());
                    }
                    if (index.getProfileType() != SMProfileType.NOTIFICATIONS_SETTINGS) continue;
                    SMNotificationsSettings notificationsSettings = (SMNotificationsSettings)EntityStorage.get().resolve(index.getSource()).getEntity();
                    this.addProperty("receiveFrom", notificationsSettings.getFromName());
                    this.notificationSettingsRef = index.getSource();
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("error while searching/resolving profile settings", ex);
        }
    }

    protected void buildAvailableRecipientTypes(Collection<NotificationRecipientType> defaultRecipientTypes) {
        if (defaultRecipientTypes.isEmpty()) {
            return;
        }
        this.availableRecipientTypes.addAll(defaultRecipientTypes);
        NotificationType notificationType = (NotificationType)MiscUtil.guarded((Object)this.getOldNotificationType(), (Object)this.getNotificationType());
        StringBuilder sbDetails = new StringBuilder();
        sbDetails.append(EnumUtil.stringValueOf((Enum)notificationType)).append("\n");
        if (notificationType != null) {
            try {
                Set<NotificationRecipientType> disabledRecipientTypes = IbecorpRulesHelper.getDisabledNotificationRecipientTypes(notificationType, this.notificationParameters);
                if (!disabledRecipientTypes.isEmpty()) {
                    sbDetails.append(this.getAvailableRecipientTypesText(notificationType)).append("\n");
                    this.availableRecipientTypes.removeIf(disabledRecipientTypes::contains);
                    NotificationSettingsActions.DISABLE_NOTIFICATION_RECIPIENT_TYPES.buildInfo(sbDetails, new ArrayList<NotificationRecipientType>(disabledRecipientTypes));
                    sbDetails.append("\n");
                }
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)"buildAvailableRecipientTypes failed", (Throwable)e, (Object[])new Object[0]);
            }
        }
        String text = this.getAvailableRecipientTypesText(notificationType);
        sbDetails.append(text);
        SysLogHelper.audit(this.notificationParameters.getOwnerRef(), (String)"notification-settings", (Message[])new Message[]{MessagesHelper.createMessageWithDetails((MessageType)MessageType.MESSAGE, (String)text, (String)sbDetails.toString(), (Object[])new Object[0])});
    }

    private String getAvailableRecipientTypesText(NotificationType notificationType) {
        return L10n.getWithParams((String)"AvailableRecipientTypes", (Object[])new Object[]{notificationType, this.availableRecipientTypes});
    }

    private void addContextAgency(NotificationParameters parameters) {
        try {
            EntityContainer agencyCtr = EntityStorage.get().resolve(parameters.getAgencyRef());
            if (agencyCtr == null) {
                return;
            }
            Organization agency = (Organization)agencyCtr.getEntity();
            this.addProperty("agencyFullName", agency.getFullName());
            this.addProperty("agencyShortName", agency.getShortName());
            LinkedList<String> phones = new LinkedList<String>();
            for (Communication communication : agency.getCommunications()) {
                if (CommunicationType.WORK_PHONE.equals((Object)communication.getType()) || CommunicationType.AGENCY.equals((Object)communication.getType())) {
                    phones.add(com.gridnine.xtrip.common.model.helpers.ProfileHelper.buildFullPhoneNumber((Communication)communication));
                    continue;
                }
                if (!CommunicationType.EMAIL.equals((Object)communication.getType())) continue;
                this.addProperty("companyEmail", communication.getSense());
            }
            if (phones.size() > 0) {
                this.addProperty("agencyPhone", CollectionUtil.collectionToString(phones, (String)"; ", (boolean)false));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("error while resolving agency reference", ex);
        }
    }

    private void addContextClient(NotificationParameters parameters) {
        EntityContainer clientCtr = EntityStorage.get().resolve(parameters.getClientRef());
        if (clientCtr != null) {
            this.addProperty("clientCode", ((Organization)clientCtr.getEntity()).getCode());
        }
    }

    public EntityReference<?> getOwner() {
        return this.owner;
    }

    public Locale getLocale() {
        return this.curLocale;
    }

    public boolean isRelated() {
        return this.related;
    }

    private void setRelated(boolean value) {
        this.related = value;
    }

    public boolean isImportant() {
        return this.important;
    }

    protected void setImportant(boolean value) {
        this.important = value;
    }

    private void addLogo(BinaryData logo) {
        if (logo == null) {
            return;
        }
        MailPart attachment = new MailPart();
        attachment.setContentType(logo.getContentType());
        attachment.setData(logo.getData());
        attachment.setName("logo." + Notification.getFileExtensionForContentType(logo.getContentType()));
        this.attachments.add(attachment);
        this.addProperty("logoCid", attachment.getUid());
        this.setRelated(true);
    }

    protected final String addImage(DownloadableData image) {
        if (null == image) {
            return null;
        }
        MailPart attachment = new MailPart();
        attachment.setInline(true);
        BinaryData content = image.getContent();
        attachment.setContentType(content.getContentType());
        attachment.setData(content.getData());
        attachment.setName(image.getFileName());
        this.attachments.add(attachment);
        this.setRelated(true);
        String name = image.getFileName();
        int p = name.indexOf(".");
        if (p != -1) {
            name = name.substring(0, p);
        }
        this.addProperty(name, attachment.getUid());
        return attachment.getUid();
    }

    protected final String addImage(String key, BinaryData image) {
        if (null == image) {
            return null;
        }
        MailPart attachment = new MailPart();
        attachment.setContentType(image.getContentType());
        attachment.setData(image.getData());
        attachment.setInline(true);
        this.attachments.add(attachment);
        this.setRelated(true);
        this.addProperty(key, attachment.getUid());
        return attachment.getUid();
    }

    protected final void addDocument(BaseFileDocument doc) {
        if (doc == null) {
            return;
        }
        MailPart attachment = new MailPart();
        attachment.setContentType(doc.getContentType());
        attachment.setData(doc.getContent());
        attachment.setName(doc.getName());
        attachment.setTitle(doc.getTitle());
        this.attachments.add(attachment);
    }

    public final Map<String, Object> getContext() {
        return new HashMap<String, Object>(this.context);
    }

    public final void addProperty(String key, Object value) {
        this.context.put(key, value);
    }

    public final Object getProperty(String key) {
        return this.context.get(key);
    }

    protected final void addCommonProperties(BookingFile bookingFile, Reservation reservation) {
        EntityReference siteRef = bookingFile.getSite();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BaseSMProfileIndex.Property.site.name(), (Object)siteRef));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BaseSMProfileIndex.Property.profileType.name(), (Object)SMProfileType.VISUAL_SETTINGS));
        List data = EntityStorage.get().search(BaseSMProfileIndex.class, query).getData();
        if (!data.isEmpty()) {
            SMVisualSettings visualSettings = (SMVisualSettings)EntityStorage.get().resolve(((BaseSMProfileIndex)data.get(0)).getSource()).getEntity();
            BinaryData logo = SiteConverterHelper.getLocalBinaryData(visualSettings.getLogo(), Optional.ofNullable(this.curLocale).map(Locale::getLanguage).orElse(null));
            MailTemplate template = this.getTemplate();
            if (logo != null && template != null && this.getTemplateData(template).contains("cid:${logoCid}")) {
                this.addLogo(logo);
            }
        }
        this.addProperty("orderNumber", bookingFile.getNumber());
        this.addContextTravellerNames(bookingFile);
        this.addContextClient(bookingFile);
        if (bookingFile.getCustomer() != null) {
            this.addProperty("customer", TextUtil.buildFullName((PersonalName)bookingFile.getCustomer().getPassport()));
            for (Communication comm : bookingFile.getCustomer().getCommunications()) {
                switch (comm.getType()) {
                    case EMAIL: {
                        if (this.context.containsKey("contactEmail")) break;
                        this.addProperty("contactEmail", comm.getSense());
                        if (!this.availableRecipientTypes.contains(NotificationRecipientType.CUSTOMER) || this.disabledByPerson((EntityReference<Person>)bookingFile.getCustomer().getProfile())) break;
                        this.customerRecipients.add(comm.getSense());
                        break;
                    }
                    case CELL: 
                    case MOBILE: 
                    case HOME_PHONE: 
                    case WORK_PHONE: {
                        if (this.context.containsKey("contactPhone")) break;
                        StringBuilder customerPhone = new StringBuilder();
                        customerPhone.append("+").append(comm.getCountryCode()).append("(").append(comm.getCityCode()).append(")").append(comm.getSense());
                        if (comm.getType() == CommunicationType.WORK_PHONE && !TextUtil.isBlank((String)comm.getInternalNumber())) {
                            customerPhone.append("#").append(comm.getInternalNumber());
                        }
                        this.addProperty("contactPhone", customerPhone.toString());
                        break;
                    }
                }
            }
        }
        if (this.availableRecipientTypes.contains(NotificationRecipientType.TRAVELLERS)) {
            if (reservation != null) {
                this.addTravellersRecipients(reservation);
            } else {
                this.addTravellersRecipients(bookingFile);
            }
        }
    }

    private boolean disabledByPerson(EntityReference<Person> personRef) {
        if (personRef == null) {
            return false;
        }
        Boolean cachedResult = this.disabledByPersonMap.get(personRef);
        if (cachedResult != null) {
            return cachedResult;
        }
        return this.disabledByPerson((EntityContainer<Person>)EntityStorage.get().resolve(personRef));
    }

    private boolean disabledByPerson(EntityContainer<Person> personCtr) {
        if (this.getNotificationType() == null) {
            return false;
        }
        if (personCtr == null) {
            return false;
        }
        Boolean cachedResult = this.disabledByPersonMap.get(personCtr.toReference());
        if (cachedResult != null) {
            return cachedResult;
        }
        List<EntityReference> ctxOrgRefs = Arrays.asList(this.ctx.getClient(), this.ctx.getSubagency(), this.ctx.getAgency());
        for (EntityReference orgRef : ctxOrgRefs) {
            PersonNotificationSettings personNotificationSettings = NotificationHelper.getPersonNotificationSettings((Person)personCtr.getEntity(), (EntityReference<Organization>)orgRef);
            if (personNotificationSettings == null) continue;
            boolean result = personNotificationSettings.getDisabledNotificationTypes().contains(this.getNotificationType());
            this.disabledByPersonMap.put((EntityReference<Person>)personCtr.toReference(), result);
            return result;
        }
        return false;
    }

    private void addTravellersRecipients(Reservation reservation) {
        this.addTravellersRecipients(CommonHelper.getReservationTravellersStream(reservation));
    }

    protected void addTravellersRecipients(BookingFile bookingFile) {
        this.addTravellersRecipients(bookingFile.getTravellers().stream());
    }

    private void addTravellersRecipients(Stream<Traveller> travellerStream) {
        travellerStream.filter(tr -> !this.disabledByPerson((EntityReference<Person>)tr.getPassenger())).map(Traveller::getCommunications).map(com.gridnine.xtrip.common.model.helpers.ProfileHelper::getCommunicationEmail).filter(TextUtil::nonBlank).forEach(this.travellersRecipients::add);
    }

    private void addContextClient(BookingFile bookingFile) {
        if (bookingFile.getCustomerProfile() != null) {
            this.addProperty("client", bookingFile.getCustomerProfile().getCaption());
        }
    }

    private void addContextTravellerNames(BookingFile bookingFile) {
        this.addProperty("travellerNames", this.buildTravellerNames(bookingFile.getTravellers()));
    }

    private String buildTravellerNames(List<Traveller> travellers) {
        return travellers.stream().map(Traveller::getName).collect(Collectors.joining(", "));
    }

    protected String buildTravellerNames(Collection<BaseProduct> products) {
        List<Traveller> reservationTravellers = CommonHelper.getProductTravellersStream(products).collect(Collectors.toList());
        return this.buildTravellerNames(reservationTravellers);
    }

    protected final void addReservationProperties(Reservation reservation) {
        BookingFile bookingFile = reservation.getBookingFile();
        this.addCommonProperties(bookingFile, reservation);
        this.addProperty("currentTravellerNames", this.buildTravellerNames(reservation.getProducts()));
        NotificationHandler handler = NotificationHandlerFactory.getInstance().createHandler(reservation);
        this.productType = handler.getProductType();
        SMGeneralSettings smGeneralSettings = this.getSmGeneralSettings(bookingFile);
        SMSiteType siteType = ((SMSite)EntityStorage.get().resolve(bookingFile.getSite()).getEntity()).getSiteType();
        this.buildResumeLink(reservation, siteType);
        this.addProperty("pnr", this.getPnr(reservation));
        this.addProperty("tickets", this.getProductsNumbers(reservation.getProducts()));
        this.addProperty("createDate", NotificationHelper.safeDtFormat(this.dateF, reservation.getResDate()));
        this.addProperty("createTime", NotificationHelper.safeDtFormat(this.timeF, reservation.getResDate()));
        LocalDateTime timeLimit = CommonHelper.getCorrectTimeLimit(reservation, smGeneralSettings);
        Date tlDate = DateUtils.toJavaDate((LocalDateTime)timeLimit);
        String tlDateStr = NotificationHelper.safeDtFormat(this.dateF, tlDate);
        String tlTimeStr = NotificationHelper.safeDtFormat(this.timeF, tlDate);
        this.addProperty("timeLimitDate", tlDateStr);
        this.addProperty("timeLimitTime", tlTimeStr);
        this.addProperty("timeLimitDateUpper", tlDateStr);
        this.addProperty("timeLimitTimeUpper", tlTimeStr);
        this.addProperty("timeLimitCity", CommonHelper.getTimeZone(smGeneralSettings).getTimeZoneCity().toString(this.curLocale));
        handler.fillContext(this.context, reservation, new NotificationHandlerParameters(this.curLocale, this.dateF, this.timeF, this.ctx));
        if (siteType == SMSiteType.B2B && this.availableRecipientTypes.contains(NotificationRecipientType.BOOKING_AGENT)) {
            this.addAgentRecipients(reservation);
        }
    }

    protected SMGeneralSettings getSmGeneralSettings(BookingFile bookingFile) {
        if (this.smGeneralSettings == null) {
            EntityReference profile = ProfileHelper.getProfile((EntityReference)bookingFile.getSite(), (SMProfileType)SMProfileType.GENERAL_SETTINGS);
            this.smGeneralSettings = (SMGeneralSettings)EntityStorage.get().resolve(profile).getEntity();
        }
        return this.smGeneralSettings;
    }

    protected void addAgentRecipients(Reservation reservation) {
        EntityReference bookingAgentRef = reservation.getBookingAgent();
        if (bookingAgentRef == null) {
            log.error(String.format("Booking agent is not found in booking file %s", reservation.getBookingFile().getNumber()));
            return;
        }
        EntityContainer agentCtr = EntityStorage.get().resolve(bookingAgentRef);
        if (this.disabledByPerson((EntityContainer<Person>)agentCtr)) {
            return;
        }
        for (Communication comm : ((Person)agentCtr.getEntity()).getCommunications()) {
            if (comm.getType() != CommunicationType.EMAIL || !StringUtils.isNotBlank((String)comm.getSense())) continue;
            this.agentRecipients.add(comm.getSense());
        }
    }

    public void buildResumeLink(Reservation reservation, SMSiteType siteType) {
        StringBuilder resumeLinkBuilder = new StringBuilder();
        String schema = this.notificationParameters.getUrlScheme() != null ? this.notificationParameters.getUrlScheme() : "http";
        resumeLinkBuilder.append(schema).append("://");
        resumeLinkBuilder.append(this.getProperty("domain"));
        resumeLinkBuilder.append("/");
        if (siteType == SMSiteType.B2B) {
            resumeLinkBuilder.append("#cabinet/order/");
            resumeLinkBuilder.append(this.owner.getUid());
        } else if (reservation != null) {
            resumeLinkBuilder.append(this.curLocale.getLanguage());
            resumeLinkBuilder.append("/resume.html?booking=");
            resumeLinkBuilder.append(this.owner.getUid());
        }
        this.addProperty("resumeLink", resumeLinkBuilder.toString());
    }

    private Object getPnr(Reservation reservation) {
        return RzdCommonHelper.getRelatedReservations((Reservation)reservation).stream().map(CommonReservationGdsNameInfoHelper::getDisplayedRecordLocator).collect(Collectors.joining(","));
    }

    protected String getProductsNumbers(Collection<BaseProduct> products) {
        return products.stream().flatMap(bp -> ProductHandler.of((BaseProduct)bp).getProductNumbers(bp).stream()).filter(Objects::nonNull).sorted().distinct().collect(Collectors.joining(","));
    }

    private static String getFileExtensionForContentType(ContentType type) {
        switch (type) {
            case GIF: {
                return "gif";
            }
            case JPEG: {
                return "jpg";
            }
            case PNG: {
                return "png";
            }
            case EXCEL: {
                return "xls";
            }
            case HTML: {
                return "html";
            }
            case PDF: {
                return "pdf";
            }
            case TEXT: {
                return "txt";
            }
            case WORD: {
                return "doc";
            }
            case XML: {
                return "xml";
            }
        }
        return null;
    }

    public abstract String getDefaultSubject(Locale var1);

    public abstract MailTemplate getTemplate();

    public SMNotificationsSettings getNotificationSettings() {
        if (this.notificationSettings != null) {
            return this.notificationSettings;
        }
        if (this.notificationSettingsRef == null) {
            throw Xeption.forEndUser((String)Messages.DocumentSendSettingsNotFound, (Object[])new Object[0]);
        }
        try {
            this.notificationSettings = (SMNotificationsSettings)((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(this.notificationSettingsRef).getEntity();
            return this.notificationSettings;
        }
        catch (Exception ex) {
            throw new RuntimeException("error while resolving notification settings reference", ex);
        }
    }

    public MailServerParameters getOrDefaultMailServerParameters() {
        if (this.mailServerParameters != null) {
            return this.mailServerParameters;
        }
        if (this.notificationSettings == null) {
            try {
                EntityContainer ctr = ((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(this.notificationSettingsRef);
                if (ctr != null) {
                    this.notificationSettings = (SMNotificationsSettings)ctr.getEntity();
                    this.mailServerParameters = this.notificationSettings.getMailServerParameters();
                    return this.mailServerParameters;
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("error while resolving notification settings reference", ex);
            }
        }
        this.mailServerParameters = MailConfigUtil.readMailServerParameters().getMailServerParameters();
        return this.mailServerParameters;
    }

    public String getOrDefaultFromAddress() {
        if (this.fromAddress != null) {
            return this.fromAddress;
        }
        if (this.notificationSettings == null) {
            try {
                EntityContainer ctr = ((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(this.notificationSettingsRef);
                if (ctr != null) {
                    this.notificationSettings = (SMNotificationsSettings)ctr.getEntity();
                    this.fromAddress = this.notificationSettings.getFromAddress();
                    return this.fromAddress;
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("error while resolving notification settings reference", ex);
            }
        }
        this.fromAddress = MailConfigUtil.readMailServerParameters().getDefaultFrom();
        return this.fromAddress;
    }

    public String getTemplateSubject(MailTemplate template) {
        String localeSubject = null;
        if (template != null) {
            if ("ru".equalsIgnoreCase(this.getLocale().getLanguage())) {
                localeSubject = template.getSubjectRu();
            } else if ("en".equalsIgnoreCase(this.getLocale().getLanguage())) {
                localeSubject = template.getSubjectEn();
            } else if ("bg".equalsIgnoreCase(this.getLocale().getLanguage())) {
                localeSubject = template.getSubjectBg();
            } else if ("uk".equalsIgnoreCase(this.getLocale().getLanguage())) {
                localeSubject = template.getSubjectUk();
            } else if ("hy".equalsIgnoreCase(this.getLocale().getLanguage())) {
                localeSubject = template.getSubjectHy();
            } else if ("az".equalsIgnoreCase(this.getLocale().getLanguage())) {
                localeSubject = template.getSubjectAz();
            } else if ("kk".equalsIgnoreCase(this.getLocale().getLanguage())) {
                localeSubject = template.getSubjectKz();
            }
        }
        return localeSubject == null ? "" : localeSubject;
    }

    public String getTemplateData(MailTemplate template) {
        String localeData = null;
        if ("ru".equalsIgnoreCase(this.getLocale().getLanguage())) {
            localeData = template.getDataRu();
        } else if ("en".equalsIgnoreCase(this.getLocale().getLanguage())) {
            localeData = template.getDataEn();
        } else if ("bg".equalsIgnoreCase(this.getLocale().getLanguage())) {
            localeData = template.getDataBg();
        } else if ("uk".equalsIgnoreCase(this.getLocale().getLanguage())) {
            localeData = template.getDataUk();
        } else if ("hy".equalsIgnoreCase(this.getLocale().getLanguage())) {
            localeData = template.getDataHy();
        } else if ("az".equalsIgnoreCase(this.getLocale().getLanguage())) {
            localeData = template.getDataAz();
        } else if ("kk".equalsIgnoreCase(this.getLocale().getLanguage())) {
            localeData = template.getDataKz();
        }
        return localeData == null ? "" : localeData;
    }

    public final MailPart[] getAttachments() {
        return this.attachments.toArray(new MailPart[0]);
    }

    public final String[] getRecipients() {
        if (!this.getRecipientsCalled) {
            String disabledPersons;
            this.getRecipientsCalled = true;
            EntityReference<?> owner = this.getOwner();
            if (owner != null && TextUtil.nonBlank((String)(disabledPersons = this.disabledByPersonMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).map(EntityReference::getCaption).collect(Collectors.joining(", "))))) {
                SysLogHelper.audit(owner, (String)"notification-settings", (Message[])new Message[]{MessagesHelper.createMessageWithDetails((MessageType)MessageType.MESSAGE, (String)L10n.getWithParams((String)"NotificationIsDisabledForPersons", (Object[])new Object[]{this.getNotificationType().toString()}), (String)disabledPersons, (Object[])new Object[0])});
            }
        }
        HashSet<String> result = new HashSet<String>(this.otherRecipients);
        if (this.ignoreAvailableRecipientTypes || this.availableRecipientTypes.contains(NotificationRecipientType.BOOKING_AGENT)) {
            result.addAll(this.agentRecipients);
        }
        if (this.ignoreAvailableRecipientTypes || this.availableRecipientTypes.contains(NotificationRecipientType.CUSTOMER)) {
            result.addAll(this.customerRecipients);
        }
        if (this.ignoreAvailableRecipientTypes || this.availableRecipientTypes.contains(NotificationRecipientType.TRAVELLERS)) {
            result.addAll(this.travellersRecipients);
        }
        return result.toArray(new String[0]);
    }

    protected final void addCustomerRecipient(String recipient) {
        this.customerRecipients.add(recipient);
    }

    public final void addOtherRecipient(String recipient) {
        this.otherRecipients.add(recipient);
    }

    public Locale getCurLocale() {
        return this.curLocale;
    }

    public ProductType getProductType() {
        return this.productType;
    }

    public NotificationParameters getNotificationParameters() {
        return this.notificationParameters;
    }
}

