/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.notifications;

import com.gridnine.bof.midoffice.helper.MidofficeHelper;
import com.gridnine.bof.midoffice.tpt.TPTEngine;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.ibecorp.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.ibecorp.NotificationSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.MailTemplate;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMNotificationsSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMProfileType;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.mail.MailAddress;
import com.gridnine.xtrip.common.model.mail.MailDocument;
import com.gridnine.xtrip.common.model.mail.MailPart;
import com.gridnine.xtrip.common.model.mail.MailServerParameters;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonNotificationSettings;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.Callback;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.ibecorp.notifications.IntentionCancelledNotification;
import com.gridnine.xtrip.server.ibecorp.notifications.Notification;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.ibecorp.notifications.ReservationCancelledNotification;
import com.gridnine.xtrip.server.ibecorp.notifications.ReservationCreatedNotification;
import com.gridnine.xtrip.server.ibecorp.notifications.ServiceFeeReceiptNotification;
import com.gridnine.xtrip.server.ibecorp.notifications.ServicesIssuedNotification;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import com.gridnine.xtrip.server.model.mail.MailSender;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationHelper {
    private static final Logger log = LoggerFactory.getLogger(NotificationHelper.class);
    private static final String TEMPLATE_BODY = "body";
    private static final String TEMPLATE_SUBJECT = "subject";
    static final String RESERVATION_PROPERTIES_FAILED = "reservationPropertiesFailed";
    private static final Pattern BODY_PATTERN = Pattern.compile("\\$\\{body\\d*}");
    private static final Pattern ASSIGN = Pattern.compile("<#assign .*>");
    private static final String NAME_GROUP = "field";
    private static final Pattern TEG_PATTERN = Pattern.compile("(?<teg>\\$\\{(?<field>.*?)})");
    private static final String REPLACEMENT = "<#if field?has_content> \\$\\{field} <#else>***</#if>";

    private static String getDebugData(Notification notification) {
        StringBuilder result = new StringBuilder(" ");
        result.append(", Name templates: ").append(NotificationHelper.getLocaleSubject(notification, null));
        result.append(", PNR:").append(notification.getProperty("pnr"));
        result.append(", Agency:").append(notification.getProperty("agencyShortName"));
        result.append(", Mail host:").append(notification.getOrDefaultMailServerParameters().getHost());
        return result.toString();
    }

    public static String safeDtFormat(DateFormat df, Date dt) {
        return dt == null ? "" : df.format(dt);
    }

    public static String formatTemplate(String baseName, Locale locale, Map<String, Object> params, Class<?> clazz) throws IOException, TemplateException {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_29);
        cfg.setClassForTemplateLoading(clazz, "notification/templates");
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        cfg.setWrapUncheckedExceptions(true);
        cfg.setFallbackOnNullLoopVariable(false);
        Template temp = cfg.getTemplate(baseName + ".ftlh", locale);
        try (StringWriter out = new StringWriter();){
            temp.process(params, (Writer)out);
            String string = ((Object)out).toString();
            return string;
        }
    }

    public static String getLocaleSubject(Notification notification, MailTemplate template) {
        String localeSubject = notification.getTemplateSubject(template);
        if (StringUtils.isBlank((String)localeSubject)) {
            localeSubject = notification.getDefaultSubject(notification.getCurLocale());
        }
        return localeSubject;
    }

    public static MailDocument buildMailDocument(Notification notification, boolean sendBccAddresses) throws Exception {
        return NotificationHelper.buildMailDocument(notification, sendBccAddresses, null);
    }

    public static MailDocument buildMailDocument(Notification notification, boolean sendBccAddresses, MailAddress mailFrom) throws Exception {
        MailAddress maFrom;
        MailTemplate template = notification.getTemplate();
        if (template == null) {
            throw Xeption.forEndUser((String)"\u0428\u0430\u0431\u043b\u043e\u043d \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d", (Object[])new Object[0]);
        }
        String templateData = notification.getTemplateData(template);
        String localeTemplate = NotificationHelper.getTemplateDataGuarded(templateData);
        String templateLocaleSubject = NotificationHelper.getLocaleSubject(notification, template);
        String localeSubject = NotificationHelper.getTemplateDataGuarded(templateLocaleSubject);
        HashSet<MailAddress> toAddresses = new HashSet<MailAddress>();
        for (String s : notification.getRecipients()) {
            MailAddress ma = new MailAddress();
            ma.setAddress(s);
            toAddresses.add(ma);
        }
        HashSet<MailAddress> bccAddresses = new HashSet<MailAddress>();
        if (sendBccAddresses) {
            for (String s : template.getAdditionalAddresses()) {
                MailAddress ma = new MailAddress();
                ma.setAddress(s);
                bccAddresses.add(ma);
            }
        }
        MailPart body = new MailPart();
        body.setContentType(ContentType.HTML);
        body.setName("body.html");
        body.setData(NotificationHelper.formatString(localeTemplate, notification.getContext()).getBytes(StandardCharsets.UTF_8));
        String subject = NotificationHelper.formatString(localeSubject, notification.getContext());
        if (mailFrom == null) {
            maFrom = new MailAddress();
            maFrom.setAddress(notification.getOrDefaultFromAddress());
        } else {
            maFrom = mailFrom;
        }
        return NotificationHelper.buildMailDocument(notification.getOwner(), maFrom, toAddresses, null, bccAddresses, subject, body, notification.isImportant(), notification.isRelated(), notification.getAttachments());
    }

    private static String formatString(String template, Map<String, Object> params) throws IOException, TemplateException {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_29);
        StringTemplateLoader templateLoader = new StringTemplateLoader();
        templateLoader.putTemplate("", template);
        cfg.setTemplateLoader((TemplateLoader)templateLoader);
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        cfg.setWrapUncheckedExceptions(true);
        cfg.setFallbackOnNullLoopVariable(false);
        Template temp = cfg.getTemplate("");
        try (StringWriter out = new StringWriter();){
            temp.process(params, (Writer)out);
            String string = ((Object)out).toString();
            return string;
        }
    }

    public static Notification getCancelReservationNotification(NotificationParameters parameters, Reservation reservation) {
        if (reservation.getProducts().isEmpty()) {
            return null;
        }
        BaseProduct product = (BaseProduct)reservation.getProducts().get(0);
        return ProductHandler.of((BaseProduct)product).getStatus(product) == ProductStatus.VOID_INTENTION ? new IntentionCancelledNotification(parameters, reservation) : new ReservationCancelledNotification(parameters, reservation);
    }

    public static void sendNotification(Supplier<Notification> notificationSupplier, EntityReference<?> ownerRef, boolean saveDocument) {
        NotificationHelper.sendNotification(notificationSupplier, ownerRef, notification -> false, saveDocument);
    }

    private static void sendNotification(Supplier<Notification> notificationSupplier, EntityReference<?> ownerRef, Predicate<Notification> notificationIgnore, boolean saveDocument) {
        try {
            Notification notification = notificationSupplier.get();
            if (notification == null || notificationIgnore.test(notification)) {
                return;
            }
            NotificationHelper.sendNotification(notification, saveDocument);
        }
        catch (Exception ex) {
            NotificationHelper.logAudit(ownerRef, "exception while preparing notification", (Throwable)ex, new Object[0]);
            log.error("exception while preparing notification", (Throwable)ex);
        }
    }

    private static void sendNotification(Notification notification, boolean saveDocument) {
        try {
            if (notification.getRecipients().length == 0) {
                NotificationHelper.logAudit(notification, "EmptyNotificationRecipients", new Object[0]);
                return;
            }
            MailDocument mailDocument = NotificationHelper.prepareMailDocument(notification);
            if (mailDocument == null) {
                NotificationHelper.logAudit(notification, "FailedCreateMailDocument", new Object[0]);
                log.warn("failed to create mail document from notification" + NotificationHelper.getDebugData(notification));
                return;
            }
            MailServerParameters msp = notification.getOrDefaultMailServerParameters();
            if (NotificationHelper.sendMail(msp, mailDocument, saveDocument)) {
                log.info("notification sent successfully" + NotificationHelper.getDebugData(notification));
            } else {
                NotificationHelper.logAudit(notification, "SentFailed", new Object[0]);
                log.info("failed sent notification" + NotificationHelper.getDebugData(notification));
            }
        }
        catch (Exception ex) {
            NotificationHelper.logAudit(notification, "exception while sending notification" + NotificationHelper.getDebugData(notification), (Throwable)ex, new Object[0]);
            log.error("exception while sending notification" + NotificationHelper.getDebugData(notification), (Throwable)ex);
        }
    }

    public static MailDocument prepareMailDocument(final Notification notification) {
        String subject;
        final MailTemplate template = notification.getTemplate();
        if (template == null) {
            NotificationHelper.logAudit(notification, "TemplateNotConfigured", NotificationHelper.getLocaleSubject(notification, null));
            log.warn("Template not configured :" + NotificationHelper.getLocaleSubject(notification, null));
            return null;
        }
        final String localeTemplate = notification.getTemplateData(template);
        final String bodyIndex = NotificationHelper.getBodyIndex(localeTemplate);
        TPTEngine engine = new TPTEngine(new TPTEngine.Resolver(){

            public InputStream resolve(String s) {
                if (NotificationHelper.TEMPLATE_BODY.equals(s)) {
                    StringBuilder sb = new StringBuilder();
                    try (InputStreamReader rdr = new InputStreamReader(this.getClass().getResourceAsStream(NotificationHelper.buildResourceName(notification, "notification_body" + bodyIndex + "_" + notification.getLocale().getLanguage().toLowerCase() + ".txt")), StandardCharsets.UTF_8);){
                        int read;
                        char[] buf = new char[256];
                        while ((read = rdr.read(buf)) != -1) {
                            sb.append(buf, 0, read);
                        }
                    }
                    catch (IOException | NullPointerException e) {
                        log.error("error while resolving body template notification_body for TPTEngine" + NotificationHelper.getDebugData(notification), (Throwable)e);
                    }
                    return new ByteArrayInputStream(localeTemplate.replace("${body" + bodyIndex + "}", sb.toString()).getBytes(StandardCharsets.UTF_8));
                }
                if (NotificationHelper.TEMPLATE_SUBJECT.equals(s)) {
                    String localeSubject = NotificationHelper.getLocaleSubject(notification, template);
                    return new ByteArrayInputStream(localeSubject.getBytes(StandardCharsets.UTF_8));
                }
                return null;
            }
        });
        HashSet<MailAddress> toAddresses = new HashSet<MailAddress>();
        for (String s : notification.getRecipients()) {
            MailAddress ma = new MailAddress();
            ma.setAddress(s);
            toAddresses.add(ma);
        }
        HashSet<MailAddress> bccAddresses = new HashSet<MailAddress>();
        for (String s : template.getAdditionalAddresses()) {
            MailAddress ma = new MailAddress();
            ma.setAddress(s);
            bccAddresses.add(ma);
        }
        MailPart body = new MailPart();
        body.setContentType(ContentType.HTML);
        body.setName("body.html");
        boolean propertiesFailed = BooleanUtil.nullAsFalse((Boolean)((Boolean)notification.getProperty(RESERVATION_PROPERTIES_FAILED)));
        if (!propertiesFailed) {
            try {
                StringBuilder buf = new StringBuilder();
                engine.render(TEMPLATE_BODY, notification.getContext(), (Appendable)buf);
                body.setData(buf.toString().getBytes(StandardCharsets.UTF_8));
            }
            catch (Exception ex) {
                log.error("exception while rendering body text through TPTEngine" + NotificationHelper.getDebugData(notification), (Throwable)ex);
                return null;
            }
        }
        try {
            StringBuilder buf = new StringBuilder();
            engine.render(TEMPLATE_SUBJECT, notification.getContext(), (Appendable)buf);
            subject = buf.toString();
        }
        catch (Exception ex) {
            log.error("exception while rendering subject text through TPTEngine" + NotificationHelper.getDebugData(notification), (Throwable)ex);
            return null;
        }
        MailAddress maFrom = new MailAddress();
        maFrom.setAddress(notification.getOrDefaultFromAddress());
        return NotificationHelper.buildMailDocument(notification.getOwner(), maFrom, toAddresses, null, bccAddresses, subject, body, notification.isImportant(), notification.isRelated(), notification.getAttachments());
    }

    private static void logAudit(Notification notification, String msg, Object ... parameters) {
        NotificationHelper.logAudit(notification, msg, null, parameters);
    }

    private static void logAudit(Notification notification, String msg, Throwable error, Object ... parameters) {
        NotificationHelper.logAudit(notification.getNotificationParameters().getOwnerRef(), msg, error, parameters);
    }

    private static void logAudit(EntityReference<?> ownerRef, String msg, Throwable error, Object ... parameters) {
        Optional.ofNullable(ownerRef).ifPresent(o -> SysLogHelper.audit((EntityReference)o, (String)"notification", (Message[])new Message[]{MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)L10nResourcesManager.getStr((String)msg, (Object[])parameters), (Throwable)error, (Object[])new Object[0])}));
    }

    public static MailDocument prepareSimpleMailDocument(Notification notification) {
        HashSet<MailAddress> toAddresses = new HashSet<MailAddress>();
        for (String s : notification.getRecipients()) {
            MailAddress ma = new MailAddress();
            ma.setAddress(s);
            toAddresses.add(ma);
        }
        MailPart body = new MailPart();
        body.setContentType(ContentType.HTML);
        body.setName("body.html");
        MailAddress maFrom = new MailAddress();
        maFrom.setAddress(notification.getOrDefaultFromAddress());
        return NotificationHelper.buildMailDocument(notification.getOwner(), maFrom, toAddresses, null, null, null, body, notification.isImportant(), notification.isRelated(), notification.getAttachments());
    }

    public static boolean sendMail(MailServerParameters mailServerParameters, MailDocument doc, boolean saveDocument) {
        return NotificationHelper.sendMail(mailServerParameters, doc, saveDocument, 0L);
    }

    public static boolean sendMail(MailServerParameters mailServerParameters, MailDocument doc, boolean saveDocument, long delay) {
        MailSender sender = (MailSender)Environment.getPublished(MailSender.class);
        if (!sender.isEnabled() && (mailServerParameters == null || TextUtil.isBlank((String)mailServerParameters.getHost()))) {
            log.warn("notification not sent because mail service is disabled");
            NotificationHelper.logAudit(doc.getOwner(), "ServiceIsDisabled", null, new Object[0]);
            return false;
        }
        if (mailServerParameters != null) {
            sender.send(doc, mailServerParameters, delay);
        } else {
            sender.send(doc, delay);
        }
        if (saveDocument) {
            EntityContainer docContainer = EntityContainer.create((BaseEntity)doc);
            docContainer.getVersionInfo().setDataSource("save-notification");
            EntityStorage.get().save(docContainer, true);
        }
        return true;
    }

    public static MailDocument buildMailDocument(EntityReference<?> ref, MailAddress from, Collection<MailAddress> to, Collection<MailAddress> cc, Collection<MailAddress> bcc, String subject, MailPart body, boolean important, boolean related, MailPart ... attachments) {
        MailDocument mail = new MailDocument();
        mail.setCreated(new Date());
        mail.setOwner(ref);
        mail.setFrom(from);
        mail.getTo().addAll(to);
        mail.setImportant(important);
        mail.setRelated(related);
        if (cc != null) {
            mail.getCc().addAll(cc);
        }
        if (bcc != null) {
            mail.getBcc().addAll(bcc);
        }
        mail.setName(subject);
        mail.setTitle(subject);
        mail.setSubject(subject);
        mail.setBody(body);
        body.setName(null);
        if (attachments != null) {
            for (MailPart att : attachments) {
                mail.getAttachments().add(att);
            }
        }
        return mail;
    }

    public static void sendSimpleNotification(EntityReference<SMSite> siteRef, String[] tos, String subject, String text, boolean isHTMLContent, MailPart ... attachments) throws Exception {
        NotificationHelper.sendSimpleNotification(null, siteRef, tos, subject, text, isHTMLContent, attachments);
    }

    public static void sendSimpleNotification(EntityReference<?> ref, EntityReference<SMSite> siteRef, String[] tos, String subject, String text, boolean isHTMLContent, MailPart ... attachments) throws Exception {
        EntityReference profile = ProfileHelper.getProfile(siteRef, (SMProfileType)SMProfileType.NOTIFICATIONS_SETTINGS);
        if (profile == null) {
            throw new Exception(String.format("no settings of type %s found for site %s", SMProfileType.NOTIFICATIONS_SETTINGS, siteRef));
        }
        SMNotificationsSettings notificationSettings = (SMNotificationsSettings)EntityStorage.get().resolve(profile).getEntity();
        MailServerParameters msp = notificationSettings.getMailServerParameters();
        MailAddress from = new MailAddress();
        from.setAddress(notificationSettings.getFromAddress());
        from.setName(notificationSettings.getFromName());
        ArrayList<MailAddress> toList = new ArrayList<MailAddress>(tos.length);
        for (String to : tos) {
            MailAddress ma = new MailAddress();
            ma.setAddress(to);
            toList.add(ma);
        }
        MailPart body = new MailPart();
        body.setContentType(isHTMLContent ? ContentType.HTML : ContentType.TEXT);
        body.setData(text.getBytes());
        body.setName("body.txt");
        NotificationHelper.sendMail(msp, NotificationHelper.buildMailDocument(ref, from, toList, Collections.emptyList(), Collections.emptyList(), subject, body, false, false, attachments), ref != null);
    }

    public static void sendReservationCreatedNotification(NotificationParameters parameters, Reservation reservation) {
        NotificationHelper.sendNotification(() -> new ReservationCreatedNotification(parameters, reservation), parameters.getOwnerRef(), notification -> notification.isOldLogic() && notification.getNotificationSettings().getReservationCreatedSkipProducts().contains(notification.getProductType()), true);
    }

    public static void sendServicesIssuedNotification(EntityReference<Organization> agencyRef, EntityReference<Organization> clientRef, Locale locale, Reservation reservation, EntityReference<?> owner) {
        NotificationParameters parameters = new NotificationParameters(agencyRef, clientRef, (EntityReference<SMSite>)reservation.getBookingFile().getSite(), locale, owner, SalesContextHandler.get().createSalesContext(reservation));
        NotificationHelper.sendNotification(() -> new ServicesIssuedNotification(parameters, reservation), owner, true);
    }

    public static void sendServiceFeeReceiptNotification(EntityReference<Organization> agencyRef, EntityReference<Organization> clientRef, Locale locale, Reservation reservation, EntityReference<?> owner) throws Exception {
        NotificationParameters parameters = new NotificationParameters(agencyRef, clientRef, (EntityReference<SMSite>)reservation.getBookingFile().getSite(), locale, owner, SalesContextHandler.get().createSalesContext(reservation));
        ServiceFeeReceiptNotification notification = new ServiceFeeReceiptNotification(parameters, reservation);
        MailTemplate template = notification.getTemplate();
        if (!notification.getNotificationSettings().isSendServiceFreeReceiptNotification() || template == null) {
            return;
        }
        HashSet<MailAddress> toAddresses = new HashSet<MailAddress>();
        for (String s : notification.getRecipients()) {
            MailAddress ma = new MailAddress();
            ma.setAddress(s);
            toAddresses.add(ma);
        }
        HashSet<MailAddress> bccAddresses = new HashSet<MailAddress>();
        for (String s : template.getAdditionalAddresses()) {
            MailAddress ma = new MailAddress();
            ma.setAddress(s);
            bccAddresses.add(ma);
        }
        MailPart body = new MailPart();
        body.setContentType(ContentType.HTML);
        body.setName("body.html");
        body.setData((byte[])notification.getProperty("CONTENT"));
        String localeSubject = NotificationHelper.getLocaleSubject(notification, template);
        String subject = localeSubject.replace("${agencyFullName}", L10nStringHelper.getValue((L10nString)((L10nString)notification.getProperty("agencyFullName")), (Locale)locale, (boolean)false)).replace("${clientCode}", (String)notification.getProperty("clientCode"));
        try {
            MailAddress maFrom = new MailAddress();
            maFrom.setAddress(notification.getOrDefaultFromAddress());
            NotificationHelper.sendMail(notification.getOrDefaultMailServerParameters(), NotificationHelper.buildMailDocument(notification.getOwner(), maFrom, toAddresses, null, bccAddresses, subject, body, notification.isImportant(), notification.isRelated(), notification.getAttachments()), true);
        }
        catch (Exception ex) {
            log.error("exception while sending service fee receipt notification" + NotificationHelper.getDebugData(notification), (Throwable)ex);
        }
    }

    public static BaseFileDocument convertJasper2Pdf(BaseFileDocument jasperDoc) throws Exception {
        Document pdfDoc = new Document();
        pdfDoc.setContentType(ContentType.PDF);
        pdfDoc.setContent(JasperUtil.convertToPdf((byte[])jasperDoc.getContent()));
        String fileName = jasperDoc.getName();
        if (TextUtil.nonBlank((String)fileName) && !fileName.toLowerCase().endsWith(".pdf")) {
            fileName = fileName + ".pdf";
        }
        pdfDoc.setName(fileName);
        return pdfDoc;
    }

    private static String buildResourceName(Notification notification, String fileName) {
        StringBuilder builder = new StringBuilder("template");
        ProductType productType = notification.getProductType();
        if (productType == ProductType.AIR_TICKET) {
            builder.append("/avia/");
        }
        if (productType == ProductType.RAILWAY_PRODUCT) {
            builder.append("/railway/");
        }
        if (productType == ProductType.HOTEL_RESERVATION) {
            builder.append("/hotels/");
        }
        if (productType == ProductType.TRANSFER) {
            builder.append("/transfers/");
        }
        builder.append(fileName);
        return builder.toString();
    }

    private static String getBodyIndex(String localeTemplate) {
        Matcher matcher = BODY_PATTERN.matcher(localeTemplate);
        if (matcher.find()) {
            return matcher.group().replaceAll("\\D", "");
        }
        return "";
    }

    public static List<Reservation> getReservations(EntityContainer<BookingFile> bookingFile, Collection<Reservation> reservations) {
        ArrayList<Reservation> result = new ArrayList<Reservation>();
        HashSet processedReservations = new HashSet();
        for (Reservation reservation : MidofficeHelper.getReservations(bookingFile, reservations)) {
            if (processedReservations.contains(reservation)) continue;
            processedReservations.addAll(RzdCommonHelper.getRelatedReservations((Reservation)reservation));
            result.add(reservation);
        }
        return result;
    }

    public static void sendNotification(Supplier<Notification> notificationSupplier, EntityReference<?> ownerRef, SessionCallback sessionCallback) {
        sessionCallback.addCallback((Callback & Serializable)ss -> NotificationHelper.sendNotification(notificationSupplier, ownerRef, true));
    }

    public static void assignButtonsStyleFromTemplate(List<? extends MailTemplate> templates, Notification notification) {
        templates.stream().map(notification::getTemplateData).filter(TextUtil::nonBlank).map(NotificationHelper::getAssignIndexMap).filter(m -> !m.isEmpty()).map(Map::entrySet).flatMap(Collection::stream).forEach(v -> notification.addProperty((String)v.getKey(), v.getValue()));
    }

    private static Map<String, String> getAssignIndexMap(String localeTemplate) {
        Matcher matcher = ASSIGN.matcher(localeTemplate);
        int i = 2;
        HashMap<String, String> context = new HashMap<String, String>();
        while (matcher.find()) {
            String[] split;
            String assign = matcher.group();
            String substring = assign.substring(9, assign.length() - 1);
            if (!TextUtil.nonBlank((String)substring) || (split = substring.split("=", i)).length != i) continue;
            String key = TextUtil.nonEmptyStr((String)split[0]);
            String value = TextUtil.nonEmptyStr((String)split[1]);
            if (value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            context.put(key, value);
        }
        return context;
    }

    private static String getTemplateDataGuarded(String localeData) {
        Matcher matcher = TEG_PATTERN.matcher(localeData);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String nameField = matcher.group(NAME_GROUP);
            if (nameField.contains("!")) continue;
            String replacement = REPLACEMENT.replaceAll(NAME_GROUP, nameField);
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return TextUtil.isBlank((String)sb.toString()) ? localeData : sb.toString();
    }

    public static NotificationSettings getNotificationSettings(BookingFile booking, Predicate<NotificationSettings> checkUsed) {
        EntityReference subagency = BookingHelper.getSubagency((BookingFile)booking);
        return NotificationHelper.getNotificationSettings((EntityReference<Organization>)booking.getCustomerProfile(), (EntityReference<Organization>)subagency, (EntityReference<Organization>)booking.getAgency(), checkUsed);
    }

    public static NotificationSettings getNotificationSettings(Reservation reservation, Predicate<NotificationSettings> checkUsed) {
        if (reservation == null || reservation.getBookingFile() == null) {
            return null;
        }
        BookingFile booking = reservation.getBookingFile();
        return NotificationHelper.getNotificationSettings((EntityReference<Organization>)booking.getCustomerProfile(), (EntityReference<Organization>)reservation.getSubagency(), (EntityReference<Organization>)booking.getAgency(), checkUsed);
    }

    public static NotificationSettings getNotificationSettings(EntityReference<Organization> clientRef, EntityReference<Organization> subagencyRef, EntityReference<Organization> agencyRef, Predicate<NotificationSettings> checkUsed) {
        NotificationSettings result;
        boolean isRetail = com.gridnine.xtrip.common.model.helpers.ProfileHelper.isRetailProfile(clientRef);
        if (!isRetail && (result = NotificationHelper.getNotificationSettings(clientRef, checkUsed)) != null) {
            return result;
        }
        result = NotificationHelper.getNotificationSettings(subagencyRef, checkUsed);
        if (result != null) {
            return result;
        }
        return NotificationHelper.getNotificationSettings(agencyRef, checkUsed);
    }

    private static NotificationSettings getNotificationSettings(EntityReference<Organization> orgRef, Predicate<NotificationSettings> checkUsed) {
        EntityContainer orgCtr = EntityStorage.get().resolve(orgRef);
        if (orgCtr == null) {
            return null;
        }
        EntityContainer settingsCtr = EntityStorage.get().resolve(((Organization)orgCtr.getEntity()).getIbeNotificationSettings());
        if (settingsCtr == null) {
            return null;
        }
        return checkUsed.test((NotificationSettings)settingsCtr.getEntity()) ? (NotificationSettings)settingsCtr.getEntity() : null;
    }

    public static PersonNotificationSettings getPersonNotificationSettings(Person person, EntityReference<Organization> orgRef) {
        return person.getNotificationSettings().stream().filter(ns -> ns.getOrganization() != null).filter(ns -> MiscUtil.equals((Object)orgRef, (Object)ns.getOrganization())).findFirst().orElse(null);
    }
}

