/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.notifications;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Locale;

public class NotificationParameters {
    private String urlScheme;
    private EntityReference<Organization> agencyRef;
    private EntityReference<Organization> clientRef;
    private EntityReference<SMSite> siteRef;
    private Locale locale;
    private EntityReference<?> ownerRef;
    private SalesContext salesContext;

    public NotificationParameters(Reservation reservation, EntityReference<BookingFile> bfRef) {
        this((EntityReference<Organization>)reservation.getSubagency(), (EntityReference<Organization>)reservation.getBookingFile().getCustomerProfile(), (EntityReference<SMSite>)reservation.getBookingFile().getSite(), reservation.getBookingFile().getCustomer().getPreferredLocale(), bfRef, SalesContextHandler.get().createSalesContext(reservation));
    }

    public NotificationParameters(EntityReference<Organization> agencyRef, EntityReference<Organization> clientRef, EntityReference<SMSite> siteRef, Locale locale, EntityReference<?> ownerRef) {
        this(agencyRef, clientRef, siteRef, locale, ownerRef, null);
    }

    public NotificationParameters(EntityReference<Organization> agencyRef, EntityReference<Organization> clientRef, EntityReference<SMSite> siteRef, Locale locale, EntityReference<?> ownerRef, SalesContext salesContext) {
        this.agencyRef = agencyRef;
        this.clientRef = clientRef;
        this.siteRef = siteRef;
        this.locale = locale;
        this.ownerRef = ownerRef;
        this.salesContext = salesContext;
    }

    public String getUrlScheme() {
        return this.urlScheme;
    }

    public void setUrlScheme(String urlScheme) {
        this.urlScheme = urlScheme;
    }

    public EntityReference<Organization> getAgencyRef() {
        return this.agencyRef;
    }

    public void setAgencyRef(EntityReference<Organization> agencyRef) {
        this.agencyRef = agencyRef;
    }

    public EntityReference<Organization> getClientRef() {
        return this.clientRef;
    }

    public void setClientRef(EntityReference<Organization> clientRef) {
        this.clientRef = clientRef;
    }

    public EntityReference<SMSite> getSiteRef() {
        return this.siteRef;
    }

    public void setSiteRef(EntityReference<SMSite> siteRef) {
        this.siteRef = siteRef;
    }

    public Locale getLocale() {
        return (Locale)MiscUtil.guarded((Object)this.locale, (Object)LocaleHelper.getCurrentLocale(), (Object[])new Locale[]{LocaleManager.get().getDefaultLocale()});
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public EntityReference<?> getOwnerRef() {
        return this.ownerRef;
    }

    public void setOwnerRef(EntityReference<?> ownerRef) {
        this.ownerRef = ownerRef;
    }

    public SalesContext getSalesContext() {
        return this.salesContext;
    }

    public void setSalesContext(SalesContext salesContext) {
        this.salesContext = salesContext;
    }
}

