/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.notifications;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.ibecorp.NotificationRecipientType;
import com.gridnine.xtrip.common.model.ibecorp.NotificationType;
import com.gridnine.xtrip.common.model.ibecorp.sm.MailTemplate;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMNotificationsSettings;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.ibecorp.notifications.SiteReservationNotification;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class PaymentRefundNotification
extends SiteReservationNotification {
    private static final long serialVersionUID = 4701582336497647797L;

    @Override
    protected NotificationType getNotificationType() {
        return NotificationType.PAYMENT_REFUND;
    }

    public PaymentRefundNotification(NotificationParameters parameters, Reservation reservation, List<BaseProduct> refundedProducts) {
        super(parameters, reservation, Arrays.asList(NotificationRecipientType.BOOKING_AGENT, NotificationRecipientType.CUSTOMER));
        this.addRefundedProperties(refundedProducts);
        if (reservation.getProducts().stream().noneMatch(prod -> prod instanceof RailwayProduct)) {
            return;
        }
        try {
            EntityContainer bfCtr = ((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(parameters.getOwnerRef());
            ((LocaleManager)Environment.getPublished(LocaleManager.class)).setCurrentLocale(parameters.getLocale());
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), (Object)bfCtr.toReference()));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.type.name(), (Object)DocumentType.TRAVELDOCUMENT));
            List docs = LogicalStorage.get().getEntityStorage().search(BasicDocumentIndex.class, query).getData();
            if (!docs.isEmpty()) {
                for (BasicDocumentIndex idx : docs) {
                    BaseFileDocument doc = (BaseFileDocument)((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(idx.getSource()).getEntity();
                    this.addDocument(doc);
                }
            } else {
                SysLogHelper.audit((EntityReference)bfCtr.toReference(), (String)"travel-doc-generator", (Message[])new Message[]{SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0434\u043b\u044f \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0} \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0438 \u043d\u0435 \u043f\u0440\u0438\u043a\u0440\u0435\u043f\u043b\u0435\u043d\u0430 \u043a \u043f\u0438\u0441\u044c\u043c\u0443 \u043c\u0430\u0440\u0448\u0440\u0443\u0442-\u043a\u0432\u0438\u0442\u0430\u043d\u0446\u0438\u044f", (Object[])new Object[]{CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation)})});
            }
        }
        catch (Throwable t) {
            throw Xeption.forDeveloper((String)"failed sending ticketing confirmation", (Throwable)t, (Object[])new Object[0]);
        }
    }

    private void addRefundedProperties(List<BaseProduct> refundedProducts) {
        this.addProperty("refundedTickets", this.getProductsNumbers(refundedProducts));
        this.addProperty("currentTravellerNames", this.buildTravellerNames(refundedProducts));
    }

    @Override
    public String getDefaultSubject(Locale locale) {
        return L10nResourcesManager.getStr((String)"PaymentRefundNotification_Subject", (Locale)locale, (Object[])new Object[0]);
    }

    @Override
    protected MailTemplate getTemplateByOldLogic() {
        SMNotificationsSettings notificationsSettings = this.getNotificationSettings();
        ProductType productType = this.getProductType();
        if (productType == ProductType.RAILWAY_PRODUCT) {
            return notificationsSettings.getRailwayTemplates().getPaymentRefundNotification();
        }
        if (productType == ProductType.AIR_TICKET) {
            return notificationsSettings.getPaymentRefundNotification();
        }
        if (productType == ProductType.HOTEL_RESERVATION) {
            return notificationsSettings.getHotelTemplates().getPaymentRefundNotification();
        }
        if (productType == ProductType.TRANSFER) {
            return notificationsSettings.getTransferTemplates().getPaymentRefundNotification();
        }
        return null;
    }
}

