/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.notifications;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReservationFailedCancellingNotificationHepler {
    private static final transient Logger log = LoggerFactory.getLogger(ReservationFailedCancellingNotificationHepler.class);

    public static String buildFailedCancellingReservationEmailSubject(EntityReference<SMSite> siteRef, Reservation reservation) {
        return L10nResourcesManager.createL10nMessage((String)"NotificationFailedCalcellingFailed_Subject", (Object[])new Object[]{CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation), ReservationFailedCancellingNotificationHepler.getAgencyDomainForFailedCancelledBooking(siteRef)}).toString();
    }

    public static String buildFailedCancellingReservationEmailBody(EntityReference<SMSite> siteRef, Reservation reservation) {
        StringBuilder body = new StringBuilder();
        body.append(L10nResourcesManager.createL10nMessage((String)"NotificationFailedCalcellingFailed_PNR", (Object[])new Object[]{CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation)}).toString());
        body.append('\n');
        body.append(L10nResourcesManager.createL10nMessage((String)"NotificationFailedCalcellingFailed_Agency", (Object[])new Object[]{ReservationFailedCancellingNotificationHepler.getAgencyDomainForFailedCancelledBooking(siteRef)}).toString());
        return body.toString();
    }

    private static String getAgencyDomainForFailedCancelledBooking(EntityReference<SMSite> siteRef) {
        EntityContainer siteCtr;
        String agencyDomain = "";
        if (siteRef != null && (siteCtr = ((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(siteRef)) != null) {
            agencyDomain = ((SMSite)siteCtr.getEntity()).getDomain();
        }
        return agencyDomain;
    }

    public static String getRecipient() {
        return System.getProperty("com.gridnine.xtrip.server.ibecorp.notifications.ReservationFailedCancellingNotification_recipient");
    }

    private ReservationFailedCancellingNotificationHepler() {
    }
}

