/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.notifications;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.ibecorp.NotificationRecipientType;
import com.gridnine.xtrip.common.model.ibecorp.NotificationType;
import com.gridnine.xtrip.common.model.ibecorp.sm.MailTemplate;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.ibecorp.notifications.SiteReservationNotification;
import java.util.Arrays;
import java.util.Locale;

public class ReservationRequestCreatedNotification
extends SiteReservationNotification {
    @Override
    protected NotificationType getNotificationType() {
        return NotificationType.RESERVATION_REQUEST_CREATED;
    }

    public ReservationRequestCreatedNotification(NotificationParameters parameters, Reservation reservation) {
        super(parameters, reservation, Arrays.asList(NotificationRecipientType.BOOKING_AGENT, NotificationRecipientType.CUSTOMER));
    }

    @Override
    public String getDefaultSubject(Locale locale) {
        return L10nResourcesManager.getStr((String)"ReservationRequestCreatedNotification_Subject", (Locale)locale, (Object[])new Object[0]);
    }

    @Override
    protected MailTemplate getTemplateByOldLogic() {
        ProductType productType = this.getProductType();
        if (productType == ProductType.HOTEL_RESERVATION) {
            return this.getNotificationSettings().getHotelTemplates().getReservationRequestCreated();
        }
        return null;
    }
}

