/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.notifications;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.ibecorp.NotificationRecipientType;
import com.gridnine.xtrip.common.model.ibecorp.NotificationType;
import com.gridnine.xtrip.common.model.ibecorp.sm.MailTemplate;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.ibecorp.notifications.SiteReservationNotification;
import java.util.Arrays;
import java.util.Locale;

public class ReservationVoidedNotification
extends SiteReservationNotification {
    private static final long serialVersionUID = -2739015993646847519L;

    @Override
    protected NotificationType getNotificationType() {
        return NotificationType.RESERVATION_VOIDED;
    }

    public ReservationVoidedNotification(NotificationParameters parameters, Reservation reservation) {
        super(parameters, reservation, Arrays.asList(NotificationRecipientType.BOOKING_AGENT, NotificationRecipientType.CUSTOMER));
    }

    @Override
    public String getDefaultSubject(Locale locale) {
        return L10nResourcesManager.getStr((String)"ReservationVoidedNotification_Subject", (Locale)locale, (Object[])new Object[0]);
    }

    @Override
    protected MailTemplate getTemplateByOldLogic() {
        ProductType productType = this.getProductType();
        if (productType == ProductType.AIR_TICKET) {
            return this.getNotificationSettings().getReservationVoidedNotification();
        }
        return null;
    }
}

