/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.notifications;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.ibecorp.NotificationRecipientType;
import com.gridnine.xtrip.common.model.ibecorp.NotificationType;
import com.gridnine.xtrip.common.model.ibecorp.sm.MailTemplate;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibecorp.notifications.Notification;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class ServiceFeeReceiptNotification
extends Notification {
    private static final long serialVersionUID = -4024786963236183467L;

    @Override
    protected NotificationType getNotificationType() {
        return NotificationType.SERVICE_FEE_RECEIPT;
    }

    public ServiceFeeReceiptNotification(NotificationParameters parameters, Reservation reservation) throws ServiceException {
        super(parameters, Arrays.asList(NotificationRecipientType.BOOKING_AGENT, NotificationRecipientType.CUSTOMER));
        this.addReservationProperties(reservation);
        try {
            EntityContainer bfCtr = ((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(parameters.getOwnerRef());
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), (Object)bfCtr.toReference()));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.type.name(), (Object)DocumentType.SERVICEFEERECEIPT));
            List docs = LogicalStorage.get().getEntityStorage().search(BasicDocumentIndex.class, query).getData();
            if (!docs.isEmpty()) {
                BaseFileDocument doc = (BaseFileDocument)((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(((BasicDocumentIndex)docs.get(0)).getSource()).getEntity();
                this.addProperty("CONTENT", doc.getContent());
            } else {
                Reservation firstReservation = (Reservation)((BookingFile)bfCtr.getEntity()).getReservations().get(0);
                SysLogHelper.audit((EntityReference)bfCtr.toReference(), (String)"service-fee-receipt", (Message[])new Message[]{SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0434\u043b\u044f \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0} \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0438 \u043d\u0435 \u043f\u0440\u0438\u043a\u0440\u0435\u043f\u043b\u0435\u043d\u0430 \u043a \u043f\u0438\u0441\u044c\u043c\u0443 \u043a\u0432\u0438\u0442\u0430\u043d\u0446\u0438\u0438 \u0441\u0435\u0440\u0432\u0438\u0441\u043d\u043e\u0433\u043e \u0441\u0431\u043e\u0440\u0430", (Object[])new Object[]{CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)firstReservation)})});
            }
        }
        catch (Throwable t) {
            throw new ServiceException("failed sending service fee receipt confirmation", t);
        }
    }

    @Override
    public String getDefaultSubject(Locale locale) {
        return L10nResourcesManager.getStr((String)"ServiceFeeReceiptNotification_Subject", (Locale)locale, (Object[])new Object[0]);
    }

    @Override
    public MailTemplate getTemplate() {
        return this.getNotificationSettings().getServiceFeeReceiptNotification();
    }
}

