/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.notifications;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.ibecorp.NotificationRecipientType;
import com.gridnine.xtrip.common.model.ibecorp.NotificationType;
import com.gridnine.xtrip.common.model.ibecorp.sm.MailTemplate;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMNotificationsSettings;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.ibecorp.notifications.SiteReservationNotification;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class ServicesIssuedNotification
extends SiteReservationNotification {
    private static final long serialVersionUID = 4701582336497647797L;

    @Override
    protected NotificationType getNotificationType() {
        return NotificationType.SERVICES_ISSUED;
    }

    public ServicesIssuedNotification(NotificationParameters parameters, Reservation reservation) {
        super(parameters, reservation, Arrays.asList(NotificationRecipientType.BOOKING_AGENT, NotificationRecipientType.CUSTOMER));
        try {
            EntityContainer bfCtr = ((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(parameters.getOwnerRef());
            ((LocaleManager)Environment.getPublished(LocaleManager.class)).setCurrentLocale(parameters.getLocale());
            String recordLocator = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation);
            this.addProperty("subject", "\u0412\u044b\u043f\u0438\u0441\u043a\u0430 \u0431\u0438\u043b\u0435\u0442\u043e\u0432. \u2116 " + recordLocator);
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), (Object)bfCtr.toReference()));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BasicDocumentIndex.Property.type.name(), (Object)DocumentType.TRAVELDOCUMENT), SearchCriterion.eq((String)BasicDocumentIndex.Property.type.name(), (Object)DocumentType.SPECIAL_TRAVELDOCUMENT), SearchCriterion.eq((String)BasicDocumentIndex.Property.type.name(), (Object)DocumentType.VOUCHER), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BasicDocumentIndex.Property.type.name(), (Object)DocumentType.RECEIPT), SearchCriterion.eq((String)BasicDocumentIndex.Property.contentType.name(), (Object)ContentType.JASPERPRINT)})}));
            List docs = LogicalStorage.get().getEntityStorage().search(BasicDocumentIndex.class, query).getData();
            if (!docs.isEmpty()) {
                for (BasicDocumentIndex idx : docs) {
                    if (RzdCommonHelper.getRelatedReservations((Reservation)reservation).stream().flatMap(res -> res.getProducts().stream()).filter(Objects::nonNull).noneMatch(baseProduct -> baseProduct.getUid().equals(idx.getNavigationKey()) || reservation.getUid().equals(idx.getNavigationKey()))) continue;
                    BaseFileDocument doc = (BaseFileDocument)EntityStorage.get().resolve(idx.getSource()).getEntity();
                    if (idx.getContentType() == ContentType.JASPERPRINT) {
                        doc = NotificationHelper.convertJasper2Pdf(doc);
                    }
                    if (idx.getContentType() == ContentType.PDF) {
                        doc.setName(doc.getName().endsWith(".pdf") ? doc.getName() : doc.getName() + ".pdf");
                    }
                    this.addDocument(doc);
                }
            } else {
                SysLogHelper.audit((EntityReference)bfCtr.toReference(), (String)"travel-doc-generator", (Message[])new Message[]{SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0434\u043b\u044f \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0} \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0438 \u043d\u0435 \u043f\u0440\u0438\u043a\u0440\u0435\u043f\u043b\u0435\u043d\u0430 \u043a \u043f\u0438\u0441\u044c\u043c\u0443 \u043c\u0430\u0440\u0448\u0440\u0443\u0442-\u043a\u0432\u0438\u0442\u0430\u043d\u0446\u0438\u044f", (Object[])new Object[]{recordLocator})});
            }
        }
        catch (Throwable t) {
            throw Xeption.forDeveloper((String)"failed sending ticketing confirmation", (Throwable)t, (Object[])new Object[0]);
        }
    }

    @Override
    public String getDefaultSubject(Locale locale) {
        return L10nResourcesManager.getStr((String)"TicketingNotification_Subject", (Locale)locale, (Object[])new Object[0]);
    }

    @Override
    protected MailTemplate getTemplateByOldLogic() {
        SMNotificationsSettings notificationsSettings = this.getNotificationSettings();
        ProductType productType = this.getProductType();
        if (productType == ProductType.RAILWAY_PRODUCT) {
            return notificationsSettings.getRailwayTemplates().getServicesIssuedNotification();
        }
        if (productType == ProductType.AIR_TICKET) {
            return notificationsSettings.getServicesIssuedNotification();
        }
        if (productType == ProductType.HOTEL_RESERVATION) {
            return notificationsSettings.getHotelTemplates().getServicesIssuedNotification();
        }
        if (productType == ProductType.TRANSFER) {
            return notificationsSettings.getTransferTemplates().getServicesIssuedNotification();
        }
        return null;
    }
}

