/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.notifications;

import com.gridnine.xtrip.common.ibecorp.rules.IbecorpFilteringCategories;
import com.gridnine.xtrip.common.ibecorp.rules.NotificationsActionSet;
import com.gridnine.xtrip.common.ibecorp.rules.Targets;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.ibecorp.NotificationRecipientType;
import com.gridnine.xtrip.common.model.ibecorp.NotificationSettings;
import com.gridnine.xtrip.common.model.ibecorp.NotificationType;
import com.gridnine.xtrip.common.model.ibecorp.sm.MailTemplate;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.ibecorp.handlers.rules.NotificationSettingsPropertySet;
import com.gridnine.xtrip.server.ibecorp.notifications.Notification;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import com.gridnine.xtrip.server.model.rules.RulesHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.function.Supplier;

public abstract class SiteNotification<T extends MailTemplate>
extends Notification {
    protected T template;
    private NotificationSettings notificationSettings;

    protected SiteNotification(NotificationParameters parameters, Collection<NotificationRecipientType> defaultRecipientTypes, Supplier<NotificationSettings> notificationSettingsSupplier, Supplier<Targets> targetsSupplier) {
        super(parameters);
        this.notificationSettings = notificationSettingsSupplier.get();
        this.setSiteTemplate(parameters, targetsSupplier.get());
        if (this.isOldLogic()) {
            this.buildAvailableRecipientTypes(defaultRecipientTypes);
        }
    }

    protected abstract MailTemplate getTemplateByOldLogic();

    @Override
    protected boolean isOldLogic() {
        return this.notificationSettings == null;
    }

    @Override
    public MailTemplate getTemplate() {
        if (this.isOldLogic()) {
            return this.getTemplateByOldLogic();
        }
        return this.template;
    }

    protected abstract T getNotificationTemplate(NotificationsActionSet var1);

    protected void setSiteTemplate(NotificationParameters parameters, Targets notificationTarget) {
        try {
            String mesPrefix;
            NotificationType notificationType = this.getNotificationType();
            String string = mesPrefix = notificationType != null ? notificationType.toString() + ". " : "";
            if (this.notificationSettings == null) {
                if (parameters.getOwnerRef() != null) {
                    SysLogHelper.audit(parameters.getOwnerRef(), (String)"notification", (Message[])new Message[]{MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)(mesPrefix + L10n.getWithParams((String)"NotificationSettingsNotFound", (Object[])new Object[]{IbecorpFilteringCategories.NOTIFICATION_TEMPLATE_SITE.getDisplayName()})), (Object[])new Object[0])});
                }
                return;
            }
            RuleProxy proxy = new RuleProxy();
            proxy.getTracer().setDisabled(true);
            proxy.setProxyType(notificationTarget.getId());
            proxy.setProxyDate(new Date());
            proxy.setPropertySet((Object)new NotificationSettingsPropertySet(notificationType, parameters));
            proxy.setActionSet((Object)new NotificationsActionSet());
            RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)this.notificationSettings.getRuleSet());
            this.template = this.getNotificationTemplate((NotificationsActionSet)proxy.getActionSet());
            if (parameters.getOwnerRef() != null) {
                StringBuilder appliedRulesInfo = new StringBuilder();
                RulesHelper.getAppliedRuleSettings((RuleProxy)proxy, (RuleSet)this.notificationSettings.getRuleSet()).forEach(rs -> {
                    int ruleNmb = this.notificationSettings.getRuleSet().getRules().indexOf(rs) + 1;
                    appliedRulesInfo.append(L10n.getWithParams((String)"NotificationSettingsRule", (Object[])new Object[]{rs.getName(), ruleNmb})).append("\n").append(rs.getRestrictionsInfoNoHtml()).append("\n\n");
                });
                if (this.template != null) {
                    this.updateAppliedRulesInfo(appliedRulesInfo, this.template);
                } else {
                    appliedRulesInfo.append(L10n.getWithParams((String)"TemplateNotConfigured", (Object[])new Object[]{NotificationHelper.getLocaleSubject(this, null)}));
                }
                SysLogHelper.audit(parameters.getOwnerRef(), (String)"notification-settings", (Message[])new Message[]{MessagesHelper.createMessageWithDetails((MessageType)MessageType.MESSAGE, (String)(mesPrefix + L10n.getWithParams((String)"NotificationSettingsAreUsed", (Object[])new Object[]{this.notificationSettings.toString()})), (String)appliedRulesInfo.toString(), (Object[])new Object[0])});
            }
        }
        catch (Exception ex) {
            throw Xeption.forDeveloper((String)"create SiteNotification failed", (Throwable)ex, (Object[])new Object[0]);
        }
    }

    protected void updateAppliedRulesInfo(StringBuilder appliedRulesInfo, T template) {
        appliedRulesInfo.append(L10n.getWithParams((String)"AdditionalAddressesWithValues", (Object[])new Object[]{template.getAdditionalAddresses()})).append("\n");
    }
}

