/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.notifications;

import com.gridnine.xtrip.common.ibecorp.rules.NotificationsActionSet;
import com.gridnine.xtrip.common.ibecorp.rules.Targets;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.ibecorp.NotificationRecipientMailTemplate;
import com.gridnine.xtrip.common.model.ibecorp.NotificationRecipientType;
import com.gridnine.xtrip.common.model.ibecorp.NotificationSettings;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.ibecorp.notifications.SiteNotification;
import java.util.Collection;

public abstract class SiteReservationNotification
extends SiteNotification<NotificationRecipientMailTemplate> {
    public SiteReservationNotification(NotificationParameters parameters, Reservation reservation, Collection<NotificationRecipientType> defaultRecipientTypes) {
        super(parameters, defaultRecipientTypes, () -> NotificationHelper.getNotificationSettings(reservation, NotificationSettings::isUseSiteSettings), () -> SiteReservationNotification.getTarget(reservation));
        if (this.template != null) {
            this.availableRecipientTypes.addAll(((NotificationRecipientMailTemplate)this.template).getRecipientTypes());
        }
        this.addReservationProperties(reservation);
    }

    @Override
    protected NotificationRecipientMailTemplate getNotificationTemplate(NotificationsActionSet actionSet) {
        return actionSet.getSiteNotificationTemplate();
    }

    @Override
    protected void updateAppliedRulesInfo(StringBuilder appliedRulesInfo, NotificationRecipientMailTemplate template) {
        appliedRulesInfo.append(L10n.getWithParams((String)"AvailableRecipientTypes", (Object[])new Object[]{this.getNotificationType(), template.getRecipientTypes()})).append("\n");
        super.updateAppliedRulesInfo(appliedRulesInfo, template);
    }

    private static Targets getTarget(Reservation reservation) {
        TravelSubject travelSubject = BookingHelper.getTravelSubject((Reservation)reservation);
        if (travelSubject == null) {
            throw Xeption.forDeveloper((String)"reservation {0} (booking {1}): hasn't travelSubject", (Object[])new Object[]{CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation), reservation.getBookingFile().getNumber()});
        }
        switch (travelSubject) {
            case AIR: {
                return Targets.NOTIFICATION_TEMPLATE_SITE_AVIA;
            }
            case RAILWAY: {
                return Targets.NOTIFICATION_TEMPLATE_SITE_RAIL;
            }
            case HOTEL_RESERVATION: {
                return Targets.NOTIFICATION_TEMPLATE_SITE_HOTELS;
            }
            case TRANSFER: {
                return Targets.NOTIFICATION_TEMPLATE_SITE_TRANSFER;
            }
        }
        throw Xeption.forDeveloper((String)"reservation {0} (booking {1}): unsupported travelSubject {2}", (Object[])new Object[]{CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation), reservation.getBookingFile().getNumber(), travelSubject});
    }
}

