/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.notifications;

import com.gridnine.xtrip.common.gds.model.VisaRequirement;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.ibecorp.NotificationRecipientType;
import com.gridnine.xtrip.common.model.ibecorp.NotificationType;
import com.gridnine.xtrip.common.model.ibecorp.sm.MailTemplate;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.ibecorp.notifications.SiteReservationNotification;
import java.util.Arrays;
import java.util.Locale;

public class VisaInformationNotification
extends SiteReservationNotification {
    private static final long serialVersionUID = 2284727824903406945L;

    @Override
    protected NotificationType getNotificationType() {
        return NotificationType.VISA_INFORMATION;
    }

    public VisaInformationNotification(NotificationParameters parameters, Reservation reservation) {
        super(parameters, reservation, Arrays.asList(NotificationRecipientType.BOOKING_AGENT, NotificationRecipientType.CUSTOMER));
        this.addProperty("docoDocaUrl", this.getDocoDocaUrl(parameters.getOwnerRef()));
        for (VisaRequirement vr : reservation.getVisaRequirements()) {
            if (!vr.isCustomFormNeeded()) continue;
            this.addProperty("customFormNeeded", "true");
            break;
        }
    }

    private String getDocoDocaUrl(EntityReference<?> bfRef) {
        StringBuilder sb = new StringBuilder();
        sb.append("http://");
        sb.append(this.getProperty("domain"));
        sb.append('/');
        sb.append("#cabinet/order/");
        sb.append(bfRef.getUid());
        return sb.toString();
    }

    @Override
    public String getDefaultSubject(Locale locale) {
        return L10nResourcesManager.getStr((String)"VisaInformationNotification_Subject", (Locale)locale, (Object[])new Object[0]);
    }

    @Override
    protected MailTemplate getTemplateByOldLogic() {
        return this.getNotificationSettings().getVisaInformationNotification();
    }
}

