/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.notifications.handlers;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.model.FareDetails;
import com.gridnine.xtrip.common.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.common.ibecorp.common.PenaltiesResolver;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.BookingAirlineBonusCard;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeReference;
import com.gridnine.xtrip.common.model.booking.PassengerTypeValue;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.LuggageInfo;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictPredifinedValueProvider;
import com.gridnine.xtrip.common.model.dict.DictSearchCriterion;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.LuggageUnit;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.ExtendedLuggageInfo;
import com.gridnine.xtrip.common.model.gds.PenaltiesInfo;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.ibecorp.PriceDetailDisplay;
import com.gridnine.xtrip.common.model.ibecorp.sm.BaseSMProfileIndex;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMProfileType;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep1Settings;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.GeneralPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.components.ReservationPriceComponents;
import com.gridnine.xtrip.server.ibecorp.l10n.Messages;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.handlers.NotificationHandler;
import com.gridnine.xtrip.server.ibecorp.notifications.handlers.NotificationHandlerParameters;
import com.gridnine.xtrip.server.ibecorp.notifications.handlers.NotificationHandlerUtil;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class AviaNotificationHandler
extends NotificationHandler {
    private boolean noAirlineTranslation = false;
    private static final List<String> PRIORITY_AIRLINE_CODE_SYSTEMS = Arrays.asList(CodeSystem.IATA.name(), CodeSystem.CRT.name());

    AviaNotificationHandler(ProductType productType) {
        super(productType);
    }

    @Override
    public void fillContext(Map<String, Object> context, Reservation reservation, NotificationHandlerParameters handlerParameters) {
        this.context = context;
        this.handlerParameters = handlerParameters;
        EntityReference siteRef = reservation.getBookingFile().getSite();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BaseSMProfileIndex.Property.site.name(), (Object)siteRef));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BaseSMProfileIndex.Property.profileType.name(), (Object)SMProfileType.STEP1_SETTINGS));
        List data = EntityStorage.get().search(BaseSMProfileIndex.class, query).getData();
        if (!data.isEmpty()) {
            SMStep1Settings step1Settings = (SMStep1Settings)EntityStorage.get().resolve(((BaseSMProfileIndex)data.get(0)).getSource()).getEntity();
            this.noAirlineTranslation = step1Settings.isNoAirlineTranslation();
        }
        String currency = DictHelper.getLocalCurrency();
        String customerFullName = "";
        Customer customer = reservation.getBookingFile().getCustomer();
        if (customer != null) {
            TextUtil.buildFullName((PersonalName)customer.getPassport());
        }
        ArrayList<Map<String, Object>> refundAndExchangeProperties = new ArrayList<Map<String, Object>>();
        List<Product> prodList = reservation.getProducts().stream().filter(Product.class::isInstance).map(Product.class::cast).filter(p -> p.getProductCategory() == ProductCategory.AIR).sorted(this::sortByPassengerType).collect(Collectors.toList());
        LinkedHashMap travellerProductsMap = new LinkedHashMap(reservation.getBookingFile().getTravellers().size());
        prodList.forEach(prod -> {
            if (!travellerProductsMap.containsKey(prod.getTraveller())) {
                travellerProductsMap.put(prod.getTraveller(), new ArrayList());
            }
            ((List)travellerProductsMap.get(prod.getTraveller())).add(prod);
        });
        Map.Entry travellerProductsMapEntry = travellerProductsMap.entrySet().iterator().next();
        StringBuilder sbFlightPath = new StringBuilder();
        StringBuilder stringBuilder = new StringBuilder();
        List segments = ((List)travellerProductsMapEntry.getValue()).stream().flatMap(p -> AirProductHelper.getProductSegmentsList((Product)p).stream()).collect(Collectors.toList());
        if (((List)travellerProductsMapEntry.getValue()).size() > 1) {
            boolean useTimeZone = segments.stream().map(Segment::getDepartureLocation).allMatch(departureLoc -> DictHelper.getZoneId((DictionaryReference)departureLoc) != null);
            segments.sort((s1, s2) -> this.compareSegmentsByDepartureDate((Segment)s1, (Segment)s2, useTimeZone));
        }
        StringBuilder bonusCards = new StringBuilder();
        for (BookingAirlineBonusCard card : ((Traveller)travellerProductsMapEntry.getKey()).getAirlineBonusCards()) {
            if (card.getAirline() == null) continue;
            bonusCards.append(card.getNumber()).append("(").append(card.getAirline().getCode()).append(")");
        }
        context.put("bonusCards", bonusCards.toString());
        ArrayList<HashMap<String, Object>> segmentContexts = new ArrayList<HashMap<String, Object>>();
        Date departureDate = null;
        Product prod2 = (Product)((List)travellerProductsMapEntry.getValue()).get(0);
        HashSet<String> reservationCodes = new HashSet<String>();
        for (int i = 0; i < segments.size(); ++i) {
            Segment segment = (Segment)segments.get(i);
            if (((List)travellerProductsMapEntry.getValue()).size() > 1) {
                prod2 = ((List)travellerProductsMapEntry.getValue()).stream().filter(p -> AirProductHelper.getProductSegmentsList((Product)p).contains(segment)).findFirst().get();
            }
            HashMap<String, Object> segmentContext = new HashMap<String, Object>();
            this.addSegmentProperties(segment, prod2, segmentContext);
            if (!segment.isStarting() && i != 0) {
                sbFlightPath.append(" - ");
                sbFlightPath.append(AviaNotificationHandler.getCity((DictionaryReference<GeoLocation>)segment.getArriveLocation(), handlerParameters.getCurLocale()));
                stringBuilder.append(" - ").append(AviaNotificationHandler.getLocationCode((DictionaryReference<GeoLocation>)segment.getArriveLocation()));
                int connectionTime = (int)((segment.getStartDate().getTime() - ((Segment)segments.get(i - 1)).getEndDate().getTime()) / 60000L);
                segmentContext.put("connectionTime", NotificationHandlerUtil.formatMinutes(connectionTime));
                if (connectionTime > 720) {
                    segmentContext.put("longConnectionTime", "true");
                }
            } else {
                if (departureDate == null) {
                    departureDate = segment.getStartDate();
                }
                sbFlightPath.append(AviaNotificationHandler.getCity((DictionaryReference<GeoLocation>)segment.getDepartureLocation(), handlerParameters.getCurLocale()));
                sbFlightPath.append(" - ");
                sbFlightPath.append(AviaNotificationHandler.getCity((DictionaryReference<GeoLocation>)segment.getArriveLocation(), handlerParameters.getCurLocale()));
                if (i != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(AviaNotificationHandler.getLocationCode((DictionaryReference<GeoLocation>)segment.getDepartureLocation())).append(" - ").append(AviaNotificationHandler.getLocationCode((DictionaryReference<GeoLocation>)segment.getArriveLocation()));
                reservationCodes.add(MiscUtil.guarded((String)segment.getAirlineLocator()) + this.getAirlineCode(segment));
            }
            L10nMessage departure = L10nResourcesManager.createL10nMessage((String)Messages.DEPARTURE, (Object[])new Object[0]);
            L10nMessage arrival = L10nResourcesManager.createL10nMessage((String)Messages.ARRIVAL, (Object[])new Object[0]);
            Calendar startCal = Calendar.getInstance();
            Calendar endCal = Calendar.getInstance();
            startCal.setTime(segment.getStartDate());
            startCal.set(11, 0);
            startCal.set(12, 0);
            startCal.set(13, 0);
            endCal.setTime(segment.getEndDate());
            endCal.set(11, 0);
            endCal.set(12, 0);
            endCal.set(13, 0);
            if (startCal.compareTo(endCal) == 0) {
                segmentContext.put("dateHeadline", ("<span>" + departure + "<b>" + NotificationHelper.safeDtFormat(handlerParameters.getDateF(), segment.getStartDate()) + "</b></span>").toUpperCase());
            } else {
                segmentContext.put("dateHeadline", ("<span>" + departure + "<b>" + NotificationHelper.safeDtFormat(handlerParameters.getDateF(), segment.getStartDate()) + "</b> &#9654; " + arrival + "<b>" + NotificationHelper.safeDtFormat(handlerParameters.getDateF(), segment.getEndDate()) + "</b> </span>").toUpperCase());
            }
            segmentContext.put("customer", customerFullName);
            this.addBrandedFareOptions(segmentContext, segment);
            segmentContexts.add(segmentContext);
        }
        context.put("segments", segmentContexts);
        StringBuilder sbReservationCodes = new StringBuilder(64);
        for (String airlineCode : reservationCodes) {
            sbReservationCodes.append(' ').append(airlineCode);
        }
        context.put("airlineLocators", sbReservationCodes.toString());
        context.put("flightPath", sbFlightPath.toString());
        context.put("route", stringBuilder.toString());
        context.put("departureDate", NotificationHelper.safeDtFormat(handlerParameters.getDateF(), departureDate));
        ArrayList passengerContexts = new ArrayList();
        for (Map.Entry entry : travellerProductsMap.entrySet()) {
            LinkedHashMap<String, Object> passengerContext = new LinkedHashMap<String, Object>();
            passengerContext.put("firstName", Optional.ofNullable(((Traveller)entry.getKey()).getPassport()).map(Passport::getFirstName).orElse(null));
            passengerContext.put("lastName", Optional.ofNullable(((Traveller)entry.getKey()).getPassport()).map(Passport::getLastName).orElse(null));
            passengerContexts.add(passengerContext);
            refundAndExchangeProperties.add(this.addRefundAndExchangeProperties(reservation, (List)entry.getValue()));
        }
        CurrencyInfo eqvCurrInfo = (CurrencyInfo)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).findByCode(CurrencyInfo.class, currency);
        context.put("currency", eqvCurrInfo.toString(handlerParameters.getCurLocale()));
        context.put("passengers", passengerContexts);
        context.put("refundAndExchangeProperties", refundAndExchangeProperties);
        this.addPricesProperties(reservation);
    }

    private void addSegmentProperties(Segment segment, Product prod, Map<String, Object> segmentContext) {
        segmentContext.put("airlineLocator", segment.getAirlineLocator());
        ClassOfService classOfService = DictHelper.findClassOfService((Segment)segment, (Date)prod.getIssueDate());
        segmentContext.put("classOfService", String.format("%s (%s)", classOfService.toString(), segment.getClassOfSvcCode()));
        segmentContext.put("fareBasis", segment.getFareBasis());
        segmentContext.put("baggageWeightLimit", AirProductHelper.luggageInfoToSring((LuggageInfo)segment.getLuggageInfo(), (Locale)this.handlerParameters.getCurLocale()));
        segmentContext.put("departTerminal", MiscUtil.translateTerminal((String)segment.getDepartTerminal(), (Locale)this.handlerParameters.getCurLocale()));
        segmentContext.put("departDate", NotificationHelper.safeDtFormat(this.handlerParameters.getDateF(), segment.getStartDate()));
        segmentContext.put("departTime", NotificationHelper.safeDtFormat(this.handlerParameters.getTimeF(), segment.getStartDate()));
        segmentContext.put("departAirport", AviaNotificationHandler.getAirport((DictionaryReference<GeoLocation>)segment.getDepartureLocation(), this.handlerParameters.getCurLocale()));
        if (segment.getDepartureLocation() != null && AviaNotificationHandler.getLocationCode((DictionaryReference<GeoLocation>)segment.getDepartureLocation()) != null) {
            segmentContext.put("departAirportCode", AviaNotificationHandler.getLocationCode((DictionaryReference<GeoLocation>)segment.getDepartureLocation()));
        }
        segmentContext.put("departCity", AviaNotificationHandler.getCity((DictionaryReference<GeoLocation>)segment.getDepartureLocation(), this.handlerParameters.getCurLocale()));
        segmentContext.put("departCountry", AviaNotificationHandler.getCountry((DictionaryReference<GeoLocation>)segment.getDepartureLocation(), this.handlerParameters.getCurLocale()));
        segmentContext.put("arriveTerminal", MiscUtil.translateTerminal((String)segment.getArriveTerminal(), (Locale)this.handlerParameters.getCurLocale()));
        segmentContext.put("arriveDate", NotificationHelper.safeDtFormat(this.handlerParameters.getDateF(), segment.getEndDate()));
        segmentContext.put("arriveTime", NotificationHelper.safeDtFormat(this.handlerParameters.getTimeF(), segment.getEndDate()));
        segmentContext.put("arriveAirport", AviaNotificationHandler.getAirport((DictionaryReference<GeoLocation>)segment.getArriveLocation(), this.handlerParameters.getCurLocale()));
        if (segment.getArriveLocation() != null && AviaNotificationHandler.getLocationCode((DictionaryReference<GeoLocation>)segment.getArriveLocation()) != null) {
            segmentContext.put("arriveAirportCode", AviaNotificationHandler.getLocationCode((DictionaryReference<GeoLocation>)segment.getArriveLocation()));
        }
        segmentContext.put("arriveCity", AviaNotificationHandler.getCity((DictionaryReference<GeoLocation>)segment.getArriveLocation(), this.handlerParameters.getCurLocale()));
        segmentContext.put("arriveCountry", AviaNotificationHandler.getCountry((DictionaryReference<GeoLocation>)segment.getArriveLocation(), this.handlerParameters.getCurLocale()));
        segmentContext.put("airline", DictHelper.toStringWithL10n((DictionaryReference)segment.getAirline(), (Locale)(this.noAirlineTranslation ? Locale.ENGLISH : this.handlerParameters.getCurLocale()), (Locale)NotificationHandlerUtil.getDefaultNotificationLocale()));
        segmentContext.put("airlineCode", this.getAirlineCode(segment));
        if (segment.getCodeShareCarrier() != null && segment.isCodeShare()) {
            segmentContext.put("operatingAirline", DictHelper.toStringWithL10n((DictionaryReference)segment.getCodeShareCarrier(), (Locale)(this.noAirlineTranslation ? Locale.ENGLISH : this.handlerParameters.getCurLocale())));
        }
        segmentContext.put("flightNumber", segment.getFlightNo());
        segmentContext.put("aircraft", DictHelper.toStringWithL10n((DictionaryReference)segment.getBoard(), (Locale)this.handlerParameters.getCurLocale()));
        segmentContext.put("duration", NotificationHandlerUtil.formatMinutes(segment.getFlightDuration()));
        if (segment.getSeatNo() != null && segment.getSeatType() != null) {
            segmentContext.put("seatno", segment.getSeatType() + segment.getSeatNo());
        }
        if (segment.getStatus() != null) {
            segmentContext.put("status", segment.getStatus());
        }
        if (segment.getNoOfStops() != null) {
            segmentContext.put("stops", segment.getNoOfStops());
        }
    }

    private Map<String, Object> addRefundAndExchangeProperties(Reservation reservation, List<Product> products) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Product product = products.get(0);
        PenaltiesResolver penaltiesResolver = new PenaltiesResolver(reservation);
        PenaltiesInfo penaltiesInfo = (PenaltiesInfo)penaltiesResolver.getPenaltiesInfos().get(product.getPassengerType());
        PriceComponentsParameters priceComponentsParameters = null;
        if (this.handlerParameters.getSalesContext() != null) {
            priceComponentsParameters = PriceComponentsParameters.getBriefInfoParameters(this.handlerParameters.getSalesContext());
        }
        if (penaltiesInfo != null) {
            result.put("passengerType", product.getPassengerType().toString());
            if (penaltiesInfo.getRefundableBeforeDeparture() != null) {
                if (penaltiesInfo.getRefundableBeforeDeparture().booleanValue() && penaltiesInfo.getRefundBeforeDeparture() != null) {
                    result.put("refundBefore", this.getPenaltyValueAndCurrency(penaltiesInfo.getRefundBeforeDeparture(), priceComponentsParameters));
                } else {
                    result.put("notRefundBefore", true);
                }
            }
            if (penaltiesInfo.getRefundableAfterDeparture() != null) {
                if (penaltiesInfo.getRefundableAfterDeparture().booleanValue() && penaltiesInfo.getRefundableAfterDeparture() != null) {
                    result.put("refundAfter", this.getPenaltyValueAndCurrency(penaltiesInfo.getRefundAfterDeparture(), priceComponentsParameters));
                } else {
                    result.put("notRefundAfter", true);
                }
            }
            if (penaltiesInfo.getExchangableBeforeDeparture() != null) {
                if (penaltiesInfo.getExchangableBeforeDeparture().booleanValue()) {
                    result.put("exchangeBefore", this.getPenaltyValueAndCurrency(penaltiesInfo.getExchangeBeforeDeparture(), priceComponentsParameters));
                } else {
                    result.put("notExchangeBefore", true);
                }
            }
            if (penaltiesInfo.getExchangableAfterDeparture() != null) {
                if (penaltiesInfo.getExchangableAfterDeparture().booleanValue()) {
                    result.put("exchangeAfter", this.getPenaltyValueAndCurrency(penaltiesInfo.getExchangeAfterDeparture(), priceComponentsParameters));
                } else {
                    result.put("notExchangeAfter", true);
                }
            }
        }
        return result;
    }

    private String getPenaltyValueAndCurrency(Money money, PriceComponentsParameters priceComponentsParameters) {
        if (money == null) {
            return "";
        }
        if (priceComponentsParameters != null && priceComponentsParameters.getCurrency().equals(money.getCurrency())) {
            return Optional.ofNullable(money.toString()).orElse("");
        }
        return money.getValue() == null ? "" : money.getValue() + " " + (priceComponentsParameters != null ? Optional.ofNullable(priceComponentsParameters.getCurrency()).orElse(Optional.ofNullable(money.getCurrency()).orElse("???")) : Optional.ofNullable(money.getCurrency()).orElse("???"));
    }

    private void addPricesProperties(Reservation reservation) {
        PassengerTypeValue[] passengerTypeValues = new PassengerTypeValue[]{PassengerTypeValue.ADULT, PassengerTypeValue.CHILD, PassengerTypeValue.INFANT, PassengerTypeValue.INFANT_WITH_SITE, PassengerTypeValue.YOUTH, PassengerTypeValue.SENIOR};
        PriceComponentsParameters parameters = PriceComponentsParameters.getNotificationPriceComponentsParameters(reservation);
        ReservationPriceComponents components = ReservationPriceComponents.builder(reservation, parameters).build();
        Map<DictionaryReference<PassengerType>, Integer> passengers = components.getPassengers();
        BigDecimal tariff = components.getTariff();
        BigDecimal taxes = components.getTaxes();
        BigDecimal fee = components.getFee();
        BigDecimal total = components.getTotal();
        boolean showFeeCol = components.getPriceDetailDisplay() == PriceDetailDisplay.DETAILED;
        boolean showTariffCols = components.getPriceDetailDisplay() != PriceDetailDisplay.TOTAL_ONLY;
        this.context.put("showTariffCols", showTariffCols);
        this.context.put("showFeeCol", showFeeCol);
        this.context.put("fare", NotificationHandlerUtil.priceFormat.format(tariff.doubleValue()).toUpperCase());
        this.context.put("totalTaxesFee", NotificationHandlerUtil.priceFormat.format(taxes.doubleValue()).toUpperCase());
        this.context.put("total", NotificationHandlerUtil.priceFormat.format(total.doubleValue()).toUpperCase());
        for (PassengerTypeValue ptv : passengerTypeValues) {
            PassengerTypeReference passType = ((PassengerType)DictHelper.getPredifinedValue((DictPredifinedValueProvider)ptv)).toReference();
            List<GeneralPriceComponents.PassengerPriceStructure> passengerPriceStructures = components.getPassengerPriceStructures((DictionaryReference<PassengerType>)passType);
            passengerPriceStructures.sort((pps1, pps2) -> pps2.getTariff().compareTo(pps1.getTariff()));
            if (!passengers.containsKey(passType) || passengers.get(passType) <= 0) continue;
            for (GeneralPriceComponents.PassengerPriceStructure structure : passengerPriceStructures) {
                if (showTariffCols) {
                    this.context.put("tariff_" + passType.getCode(), NotificationHandlerUtil.priceFormat.format(structure.getTariff().doubleValue()));
                    this.context.put("taxes_" + passType.getCode(), NotificationHandlerUtil.priceFormat.format(structure.getTaxes().add(showFeeCol ? BigDecimal.ZERO : structure.getFees()).doubleValue()));
                    if (showFeeCol) {
                        this.context.put("fee_" + passType.getCode(), NotificationHandlerUtil.priceFormat.format(structure.getFees().doubleValue()));
                    }
                }
                this.context.put("count_" + passType.getCode(), structure.getPassengerCount().toString());
                this.context.put("total_" + passType.getCode(), NotificationHandlerUtil.priceFormat.format(structure.getTotal().doubleValue()));
            }
        }
    }

    private static String getAirport(DictionaryReference<GeoLocation> locRef, Locale locale) {
        GeoLocation loc = (GeoLocation)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).resolveReference(locRef);
        if (LocationType.AIRPORT.equals((Object)loc.getType())) {
            return (String)MiscUtil.findByLocale((Map)loc.getTranslations(), (Locale)locale, (Locale)NotificationHandlerUtil.getDefaultNotificationLocale());
        }
        if (LocationType.CITY.equals((Object)loc.getType())) {
            Set children = ((DictionaryCache)Environment.getPublished(DictionaryCache.class)).search(GeoLocation.class, DictSearchCriterion.eq((String)GeoLocation.Property.parent.name(), locRef));
            String result = null;
            for (GeoLocation child : children) {
                if (!LocationType.AIRPORT.equals((Object)child.getType())) continue;
                if (result == null) {
                    result = (String)MiscUtil.findByLocale((Map)child.getTranslations(), (Locale)locale, (Locale)NotificationHandlerUtil.getDefaultNotificationLocale());
                    continue;
                }
                return null;
            }
            return result;
        }
        return null;
    }

    private static String getCountry(DictionaryReference<GeoLocation> locRef, Locale locale) {
        return (String)MiscUtil.findByLocale((Map)((Country)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).resolveReference(((GeoLocation)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).resolveReference(locRef)).getCountry())).getTranslations(), (Locale)locale);
    }

    private static String getCity(DictionaryReference<GeoLocation> locRef, Locale locale) {
        GeoLocation loc = (GeoLocation)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).resolveReference(locRef);
        if (LocationType.AIRPORT.equals((Object)loc.getType())) {
            GeoLocation parent = (GeoLocation)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).resolveReference(loc.getParent());
            if (LocationType.CITY.equals((Object)parent.getType())) {
                return (String)MiscUtil.findByLocale((Map)parent.getTranslations(), (Locale)locale, (Locale)NotificationHandlerUtil.getDefaultNotificationLocale());
            }
        } else if (LocationType.CITY.equals((Object)loc.getType())) {
            return (String)MiscUtil.findByLocale((Map)loc.getTranslations(), (Locale)locale, (Locale)NotificationHandlerUtil.getDefaultNotificationLocale());
        }
        return null;
    }

    private static String getLocationCode(DictionaryReference<GeoLocation> locRef) {
        GeoLocation loc = (GeoLocation)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).resolveReference(locRef);
        String code = (String)loc.getCodeVariants().get(CodeSystem.IATA.name());
        if (TextUtil.isBlank((String)code)) {
            code = (String)loc.getCodeVariants().get(CodeSystem.CRT.name());
        }
        return code;
    }

    private boolean hasExtendedLuggage(ExtendedLuggageInfo info) {
        return info != null && (info.getPieces() != null || info.getWeight() != null || info.getWeightUnit() != null || info.getLength() != null || info.getWidth() != null || info.getHeight() != null || info.getDimensionsSum() != null || info.getDimensionUnit() != null);
    }

    private void addBrandedFareOptions(Map<String, Object> segment, Segment s) {
        FareDetails details = s.getFareDetails();
        if (details != null) {
            segment.put("brandedFareName", GDSHelper.getDisplayBrandName((FareDetails)details, (Locale)LocaleHelper.RU_LOCALE));
            if (details.getMealService() != null) {
                segment.put("mealService", details.getMealService().toString());
            }
            if (Boolean.TRUE.equals(details.getBusinessLoungeAccess())) {
                segment.put("businessLounge", details.getBusinessLoungeAccess());
            }
            if (Boolean.TRUE.equals(details.getClassUpgradeAvailable())) {
                segment.put("classUpgrade", details.getClassUpgradeAvailable());
            }
            if (Boolean.TRUE.equals(details.getExtraMileageBonus())) {
                segment.put("extraMileage", details.getExtraMileageBonus());
            }
            if (Boolean.TRUE.equals(details.getPriorityBoarding())) {
                segment.put("priorityBoarding", details.getPriorityBoarding());
            }
            if (Boolean.TRUE.equals(details.getSeatChoice())) {
                segment.put("seatChoice", details.getSeatChoice());
            }
            if (Boolean.TRUE.equals(details.getTransferIncluded())) {
                segment.put("transferIncluded", details.getTransferIncluded());
            }
            if (this.hasExtendedLuggage(details.getLuggageInfo())) {
                segment.put("luggageInfo", true);
                this.addExtendedLuggageInfoProperties("luggageInfo", segment, details.getLuggageInfo(), null);
            } else if (s.getLuggageInfo() != null) {
                segment.put("luggageInfoGDS", true);
                this.addExtendedLuggageInfoProperties("luggageInfo", segment, s.getLuggageInfo(), null);
            }
            if (this.hasExtendedLuggage(details.getPaidLuggageInfo())) {
                segment.put("paidLuggageInfo", true);
                this.addExtendedLuggageInfoProperties("paidLuggageInfo", segment, details.getPaidLuggageInfo(), details.getPaidLuggagePrice());
            }
            if (this.hasExtendedLuggage(details.getCabinLuggageInfo())) {
                segment.put("cabinLuggageInfo", true);
                this.addExtendedLuggageInfoProperties("cabinLuggageInfo", segment, details.getCabinLuggageInfo(), null);
            }
            if (this.hasExtendedLuggage(details.getPaidCabinLuggageInfo())) {
                segment.put("paidCabinLuggageInfo", true);
                this.addExtendedLuggageInfoProperties("paidCabinLuggageInfo", segment, details.getPaidCabinLuggageInfo(), details.getPaidCabinLuggagePrice());
            }
        }
    }

    private void addExtendedLuggageInfoProperties(String key, Map<String, Object> segment, ExtendedLuggageInfo info, Money price) {
        if (info.getPieces() != null) {
            segment.put(key.concat("Pieces"), info.getPieces());
        }
        if (info.getWeight() != null) {
            segment.put(key.concat("Weight"), info.getWeight());
        }
        if (info.getWeightUnit() != null) {
            segment.put(key.concat("WeightUnit"), DictHelper.toStringWithL10n((DictionaryReference)info.getWeightUnit(), (Locale)this.handlerParameters.getCurLocale()));
        }
        if (info.getLength() != null) {
            segment.put(key.concat("Length"), info.getLength());
        }
        if (info.getWidth() != null) {
            segment.put(key.concat("Width"), info.getWidth());
        }
        if (info.getHeight() != null) {
            segment.put(key.concat("Height"), info.getHeight());
        }
        if (info.getDimensionsSum() != null) {
            segment.put(key.concat("DimensionsSum"), info.getDimensionsSum());
        }
        if (info.getDimensionUnit() != null) {
            segment.put(key.concat("DimensionUnit"), info.getDimensionUnit().toString(this.handlerParameters.getCurLocale()));
        }
        if (price != null) {
            segment.put(key.concat("Price"), price.toString());
        }
    }

    private void addExtendedLuggageInfoProperties(String key, Map<String, Object> segment, LuggageInfo info, Money price) {
        if (info.getQuantity() != null) {
            segment.put(key.concat("Quantity"), info.getQuantity());
        }
        if (info.getUnit() != null) {
            segment.put(key.concat("Unit"), AviaNotificationHandler.convertLuggageUnit2String((DictionaryReference<LuggageUnit>)info.getUnit()));
        }
        if (price != null) {
            segment.put(key.concat("Price"), price.toString());
        }
    }

    private static String convertLuggageUnit2String(DictionaryReference<LuggageUnit> unitRef) {
        if (unitRef != null) {
            LuggageUnit unit = (LuggageUnit)DictionaryCache.get().resolveReference(unitRef);
            if (unit != null && !unit.getSpellVariants().isEmpty()) {
                Locale locale = LocaleHelper.getCurrentLocale();
                return (String)MiscUtil.findByLocale((Map)unit.getTranslations(), (Locale)locale);
            }
            return unitRef.getCode();
        }
        return null;
    }

    private String getAirlineCode(Segment segment) {
        Map codeVariants = ((Airline)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).resolveReference(segment.getAirline())).getCodeVariants();
        for (String codeSystem : PRIORITY_AIRLINE_CODE_SYSTEMS) {
            String airlineCode = (String)codeVariants.get(codeSystem);
            if (!TextUtil.nonBlank((String)airlineCode)) continue;
            return airlineCode;
        }
        return codeVariants.values().stream().findFirst().orElse(null);
    }

    private int sortByPassengerType(Product p1, Product p2) {
        return CommonHelper.getPassengerTypeRank((DictionaryReference)p2.getPassengerType()) - CommonHelper.getPassengerTypeRank((DictionaryReference)p1.getPassengerType());
    }

    private int compareSegmentsByDepartureDate(Segment segment1, Segment segment2, boolean withTimeZone) {
        if (withTimeZone) {
            ZonedDateTime zdt2;
            ZoneId z1 = Objects.requireNonNull(DictHelper.getZoneId((DictionaryReference)segment1.getDepartureLocation()));
            ZoneId z2 = Objects.requireNonNull(DictHelper.getZoneId((DictionaryReference)segment2.getDepartureLocation()));
            ZonedDateTime zdt1 = ZonedDateTime.ofInstant(segment1.getStartDate().toInstant(), z1);
            return zdt1.isAfter(zdt2 = ZonedDateTime.ofInstant(segment2.getStartDate().toInstant(), z2)) ? 1 : -1;
        }
        return segment1.getStartDate().compareTo(segment2.getStartDate());
    }
}

