/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.notifications.handlers;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.hotels2.model.CancellationPolicy;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.CancellationPolicyHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelCancellationRulesHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.GeneralPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.components.ReservationPriceComponents;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.handlers.NotificationHandler;
import com.gridnine.xtrip.server.ibecorp.notifications.handlers.NotificationHandlerParameters;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class HotelsNotificationHandler
extends NotificationHandler {
    public HotelsNotificationHandler(ProductType productType) {
        super(productType);
    }

    @Override
    public void fillContext(Map<String, Object> context, Reservation reservation, NotificationHandlerParameters handlerParameters) {
        EntityContainer contract;
        this.context = context;
        this.handlerParameters = handlerParameters;
        HotelProduct product = reservation.getProducts().stream().filter(bp -> bp instanceof HotelProduct).map(bp -> (HotelProduct)bp).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find hotelProduct in reservation {0}", (Object[])new Object[]{CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation)}));
        Room room = (Room)product.getRooms().get(0);
        context.put("roomName", room.getRoomName());
        context.put("hotelName", product.getHotelName());
        context.put("route", this.getCity(product, handlerParameters.getCurLocale()));
        context.put("checkInDate", NotificationHelper.safeDtFormat(handlerParameters.getDateF(), room.getCheckInDate()));
        context.put("checkOutDate", NotificationHelper.safeDtFormat(handlerParameters.getDateF(), room.getCheckOutDate()));
        context.put("meal", room.getMeal() == null ? null : room.getMeal().getCaption());
        context.put("travellerFullName", ((Traveller)product.getTravellers().get(0)).getName());
        context.put("hasRefundPenalty", product.getPenalties().isEmpty());
        context.put("comments", reservation.getNotes());
        if (product.getVendorContract() != null && (contract = EntityStorageHelper.resolve((EntityReference)product.getVendorContract())) != null) {
            context.put("vendorContractName", ((Contract)contract.getEntity()).getName());
        }
        PriceComponentsParameters parameters = PriceComponentsParameters.getNotificationPriceComponentsParameters(reservation);
        ReservationPriceComponents priceComponents = ReservationPriceComponents.builder(reservation, parameters).build();
        context.put("cancellationPolicyText", this.getCancellationPolicyText(product, priceComponents));
        context.put("referral", product.getTicketType() == TicketType.REFERRAL);
        this.fillPriceInfo(priceComponents);
    }

    private String getCity(HotelProduct product, Locale curLocale) {
        if (product.getHotelLocation() != null) {
            return product.getHotelLocation().toString(curLocale);
        }
        if (product.getCityProviderData() != null) {
            return product.getCityProviderData().getProviderName();
        }
        return "";
    }

    private String getCancellationPolicyText(HotelProduct product, GeneralPriceComponents priceComponents) {
        CancellationPolicy cancellationPolicy;
        try {
            cancellationPolicy = CancellationPolicyHelper.buildHotelsCancellationPolicy((HotelProduct)product);
        }
        catch (Exception e) {
            throw Xeption.forDeveloper((String)"Error during cancellation policy building", (Throwable)e, (Object[])new Object[0]);
        }
        return HotelCancellationRulesHelper.buildCancellationRules((CancellationPolicy)cancellationPolicy, (Money)MoneyHelper.buildMoney((BigDecimal)priceComponents.getTotal(), (String)priceComponents.getCurrency()), (LocalDate)MiscUtil.toLocalDate((Date)((Room)product.getRooms().get(0)).getCheckInDate()), (List)GeneralProductHelper.getUnmodifiableContractRelations((BaseProduct)product), (String)product.getGdsCurrency(), null);
    }

    private void fillPriceInfo(GeneralPriceComponents priceComponents) {
        BigDecimal totalFee = priceComponents.getFee();
        this.context.put("tariff", MiscUtil.guarded((BigDecimal)MiscUtil.sub((BigDecimal)priceComponents.getTotal(), (BigDecimal[])new BigDecimal[]{totalFee})));
        this.context.put("fee", totalFee);
        String currencyCode = priceComponents.getCurrency();
        CurrencyInfo eqvCurrInfo = (CurrencyInfo)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).findByCode(CurrencyInfo.class, currencyCode);
        String currency = eqvCurrInfo.toString(this.handlerParameters.getCurLocale());
        this.context.put("currency", currency);
    }
}

