/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.notifications.handlers;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.handlers.AviaNotificationHandler;
import com.gridnine.xtrip.server.ibecorp.notifications.handlers.HotelsNotificationHandler;
import com.gridnine.xtrip.server.ibecorp.notifications.handlers.NotificationHandler;
import com.gridnine.xtrip.server.ibecorp.notifications.handlers.RailwayNotificationHandler;
import com.gridnine.xtrip.server.ibecorp.notifications.handlers.TransfersNotificationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationHandlerFactory {
    private Logger log = LoggerFactory.getLogger(NotificationHandlerFactory.class);
    private static final NotificationHandlerFactory instance = new NotificationHandlerFactory();

    private NotificationHandlerFactory() {
    }

    public static NotificationHandlerFactory getInstance() {
        return instance;
    }

    public NotificationHandler createHandler(Reservation reservation) {
        for (BaseProduct product : reservation.getProducts()) {
            ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)product);
            ProductType productType = handler.getProductType(product);
            switch (productType) {
                case AIR_TICKET: {
                    return new AviaNotificationHandler(productType);
                }
                case RAILWAY_PRODUCT: {
                    return new RailwayNotificationHandler(productType);
                }
                case HOTEL_RESERVATION: {
                    return new HotelsNotificationHandler(productType);
                }
                case TRANSFER: {
                    return new TransfersNotificationHandler(productType);
                }
            }
        }
        String errorMsg = String.format("No appropriate notification handler found for booking file %s", reservation.getBookingFile().getNumber());
        this.log.error(errorMsg);
        throw Xeption.forDeveloper((String)errorMsg, (Object[])new Object[0]);
    }
}

