/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.notifications.handlers;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.server.ServerApplication;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.http.util.TextUtils;
import org.java.plugin.util.ExtendedProperties;

public class NotificationHandlerUtil {
    public static final Pattern CHILD_WITH_AGE_PATTERN = Pattern.compile("CHILD_[0-1][0-9]");
    public static final NumberFormat priceFormat = new DecimalFormat("#0.00");
    private static Locale defaultNotificationLocale;

    public static Locale getDefaultNotificationLocale() {
        if (defaultNotificationLocale != null) {
            return defaultNotificationLocale;
        }
        ExtendedProperties configuration = ((ServerApplication)Environment.getPublished(ServerApplication.class)).getConfiguration();
        String defaultLanguage = configuration.getProperty("notification.defaultLanguage");
        defaultNotificationLocale = !TextUtils.isEmpty((CharSequence)defaultLanguage) ? Locale.forLanguageTag(defaultLanguage) : Locale.ENGLISH;
        return defaultNotificationLocale;
    }

    public static String formatMinutes(Integer value) {
        if (value == null || value < 1) {
            return "-";
        }
        Integer val = (int)value;
        Integer minutes = val % 60;
        val = (val - minutes) / 60;
        Integer hours = val % 24;
        Integer days = (val - hours) / 24;
        return days > 0 ? String.format("%d:%02d:%02d", days, hours, minutes) : String.format("%02d:%02d", hours, minutes);
    }

    public static BigDecimal round(BigDecimal value) {
        return value.round(new MathContext(value.precision() - value.scale() + 2));
    }
}

