/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.notifications.handlers;

import com.google.common.base.Joiner;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeReference;
import com.gridnine.xtrip.common.model.booking.PassengerTypeValue;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictPredifinedValueProvider;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.ibecorp.PriceDetailDisplay;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.common.components.GeneralPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.components.ReservationPriceComponents;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.handlers.NotificationHandler;
import com.gridnine.xtrip.server.ibecorp.notifications.handlers.NotificationHandlerParameters;
import com.gridnine.xtrip.server.ibecorp.notifications.handlers.NotificationHandlerUtil;
import com.gridnine.xtrip.server.railway.model.helpers.RzdServiceConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class RailwayNotificationHandler
extends NotificationHandler {
    private static final List<ProductStatus> excludeProducts = Arrays.asList(ProductStatus.EXCHANGE, ProductStatus.REFUND);

    RailwayNotificationHandler(ProductType productType) {
        super(productType);
    }

    @Override
    public void fillContext(Map<String, Object> context, Reservation reservation, NotificationHandlerParameters handlerParameters) {
        this.context = context;
        this.handlerParameters = handlerParameters;
        List prodList = RzdCommonHelper.getRelatedReservations((Reservation)reservation).stream().flatMap(res -> res.getProducts().stream()).filter(bp -> bp instanceof RailwayProduct).map(bp -> (RailwayProduct)bp).sorted(this::sortByPassengerType).collect(Collectors.toList());
        LinkedHashMap travellerProductsMap = new LinkedHashMap(reservation.getBookingFile().getTravellers().size());
        for (Object prod2 : prodList) {
            if (!travellerProductsMap.containsKey(prod2.getPassengers().get(0))) {
                travellerProductsMap.put(prod2.getPassengers().get(0), new ArrayList());
            }
            ((List)travellerProductsMap.get(prod2.getPassengers().get(0))).add(prod2);
        }
        travellerProductsMap.values().forEach(list -> list.sort(this::sortProductsByDepartureDate));
        ArrayList passengerContexts = new ArrayList();
        for (Map.Entry entry : travellerProductsMap.entrySet()) {
            HashMap<String, Object> passengerContext = new HashMap<String, Object>();
            Passport passport = ((Traveller)entry.getKey()).getPassport();
            if (passport != null) {
                passengerContext.put("firstName", passport.getFirstName());
                passengerContext.put("lastName", passport.getLastName());
            }
            passengerContexts.add(passengerContext);
            if (((RailwayProduct)((List)entry.getValue()).get(0)).getPassengers().size() <= 1) continue;
            passengerContext = new HashMap();
            Traveller traveller = (Traveller)((RailwayProduct)((List)entry.getValue()).get(0)).getPassengers().get(1);
            passengerContext.put("firstName", traveller.getPassport().getFirstName());
            passengerContext.put("lastName", traveller.getPassport().getLastName());
            passengerContext.put("infantWithoutPlace", Boolean.TRUE);
            passengerContexts.add(passengerContext);
        }
        context.put("passengers", passengerContexts);
        ArrayList<Map<String, Object>> segmentContexts = new ArrayList<Map<String, Object>>();
        HashMap hashMap = new HashMap(travellerProductsMap.size());
        ArrayList<RailwayProduct> list2 = new ArrayList<RailwayProduct>();
        for (Map.Entry entry : travellerProductsMap.entrySet()) {
            List filteredProducts = ((List)entry.getValue()).stream().filter(prod -> !excludeProducts.contains(prod.getStatus())).collect(Collectors.toList());
            hashMap.put(entry.getKey(), filteredProducts);
            list2.addAll(filteredProducts);
        }
        List railwayProducts = (List)hashMap.entrySet().iterator().next().getValue();
        Predicate<RailwayProduct> predicate = railwayProduct -> MiscUtil.equals((Object)RailwayNotificationHandler.getFirstSegment(railwayProduct).getDepartureDate(), (Object)RailwayNotificationHandler.getFirstSegment(railwayProducts).getDepartureDate());
        this.createdSegment(list2, segmentContexts, predicate);
        this.createdSegment(list2, segmentContexts, predicate.negate());
        context.put("segments", segmentContexts);
        RailwaySegment firstSegment = RailwayNotificationHandler.getFirstSegment(railwayProducts);
        context.put("departLocation", this.getLocation((DictionaryReference<RailwayStation>)firstSegment.getDepartureStation()));
        context.put("arriveLocation", this.getLocation((DictionaryReference<RailwayStation>)firstSegment.getArriveStation()));
        context.put("departDate", NotificationHelper.safeDtFormat(handlerParameters.getDateF(), firstSegment.getDepartureDate()));
        context.put("localDepartDate", NotificationHelper.safeDtFormat(handlerParameters.getDateF(), (Date)MiscUtil.guarded((Object)firstSegment.getLocalDepartureDate(), (Object)firstSegment.getDepartureDate())));
        String route = railwayProducts.stream().flatMap(rp -> rp.getSegments().stream()).map(seg -> this.getLocation((DictionaryReference<RailwayStation>)seg.getDepartureStation()) + "-" + this.getLocation((DictionaryReference<RailwayStation>)seg.getArriveStation())).collect(Collectors.joining(", "));
        context.put("route", route);
    }

    private static RailwaySegment getFirstSegment(List<RailwayProduct> railwayProducts) {
        return RailwayNotificationHandler.getFirstSegment(railwayProducts.get(0));
    }

    private static RailwaySegment getFirstSegment(RailwayProduct railwayProduct) {
        return (RailwaySegment)railwayProduct.getSegments().get(0);
    }

    private void addPricesProperties(Reservation reservation, Map<String, Object> segmentContext) {
        PriceComponentsParameters parameters = PriceComponentsParameters.getNotificationPriceComponentsParameters(reservation);
        ReservationPriceComponents components = ReservationPriceComponents.builder(reservation, parameters).build();
        boolean showTariffCols = components.getPriceDetailDisplay() != PriceDetailDisplay.TOTAL_ONLY;
        segmentContext.put("showTariffCols", showTariffCols);
        String currencyCode = components.getCurrency();
        CurrencyInfo eqvCurrInfo = (CurrencyInfo)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).findByCode(CurrencyInfo.class, currencyCode);
        String currency = eqvCurrInfo.toString(this.handlerParameters.getCurLocale());
        segmentContext.put("currency", currency);
        ArrayList passengerPriceInfos = new ArrayList();
        for (PassengerTypeValue ptv : new PassengerTypeValue[]{PassengerTypeValue.ADULT, PassengerTypeValue.CHILD, PassengerTypeValue.INFANT}) {
            PassengerTypeReference passType = ((PassengerType)DictHelper.getPredifinedValue((DictPredifinedValueProvider)ptv)).toReference();
            List<GeneralPriceComponents.PassengerPriceStructure> passengerPriceStructures = components.getPassengerPriceStructures((DictionaryReference<PassengerType>)passType);
            passengerPriceStructures.sort((pps1, pps2) -> pps2.getTariff().compareTo(pps1.getTariff()));
            for (GeneralPriceComponents.PassengerPriceStructure structure : passengerPriceStructures) {
                LinkedHashMap<String, Object> passengersPriceInfo = new LinkedHashMap<String, Object>();
                passengersPriceInfo.put("showTariffCols", showTariffCols);
                passengersPriceInfo.put("currency", currency);
                if (showTariffCols) {
                    passengersPriceInfo.put("tariff_" + passType.getCode(), NotificationHandlerUtil.priceFormat.format(structure.getTariff().doubleValue()));
                    passengersPriceInfo.put("fee_" + passType.getCode(), NotificationHandlerUtil.priceFormat.format(structure.getFees().doubleValue()));
                }
                passengersPriceInfo.put("count_" + passType.getCode(), structure.getPassengerCount().toString());
                passengersPriceInfo.put("total_" + passType.getCode(), NotificationHandlerUtil.priceFormat.format(structure.getTotal().doubleValue()));
                passengerPriceInfos.add(passengersPriceInfo);
            }
        }
        segmentContext.put("passengersPriceInfos", passengerPriceInfos);
        segmentContext.put("total", NotificationHandlerUtil.priceFormat.format(components.getTotal().doubleValue()).toUpperCase());
        if (CommonIbecorpHelper.getReservationStatus((Reservation)reservation) == ReservationStatus.REFUND) {
            segmentContext.put("workflowStatus_REFUND", Boolean.TRUE);
        }
    }

    private void addSegmentProperties(Map<String, Object> segmentContext, List<RailwayProduct> products) {
        RailwaySegment segment = RailwayNotificationHandler.getFirstSegment(products);
        if (Objects.nonNull(segment.getCarrier())) {
            segmentContext.put("carrier", segment.getCarrier().toString(this.handlerParameters.getCurLocale()));
        } else {
            segmentContext.put("carrier", "");
        }
        segmentContext.put("departDate", NotificationHelper.safeDtFormat(this.handlerParameters.getDateF(), segment.getDepartureDate()));
        segmentContext.put("departTime", NotificationHelper.safeDtFormat(this.handlerParameters.getTimeF(), segment.getDepartureDate()));
        Date localDepartureDate = (Date)MiscUtil.guarded((Object)segment.getLocalDepartureDate(), (Object)segment.getDepartureDate());
        segmentContext.put("localDepartDate", NotificationHelper.safeDtFormat(this.handlerParameters.getDateF(), localDepartureDate));
        segmentContext.put("localDepartTime", NotificationHelper.safeDtFormat(this.handlerParameters.getTimeF(), localDepartureDate));
        segmentContext.put("arriveDate", NotificationHelper.safeDtFormat(this.handlerParameters.getDateF(), segment.getArriveDate()));
        segmentContext.put("arriveTime", NotificationHelper.safeDtFormat(this.handlerParameters.getTimeF(), segment.getArriveDate()));
        Date localArriveDate = (Date)MiscUtil.guarded((Object)segment.getLocalArriveDate(), (Object)segment.getArriveDate());
        segmentContext.put("localArriveDate", NotificationHelper.safeDtFormat(this.handlerParameters.getDateF(), localArriveDate));
        segmentContext.put("localArriveTime", NotificationHelper.safeDtFormat(this.handlerParameters.getTimeF(), localArriveDate));
        segmentContext.put("departStation", segment.getDepartureStation().toString(this.handlerParameters.getCurLocale()));
        segmentContext.put("arriveStation", segment.getArriveStation().toString(this.handlerParameters.getCurLocale()));
        segmentContext.put("carriageNumber", segment.getCarriageNumber());
        segmentContext.put("carriageType", segment.getCarriageType().toString(this.handlerParameters.getCurLocale()));
        segmentContext.put("trainNumber", segment.getTrainNumber());
        List placesList = products.stream().map(RailwayNotificationHandler::getFirstSegment).flatMap(seg -> seg.getPlaces().stream()).collect(Collectors.toList());
        String places = Joiner.on((char)',').join(placesList);
        segmentContext.put("places", places);
        segmentContext.put("duration", NotificationHandlerUtil.formatMinutes(segment.getDurationInMinutes()));
        segmentContext.put("classOfService", RzdServiceConverter.getServiceClassName((ServiceClass)segment.getServiceClass()));
        this.addPricesProperties(products.get(0).getReservation(), segmentContext);
    }

    private int sortProductsByDepartureDate(RailwayProduct product1, RailwayProduct product2) {
        Date departureDate2;
        Date departureDate1 = RailwayNotificationHandler.getFirstSegment(product1).getDepartureDate();
        return departureDate1.after(departureDate2 = RailwayNotificationHandler.getFirstSegment(product2).getDepartureDate()) ? 1 : -1;
    }

    private int sortPlaces(RailwayProduct product1, RailwayProduct product2) {
        String place1 = this.getPlace(product1);
        String place2 = this.getPlace(product2);
        return MiscUtil.compare((Comparable)((Object)place1), (Comparable)((Object)place2));
    }

    private String getPlace(RailwayProduct product) {
        List places = RailwayNotificationHandler.getFirstSegment(product).getPlaces();
        return CollectionUtil.isNotEmpty((Collection)places) ? (String)places.get(0) : null;
    }

    public void createdSegment(List<RailwayProduct> list, List<Map<String, Object>> segmentContexts, Predicate<RailwayProduct> predicateDirection) {
        List<RailwayProduct> railwayProductsThere = list.stream().filter(predicateDirection).sorted(this::sortPlaces).collect(Collectors.toList());
        if (!railwayProductsThere.isEmpty()) {
            HashMap<String, Object> segmentContext = new HashMap<String, Object>();
            this.addSegmentProperties(segmentContext, railwayProductsThere);
            segmentContexts.add(segmentContext);
        }
    }

    private String getLocation(DictionaryReference<RailwayStation> stationRef) {
        GeoLocation geoLocation;
        RailwayStation railwayStation = (RailwayStation)DictionaryCache.get().resolveReference(stationRef);
        DictionaryReference geoLocationRef = railwayStation.getGeoLocation();
        if (geoLocationRef != null && (geoLocation = (GeoLocation)DictionaryCache.get().resolveReference(geoLocationRef)) != null && geoLocation.getType() == LocationType.CITY) {
            return geoLocation.toString(this.handlerParameters.getCurLocale());
        }
        return (String)MiscUtil.findByLocale((Map)railwayStation.getShortNames(), (Locale)this.handlerParameters.getCurLocale(), (Locale)NotificationHandlerUtil.getDefaultNotificationLocale());
    }

    private int sortByPassengerType(RailwayProduct p1, RailwayProduct p2) {
        return this.getMainPassengerRank(p2) - this.getMainPassengerRank(p1);
    }

    private int getMainPassengerRank(RailwayProduct p) {
        return RailwayProductHelper.getPassengerTypes((RailwayProduct)p).stream().mapToInt(CommonHelper::getPassengerTypeRank).max().orElse(0);
    }
}

