/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.notifications.handlers;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeValue;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.transfers.PlaceType;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictPredifinedValueProvider;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.ibecorp.PriceDetailDisplay;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.common.components.GeneralPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.components.ReservationPriceComponents;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.handlers.NotificationHandler;
import com.gridnine.xtrip.server.ibecorp.notifications.handlers.NotificationHandlerParameters;
import com.gridnine.xtrip.server.ibecorp.notifications.handlers.NotificationHandlerUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TransfersNotificationHandler
extends NotificationHandler {
    Set<PlaceType> SHOWED_PLACE_TYPE = new HashSet<PlaceType>(Arrays.asList(PlaceType.AIRPORT, PlaceType.RAILWAY_STATION));

    public TransfersNotificationHandler(ProductType productType) {
        super(productType);
    }

    @Override
    public void fillContext(Map<String, Object> context, Reservation reservation, NotificationHandlerParameters handlerParameters) {
        this.context = context;
        this.handlerParameters = handlerParameters;
        List transfers = reservation.getProducts().stream().filter(bp -> bp instanceof Transfer).map(bp -> (Transfer)bp).collect(Collectors.toList());
        Transfer transfer = (Transfer)transfers.get(0);
        List travellers = transfer.getTravellers();
        String travellersNames = travellers.stream().map(Traveller::getName).collect(Collectors.joining(", "));
        context.put("passengers", travellersNames);
        this.addTransferProperties((Transfer)transfers.get(0), context);
        this.addPricesProperties(reservation, context);
    }

    private void addTransferProperties(Transfer transfer, Map<String, Object> context) {
        context.put("departDate", NotificationHelper.safeDtFormat(this.handlerParameters.getDateF(), transfer.getStartDate()));
        context.put("departTime", NotificationHelper.safeDtFormat(this.handlerParameters.getTimeF(), transfer.getStartDate()));
        context.put("arriveDate", NotificationHelper.safeDtFormat(this.handlerParameters.getDateF(), transfer.getEndDate()));
        context.put("arriveTime", NotificationHelper.safeDtFormat(this.handlerParameters.getTimeF(), transfer.getEndDate()));
        context.put("departAddress", transfer.getStartAddress());
        context.put("arriveAddress", transfer.getEndAddress());
        boolean hasSubAddresses = CollectionUtil.isNotEmpty((Collection)transfer.getSubAddresses());
        context.put("hasSubAddresses", hasSubAddresses);
        context.put("subAddresses", TextUtil.join((String)", ", (Iterable)transfer.getSubAddresses(), (boolean)true));
        context.put("passengersCount", transfer.getPassengersCount());
        context.put("classOfCar", transfer.getCarClass().getCaption());
    }

    private void addPricesProperties(Reservation reservation, Map<String, Object> context) {
        PriceComponentsParameters parameters = PriceComponentsParameters.getNotificationPriceComponentsParameters(reservation);
        ReservationPriceComponents components = ReservationPriceComponents.builder(reservation, parameters).build();
        boolean showTariffCols = components.getPriceDetailDisplay() != PriceDetailDisplay.TOTAL_ONLY;
        context.put("showTariffCols", showTariffCols);
        String currencyCode = components.getCurrency();
        CurrencyInfo eqvCurrInfo = (CurrencyInfo)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).findByCode(CurrencyInfo.class, currencyCode);
        String currency = eqvCurrInfo.toString(this.handlerParameters.getCurLocale());
        context.put("currency", currency);
        List<GeneralPriceComponents.PassengerPriceStructure> passengerPriceStructures = components.getPassengerPriceStructures((DictionaryReference<PassengerType>)((PassengerType)DictHelper.getPredifinedValue((DictPredifinedValueProvider)PassengerTypeValue.ADULT)).toReference());
        passengerPriceStructures.sort((pps1, pps2) -> this.getTariffWithAncillaryFees((GeneralPriceComponents.PassengerPriceStructure)pps2).compareTo(this.getTariffWithAncillaryFees((GeneralPriceComponents.PassengerPriceStructure)pps1)));
        ArrayList priceInfos = new ArrayList();
        for (GeneralPriceComponents.PassengerPriceStructure structure : passengerPriceStructures) {
            HashMap<String, Object> priceInfo = new HashMap<String, Object>();
            priceInfo.put("showTariffCols", showTariffCols);
            priceInfo.put("currency", currency);
            if (showTariffCols) {
                priceInfo.put("tariff", NotificationHandlerUtil.priceFormat.format(this.getTariffWithAncillaryFees(structure).doubleValue()));
                priceInfo.put("fee", NotificationHandlerUtil.priceFormat.format(structure.getFees().doubleValue()));
            }
            priceInfo.put("total", NotificationHandlerUtil.priceFormat.format(structure.getTotal().doubleValue()));
            priceInfos.add(priceInfo);
        }
        context.put("priceInfos", priceInfos);
        context.put("total", NotificationHandlerUtil.priceFormat.format(components.getTotal().doubleValue()).toUpperCase());
        if (CommonIbecorpHelper.getReservationStatus((Reservation)reservation) == ReservationStatus.REFUND) {
            context.put("status_REFUND", Boolean.TRUE);
        }
    }

    private BigDecimal getTariffWithAncillaryFees(GeneralPriceComponents.PassengerPriceStructure structure) {
        return MiscUtil.sum((BigDecimal[])new BigDecimal[]{structure.getTariff(), structure.getAncillaryFeesTotal()});
    }
}

