/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.pacworld;

import com.gridnine.bof.midoffice.trace.TraceDataPolicy;
import com.gridnine.bof.midoffice.trace.TraceItem;
import com.gridnine.bof.midoffice.trace.Tracer;
import com.gridnine.bof.midoffice.trace.TracerConfiguration;
import com.gridnine.bof.midoffice.trace.UnlimitedFilesPolicy;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.model.FareRuleParagraph;
import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.ibecorp.PacWorldHelper;
import com.gridnine.xtrip.common.midoffice.helper.CodeTranslator;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.ibecorp.pacworld.PacWorldTraceItem;
import com.gridnine.xtrip.server.ibecorp.pacworld.TicketsIssuedException;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class PacWorldServlet
extends HttpServlet {
    private final transient Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final long serialVersionUID = 5350246167803377284L;
    private static Map<String, String> pnrs = new HashMap<String, String>();
    private final CodeTranslator codeTranslator = new CodeTranslator(new String[]{CodeSystem.IATA.name()});
    private final Locale localeRu = new Locale("ru");
    private NumberFormat priceFormat;
    private final Tracer tracer;

    public PacWorldServlet() {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        this.priceFormat = new DecimalFormat("0.00", dfs);
        this.tracer = new Tracer();
        TracerConfiguration config = new TracerConfiguration();
        config.setFolder(new File(Environment.getTempFolder(), "pacworld-trace"));
        config.setPolicy((TraceDataPolicy)new UnlimitedFilesPolicy());
        this.tracer.setConfiguration(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block40: {
            Element request = null;
            Element response = DocumentBuilderHelper.newDocument().createElement("response");
            Throwable error = null;
            String action = null;
            LogicalStorage.get().authorizeAsSystem();
            request = DocumentBuilderHelper.parse((InputStream)req.getInputStream()).getDocumentElement();
            action = XHelper.readString((Element)request, (String)"action");
            String pnr = XHelper.readString((Element)request, (String)"pnr");
            XHelper.writeString((Element)response, (String)"action", (String)action);
            if ("createSession".equals(action)) {
                PacWorldServlet.createSession(response);
            } else {
                if (pnr == null) {
                    throw new Exception("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 pnr");
                }
                Map<String, String> map = pnrs;
                synchronized (map) {
                    pnrs.put(pnr, pnr);
                }
                try {
                    map = pnrs.get(pnr);
                    synchronized (map) {
                        if ("cancelBooking".equals(action)) {
                            PacWorldServlet.checkSession(XHelper.readString((Element)request, (String)"sessionId"));
                            String pacWorldId = PacWorldServlet.cancelBooking(pnr);
                            XHelper.writeString((Element)response, (String)"pacworldid", (String)pacWorldId);
                        } else if ("issueTickets".equals(action)) {
                            PacWorldServlet.checkSession(XHelper.readString((Element)request, (String)"sessionId"));
                            String pacWorldId = PacWorldServlet.issueTickets(pnr);
                            XHelper.writeString((Element)response, (String)"pacworldid", (String)pacWorldId);
                        } else if ("reprice".equals(action)) {
                            PacWorldServlet.checkSession(XHelper.readString((Element)request, (String)"sessionId"));
                            PacWorldReprice repriceRes = PacWorldServlet.bookingReprice(pnr);
                            if (repriceRes.getErrors().size() > 0) {
                                throw new Exception(MessageHelper.toString(repriceRes.getErrors()));
                            }
                            this.reservation2PacWorldXml(repriceRes.getReservation(), response);
                        } else {
                            throw new Exception("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 action");
                        }
                    }
                }
                finally {
                    map = pnrs;
                    synchronized (map) {
                        pnrs.remove(pnr);
                    }
                }
            }
            XHelper.writeString((Element)response, (String)"success", (String)"");
            this.tracer.trace(new TraceItem[]{new PacWorldTraceItem(request, response, error)});
            try {
                XUtil.newTransformer().transform(new DOMSource(response), new StreamResult(new OutputStreamWriter((OutputStream)res.getOutputStream(), "UTF8")));
            }
            catch (Throwable t) {
                res.sendError(500, t.getMessage());
                this.log.error("response sending failed", t);
            }
            LogicalStorage.reset();
            break block40;
            catch (TicketsIssuedException e) {
                XHelper.writeString((Element)response, (String)"success", (String)"");
                this.tracer.trace(new TraceItem[]{new PacWorldTraceItem(request, response, error)});
                try {
                    XUtil.newTransformer().transform(new DOMSource(response), new StreamResult(new OutputStreamWriter((OutputStream)res.getOutputStream(), "UTF8")));
                }
                catch (Throwable t) {
                    res.sendError(500, t.getMessage());
                    this.log.error("response sending failed", t);
                }
                LogicalStorage.reset();
            }
            catch (Throwable t) {
                error = t;
                XHelper.writeString((Element)response, (String)"error", (String)(t.getMessage() == null ? t.toString() : t.getMessage()));
                {
                    catch (Throwable throwable) {
                        this.tracer.trace(new TraceItem[]{new PacWorldTraceItem(request, response, error)});
                        try {
                            XUtil.newTransformer().transform(new DOMSource(response), new StreamResult(new OutputStreamWriter((OutputStream)res.getOutputStream(), "UTF8")));
                        }
                        catch (Throwable t2) {
                            res.sendError(500, t2.getMessage());
                            this.log.error("response sending failed", t2);
                        }
                        LogicalStorage.reset();
                        throw throwable;
                    }
                }
                this.tracer.trace(new TraceItem[]{new PacWorldTraceItem(request, response, error)});
                try {
                    XUtil.newTransformer().transform(new DOMSource(response), new StreamResult(new OutputStreamWriter((OutputStream)res.getOutputStream(), "UTF8")));
                }
                catch (Throwable t3) {
                    res.sendError(500, t3.getMessage());
                    this.log.error("response sending failed", t3);
                }
                LogicalStorage.reset();
            }
        }
    }

    private static MiscUtil.Pair<EntityContainer<BookingFile>, Reservation> findBooking(String pnr) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)pnr));
        List data = LogicalStorage.get().getEntityStorage().search(BookingFileIndex.class, query).getData();
        if (data.size() != 1) {
            throw new Exception("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u0430\u0437\u0430 \u0441 \u0434\u0430\u043d\u043d\u044b\u043c pnr");
        }
        EntityContainer bfCtr = EntityStorage.get().resolve(((BookingFileIndex)data.get(0)).getSource());
        for (Reservation res : ((BookingFile)bfCtr.getEntity()).getReservations()) {
            if (!CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)res, (String)pnr)) continue;
            return new MiscUtil.Pair((Object)bfCtr, (Object)res);
        }
        throw new Exception("\u041e\u0448\u0438\u0431\u043a\u0430 \u0431\u0430\u0437\u044b (\u0441\u0442\u0430\u0440\u044b\u0439 \u0438\u043d\u0434\u0435\u043a\u0441?)");
    }

    private static SalesContext createSalesContext(Reservation res) {
        return SalesContextHandler.get().createSalesContext(res);
    }

    private static String cancelBooking(String pnr) throws Exception {
        MiscUtil.Pair<EntityContainer<BookingFile>, Reservation> booking = PacWorldServlet.findBooking(pnr);
        String pacWorldId = PacWorldHelper.getPacWorldId((Reservation)((Reservation)booking.getSecond()));
        if (pacWorldId == null) {
            throw new Exception("no pac world id");
        }
        SalesContext salesContext = PacWorldServlet.createSalesContext((Reservation)booking.getSecond());
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("BOOKING_FILE", booking.getFirst());
        data.put("SALES_CONTEXT", salesContext);
        ((IntegrationBusFacade)Environment.getPublished(IntegrationBusFacade.class)).getRequestReplyAdapter("midoffice:cancel-booking").processSync(data);
        booking.setFirst((Object)((EntityContainer)data.get("BOOKING_FILE")));
        try {
            EntityReference bookingRef = ((EntityContainer)booking.getFirst()).toReference();
            NotificationParameters parameters = new NotificationParameters((EntityReference<Organization>)((BookingFile)((EntityContainer)booking.getFirst()).getEntity()).getAgency(), (EntityReference<Organization>)((BookingFile)((EntityContainer)booking.getFirst()).getEntity()).getCustomerProfile(), (EntityReference<SMSite>)((BookingFile)((EntityContainer)booking.getFirst()).getEntity()).getSite(), ((BookingFile)((EntityContainer)booking.getFirst()).getEntity()).getCustomer().getPreferredLocale(), bookingRef, salesContext);
            NotificationHelper.sendNotification(() -> NotificationHelper.getCancelReservationNotification(parameters, (Reservation)booking.getSecond()), bookingRef, true);
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(PacWorldServlet.class).error("Error sending cancel notification", t);
        }
        return pacWorldId;
    }

    private static PacWorldReprice bookingReprice(String pnr) throws Exception {
        PacWorldReprice res;
        MiscUtil.Pair<EntityContainer<BookingFile>, Reservation> booking = PacWorldServlet.findBooking(pnr);
        Card card = new Card();
        card.setVendor(CardVendor.VISA);
        Fop fop = new Fop();
        fop.setType(PaymentType.CREDIT_CARD);
        fop.setCard(card);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("BOOKING_FILE", booking.getFirst());
        data.put("SALES_CONTEXT", PacWorldServlet.createSalesContext((Reservation)booking.getSecond()));
        data.put("FOP", fop);
        ((IntegrationBusFacade)Environment.getPublished(IntegrationBusFacade.class)).getRequestReplyAdapter("midoffice:reprice-booking").processSync(data);
        Collection messages = ((Map)data.get("messages")).values();
        LinkedList<Message> errors = new LinkedList<Message>();
        for (Message msg : messages) {
            if (msg.getType() != MessageType.ERROR) continue;
            errors.add(msg);
        }
        if (errors.size() > 0) {
            res = new PacWorldReprice(null);
            res.getErrors().addAll(errors);
            return res;
        }
        res = new PacWorldReprice((Reservation)((BookingFile)((EntityContainer)data.get("BOOKING_FILE")).getEntity()).getReservations().get(0));
        return res;
    }

    private static String issueTickets(String pnr) throws Exception {
        MiscUtil.Pair<EntityContainer<BookingFile>, Reservation> booking = PacWorldServlet.findBooking(pnr);
        String pacWorldId = PacWorldHelper.getPacWorldId((Reservation)((Reservation)booking.getSecond()));
        if (pacWorldId == null) {
            throw new Exception("no pac world id");
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("BOOKING_FILE", booking.getFirst());
        data.put("SALES_CONTEXT", PacWorldServlet.createSalesContext((Reservation)booking.getSecond()));
        try {
            ((IntegrationBusFacade)Environment.getPublished(IntegrationBusFacade.class)).getRequestReplyAdapter("midoffice:ticket-booking").processSync(data);
            LoggerFactory.getLogger(PacWorldServlet.class).debug("W_COMMAND_SUCCESS = " + data.get("W_COMMAND_SUCCESS"));
        }
        catch (Exception e) {
            if (data.get("W_COMMAND_SUCCESS") != null) {
                LoggerFactory.getLogger(PacWorldServlet.class).debug("W_COMMAND_SUCCESS = " + data.get("W_COMMAND_SUCCESS"));
                LoggerFactory.getLogger(PacWorldServlet.class).error("Exception happened, but tickets were already issued in GDS, suppressing it ", (Throwable)e);
                throw new TicketsIssuedException();
            }
            throw e;
        }
        return pacWorldId;
    }

    private static void createSession(Element response) throws Exception {
        TemporalObject to = new TemporalObject();
        String sessionId = UUID.randomUUID().toString();
        to.setUid(sessionId);
        to.setExpired(new Date(System.currentTimeMillis() + 86400000L));
        to.setData(new byte[0]);
        LogicalStorage.get().getAssetStorage().save((BaseAsset)to);
        XHelper.writeString((Element)response, (String)"sessionId", (String)sessionId);
    }

    private static void checkSession(String sessionId) throws Exception {
        SearchQuery sq = new SearchQuery();
        sq.getCriteria().getCriterions().add(SearchCriterion.eq((String)"uid", (Object)sessionId));
        if (LogicalStorage.get().getAssetStorage().search(TemporalObject.class, sq).getData().size() != 1) {
            throw new Exception("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0435\u0441\u0441\u0438\u0438");
        }
    }

    private Element reservation2PacWorldXml(Reservation res, Element parent) throws Exception {
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Element elm = XmlUtil.addElement((Element)parent, (String)"reservation");
        XHelper.writeString((Element)elm, (String)"pnr", (String)CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)res));
        XHelper.writeString((Element)elm, (String)"timelimit", (String)dateTimeFormat.format(res.getTimeLimit()));
        XHelper.writeString((Element)elm, (String)"pacworldid", (String)PacWorldHelper.getPacWorldId((Reservation)res));
        ReservationStatus rs = CommonIbecorpHelper.getReservationStatus((Reservation)res);
        XHelper.writeString((Element)elm, (String)"status", (String)rs.toString()).setAttribute("code", rs.name());
        Element travellers = XmlUtil.addElement((Element)elm, (String)"travellers");
        boolean segmentsAdded = false;
        for (BaseProduct bp : res.getProducts()) {
            Object st2;
            if (!(bp instanceof Product)) continue;
            Product prod = (Product)bp;
            if (!segmentsAdded) {
                String curr = DictHelper.getPreference((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY).getValue();
                XHelper.writeString((Element)elm, (String)"currency", (String)curr).setAttribute("code", curr);
                if (prod.getCarrier() != null) {
                    XHelper.writeString((Element)elm, (String)"carrier", (String)DictHelper.toStringWithL10n((DictionaryReference)prod.getCarrier(), (Locale)this.localeRu)).setAttribute("code", this.codeTranslator.getNativeCode(prod.getCarrier()));
                }
                Element segments = XmlUtil.addElement((Element)elm, (String)"segments");
                for (Object st2 : prod.getSegmentTariffs()) {
                    for (Segment s : st2.getSegments()) {
                        LocationComponents from;
                        Element segment = XmlUtil.addElement((Element)segments, (String)"segment");
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("SALES_CONTEXT", SalesContextHandler.get().createSalesContext(res));
                        data.put("RESERVATION", res);
                        data.put("FARE_REMARKS_SEARCH_CONTEXT", s.getRemarksSearchContext());
                        try {
                            ((IntegrationBusFacade)Environment.getPublished(IntegrationBusFacade.class)).getRequestReplyAdapter("gds:get-fare-rules").processSync(data);
                        }
                        catch (Exception e) {
                            this.log.error("Could not get fare remarks", (Throwable)e);
                        }
                        Collection fareRemarks = (Collection)data.get("FARE_RULES");
                        if (fareRemarks != null) {
                            StringBuilder sbCommon = new StringBuilder();
                            StringBuilder sbPenalties = new StringBuilder();
                            for (FareRuleParagraph fareRemark : fareRemarks) {
                                if (CommonReservationGdsNameInfoHelper.getGdsNames((Reservation)res).contains(GdsName.SABRE) && "16".equals(fareRemark.getNumber())) {
                                    sbPenalties.append(fareRemark.getContent().replace(" ", "&nbsp;").replace("\r", "<br/>").replace("\n", "<br/>"));
                                    sbPenalties.append("<hr/>");
                                    continue;
                                }
                                sbCommon.append(fareRemark.getContent().replace(" ", "&nbsp;").replace("\r", "<br/>").replace("\n", "<br/>"));
                                sbCommon.append("<hr/>");
                            }
                            XHelper.writeString((Element)segment, (String)"fare_remarks_common", (String)sbCommon.toString(), (boolean)true);
                            XHelper.writeString((Element)segment, (String)"fare_remarks_penalties", (String)sbPenalties.toString(), (boolean)true);
                        }
                        if ((from = LocationComponents.create((DictionaryReference<GeoLocation>)s.getDepartureLocation())).getAirport() != null) {
                            XHelper.writeString((Element)segment, (String)"from_airport", (String)DictHelper.toStringWithL10n((DictionaryReference)from.getAirport().toReference(), (Locale)this.localeRu)).setAttribute("code", this.codeTranslator.getNativeCode((DictionaryReference)from.getAirport().toReference()));
                        }
                        if (from.getCity() != null) {
                            XHelper.writeString((Element)segment, (String)"from_city", (String)DictHelper.toStringWithL10n((DictionaryReference)from.getCity().toReference(), (Locale)this.localeRu)).setAttribute("code", this.codeTranslator.getNativeCode((DictionaryReference)from.getCity().toReference()));
                        }
                        if (from.getCountry() != null) {
                            XHelper.writeString((Element)segment, (String)"from_country", (String)DictHelper.toStringWithL10n((DictionaryReference)from.getCountry().toReference(), (Locale)this.localeRu)).setAttribute("code", this.codeTranslator.getNativeCode((DictionaryReference)from.getCountry().toReference()));
                        }
                        XHelper.writeString((Element)segment, (String)"from_terminal", (String)s.getDepartTerminal());
                        LocationComponents to = LocationComponents.create((DictionaryReference<GeoLocation>)s.getArriveLocation());
                        if (to.getAirport() != null) {
                            XHelper.writeString((Element)segment, (String)"to_airport", (String)DictHelper.toStringWithL10n((DictionaryReference)to.getAirport().toReference(), (Locale)this.localeRu)).setAttribute("code", this.codeTranslator.getNativeCode((DictionaryReference)to.getAirport().toReference()));
                        }
                        if (to.getCity() != null) {
                            XHelper.writeString((Element)segment, (String)"to_city", (String)DictHelper.toStringWithL10n((DictionaryReference)to.getCity().toReference(), (Locale)this.localeRu)).setAttribute("code", this.codeTranslator.getNativeCode((DictionaryReference)to.getCity().toReference()));
                        }
                        if (to.getCountry() != null) {
                            XHelper.writeString((Element)segment, (String)"to_country", (String)DictHelper.toStringWithL10n((DictionaryReference)to.getCountry().toReference(), (Locale)this.localeRu)).setAttribute("code", this.codeTranslator.getNativeCode((DictionaryReference)to.getCountry().toReference()));
                        }
                        XHelper.writeString((Element)segment, (String)"to_terminal", (String)s.getArriveTerminal());
                        XHelper.writeString((Element)segment, (String)"board", (String)DictHelper.toStringWithL10n((DictionaryReference)s.getBoard(), (Locale)this.localeRu)).setAttribute("code", this.codeTranslator.getNativeCode(s.getBoard()));
                        XHelper.writeString((Element)segment, (String)"departure", (String)dateTimeFormat.format(s.getStartDate()));
                        XHelper.writeString((Element)segment, (String)"arrival", (String)dateTimeFormat.format(s.getEndDate()));
                        XHelper.writeString((Element)segment, (String)"marketing/airline", (String)DictHelper.toStringWithL10n((DictionaryReference)s.getAirline(), (Locale)this.localeRu)).setAttribute("code", this.codeTranslator.getNativeCode(s.getAirline()));
                        XHelper.writeString((Element)segment, (String)"marketing/flightno", (String)s.getFlightNo());
                        if (s.getCodeShareCarrier() != null) {
                            XHelper.writeString((Element)segment, (String)"operating/airline", (String)DictHelper.toStringWithL10n((DictionaryReference)s.getCodeShareCarrier(), (Locale)this.localeRu)).setAttribute("code", this.codeTranslator.getNativeCode(s.getCodeShareCarrier()));
                        }
                        ClassOfService classOfService = DictHelper.findClassOfService((Segment)s, (Date)prod.getIssueDate());
                        XHelper.writeString((Element)segment, (String)"class", (String)classOfService.toString()).setAttribute("code", s.getClassOfSvcCode());
                    }
                }
                segmentsAdded = true;
            }
            Traveller trav = prod.getTraveller();
            Element traveller = XmlUtil.addElement((Element)travellers, (String)"traveller");
            XHelper.writeString((Element)traveller, (String)"lastname", (String)trav.getPassport().getLastName());
            XHelper.writeString((Element)traveller, (String)"firstname", (String)trav.getPassport().getFirstName());
            Gender gender = trav.getGender() != null ? trav.getGender() : trav.getPassport().getGender();
            XHelper.writeString((Element)traveller, (String)"gender", (String)gender.toString()).setAttribute("code", gender.name());
            if (trav.getPassport().getBirthday() != null) {
                XHelper.writeString((Element)traveller, (String)"birthdate", (String)dateFormat.format(trav.getPassport().getBirthday()));
            }
            if (trav.getPassport().getCitizenship() != null) {
                XHelper.writeString((Element)traveller, (String)"citizenship", (String)DictHelper.toString((DictionaryReference)trav.getPassport().getCitizenship())).setAttribute("code", this.codeTranslator.getNativeCode(trav.getPassport().getCitizenship()));
            }
            if (trav.getPassport().getType() != null) {
                XHelper.writeString((Element)traveller, (String)"doctype", (String)trav.getPassport().getType().toString()).setAttribute("code", trav.getPassport().getType().name());
            }
            if (trav.getPassport().getOriginCountry() != null) {
                XHelper.writeString((Element)traveller, (String)"doccountry", (String)DictHelper.toString((DictionaryReference)trav.getPassport().getOriginCountry())).setAttribute("code", this.codeTranslator.getNativeCode(trav.getPassport().getOriginCountry()));
            }
            st2 = trav.getCommunications().iterator();
            while (st2.hasNext()) {
                Communication comm = (Communication)st2.next();
                switch (comm.getType()) {
                    case EMAIL: {
                        XHelper.writeString((Element)traveller, (String)"email", (String)comm.getSense());
                        break;
                    }
                    case CELL: 
                    case HOME_PHONE: 
                    case MOBILE: 
                    case WORK_PHONE: {
                        XHelper.writeString((Element)traveller, (String)"phone", (String)(comm.getCountryCode() + comm.getCityCode() + comm.getSense()));
                        break;
                    }
                }
            }
            if (trav.getPassport().getExpired() != null) {
                XHelper.writeString((Element)traveller, (String)"docexpiry", (String)dateFormat.format(trav.getPassport().getExpired()));
            }
            XHelper.writeString((Element)traveller, (String)"docnum", (String)trav.getPassport().getNumber());
            XHelper.writeString((Element)traveller, (String)"fare", (String)this.priceFormat.format(PacWorldServlet.getFare(prod).doubleValue()));
            XHelper.writeString((Element)traveller, (String)"taxes", (String)this.priceFormat.format(PacWorldServlet.getTaxes(prod).doubleValue()));
            XHelper.writeString((Element)traveller, (String)"fees", (String)this.priceFormat.format(GeneralProductHelper.calculateFee((BaseProduct)prod, (ContractType)ContractType.CLIENT).doubleValue()));
            Commission commission = BookingHelper.getTotalVendorCommission((Product)prod);
            if (commission == null) continue;
            if (commission.getRate() != null) {
                XHelper.writeString((Element)traveller, (String)"commission_rate", (String)this.priceFormat.format(commission.getRate()));
                continue;
            }
            XHelper.writeString((Element)traveller, (String)"commission_value", (String)this.priceFormat.format(commission.getEquivalentAmount().doubleValue()));
        }
        return elm;
    }

    private static BigDecimal getFare(Product prod) {
        BigDecimal result = BigDecimal.ZERO;
        for (ProductFare fare : prod.getFares()) {
            result = result.add(fare.getEquivalentFare());
        }
        return result;
    }

    private static BigDecimal getTaxes(Product prod) {
        BigDecimal result = BigDecimal.ZERO;
        for (Tax tax : prod.getTaxes()) {
            result = result.add(tax.getEquivalentAmount());
        }
        return result;
    }

    private static class PacWorldReprice {
        private final List<Message> errors = new LinkedList<Message>();
        private final Reservation reservation;

        public PacWorldReprice(Reservation reservation) {
            this.reservation = reservation;
        }

        public List<Message> getErrors() {
            return this.errors;
        }

        public Reservation getReservation() {
            return this.reservation;
        }
    }

    public static final class LocationComponents {
        private final GeoLocation resource;
        private Country country;
        private GeoLocation city;
        private GeoLocation airport;

        public static LocationComponents create(DictionaryReference<GeoLocation> ref) {
            GeoLocation loc = (GeoLocation)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).resolveReference(ref);
            if (loc == null) {
                return null;
            }
            return new LocationComponents(loc);
        }

        LocationComponents(GeoLocation loc) {
            this.resource = loc;
            DictionaryCache dictionaryCache = (DictionaryCache)Environment.getPublished(DictionaryCache.class);
            this.country = (Country)dictionaryCache.resolveReference(this.resource.getCountry());
            if (this.resource.getType() == LocationType.CITY) {
                this.city = this.resource;
            } else if (this.resource.getType() == LocationType.AIRPORT) {
                this.airport = this.resource;
            }
            GeoLocation parent = this.resource;
            HashSet<GeoLocation> seen = new HashSet<GeoLocation>();
            while (parent != null && (parent = (GeoLocation)dictionaryCache.resolveReference(parent.getParent())) != null) {
                if (seen.contains(parent)) {
                    LoggerFactory.getLogger(PacWorldServlet.class).warn("cyclic parents detected for GEO location " + this.resource);
                    break;
                }
                seen.add(parent);
                if (this.country == null) {
                    this.country = (Country)dictionaryCache.resolveReference(parent.getCountry());
                }
                if (parent.getType() == LocationType.CITY) {
                    this.city = parent;
                    continue;
                }
                if (parent.getType() != LocationType.AIRPORT) continue;
                this.airport = parent;
            }
        }

        GeoLocation getResource() {
            return this.resource;
        }

        public Country getCountry() {
            return this.country;
        }

        public GeoLocation getCity() {
            return this.city;
        }

        public GeoLocation getAirport() {
            return this.airport;
        }
    }
}

