/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.pacworld;

import com.gridnine.bof.midoffice.trace.TraceItem;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PacWorldTraceItem
implements TraceItem {
    private final String action;
    private final String id;
    private final Element req;
    private final Element res;
    private final Throwable err;

    public PacWorldTraceItem(Element request, Element response, Throwable error) {
        String act = XHelper.readString((Element)request, (String)"action");
        this.action = TextUtil.isBlank((String)act) ? "unknown" : act;
        this.req = request;
        this.res = response;
        this.err = error;
        this.id = String.format("%s-%s.xml", this.action, MiscUtil.getTimestamp());
    }

    public String getId() {
        return this.id;
    }

    public void write(OutputStream strm) throws IOException {
        try {
            Document doc = DocumentBuilderHelper.newDocument();
            Element root = doc.createElement("pacworld-transactions");
            doc.appendChild(root);
            root.setAttribute("action", this.action);
            if (this.req != null) {
                root.appendChild(doc.importNode(this.req, true));
            }
            if (this.res != null) {
                root.appendChild(doc.importNode(this.res, true));
            }
            if (this.err != null) {
                Element errelm = doc.createElement("error");
                XmlUtil.setValue((Element)errelm, (String)TextUtil.getExceptionStackTrace((Throwable)this.err));
                root.appendChild(errelm);
            }
            XUtil.newTransformer().transform(new DOMSource(doc), new StreamResult(strm));
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage(), ex);
        }
    }
}

