/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.parsers.organization;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.security.acl.IbeCorpAclRoleIndex;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.l10n.Messages;
import com.gridnine.xtrip.common.parsers.model.OrganizationData;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers2.organization.OrganizationHelper;
import com.gridnine.xtrip.server.parsers2.organization.OrganizationParseOrganizationExchangeDataProcessor;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;

public class IbecorpOrganizationParseOrganizationExchangeDataProcessor
extends OrganizationParseOrganizationExchangeDataProcessor {
    protected void parsePropertyTag(XMLStreamReader reader, MessageContext context, OrganizationData organizationData, Map<String, OrganizationHelper.StatisticsSettingsHandler<OrganizationData>> statisticsSettingsHandlers, boolean registration, Map<String, CostCodeProperties> costCodePropertyUids, String propertyTag) throws Exception {
        super.parsePropertyTag(reader, context, organizationData, statisticsSettingsHandlers, registration, costCodePropertyUids, propertyTag);
        switch (propertyTag) {
            case "roleOrganization": {
                HashSet roleOrganizationCodes = new HashSet(this.getItems(this::getRoleOrganizationCode, reader, context));
                roleOrganizationCodes.forEach(roleOrganizationCode -> {
                    if (!TextUtil.isBlank((String)roleOrganizationCode)) {
                        SearchQuery query = new SearchQuery();
                        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)IbeCorpAclRoleIndex.Property.name.name(), (Object)roleOrganizationCode));
                        List roleOrganizationIndexes = EntityStorage.get().search(IbeCorpAclRoleIndex.class, query).getData();
                        if (roleOrganizationIndexes.size() > 1) {
                            context.addMessage(MessagesHelper.MessageBuilder.of((MessageType)MessageType.WARNING).key(Messages.OrganizationExchangeProcessor_organizationRoleDefineAmbiguous).details(L10nResourcesManager.getStr((String)Messages.OrganizationExchangeProcessor_roleOrganizationWithCodeMultipleFound, (Object[])new Object[]{roleOrganizationCode.trim()})).build());
                        } else if (roleOrganizationIndexes.size() > 0) {
                            roleOrganizationIndexes.forEach(rOI -> {
                                EntityContainer resolve = EntityStorage.get().resolve(rOI.getSource());
                                if (EntityStorageHelper.nonEmpty((EntityContainer)resolve)) {
                                    organizationData.getRoleOrganizations().add(resolve.toReference());
                                }
                            });
                        } else {
                            context.addMessage(MessagesHelper.MessageBuilder.of((MessageType)MessageType.WARNING).key(Messages.OrganizationExchangeProcessor_organizationRoleDefineFailed).details(L10nResourcesManager.getStr((String)Messages.OrganizationExchangeProcessor_roleOrganizationWithCodeNotFound, (Object[])new Object[]{organizationData.getShortName(), roleOrganizationCode.trim()})).build());
                        }
                    }
                });
            }
        }
    }

    private String getRoleOrganizationCode(XMLStreamReader reader, MessageContext context) throws Exception {
        String roleOrganizationCode = null;
        String roleCode = reader.getElementText();
        if (!TextUtil.isBlank((String)roleCode)) {
            try {
                roleOrganizationCode = roleCode.trim();
            }
            catch (IllegalArgumentException e) {
                context.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.OrganizationExchangeProcessor_organizationRoleDefineFailed, (Object[])new Object[]{L10nResourcesManager.getStr((String)Messages.OrganizationExchangeProcessor_roleOrganizationWithCodeNotFound, (Object[])new Object[]{roleCode.trim()})}));
            }
        }
        return roleOrganizationCode;
    }
}

