/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.parsers.organization;

import com.gridnine.xtrip.common.ibecorp.parsers.IbecorpOrganizationData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.parsers.helpers.OrganizationSearchResult;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;

public class IbecorpOrganizationUpdateOrganizationProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        IbecorpOrganizationData data = (IbecorpOrganizationData)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_DATA);
        OrganizationSearchResult searchResult = (OrganizationSearchResult)context.getMandatoryObject((Enum)IBusParsersContextKeys.SEARCH_RESULT);
        Organization organization = (Organization)searchResult.getOrganization().getEntity();
        this.update(organization, data);
    }

    private void update(Organization organization, IbecorpOrganizationData data) {
        boolean appendMode = BooleanUtil.nullAsFalse((Boolean)data.getAppendMode());
        if (!appendMode) {
            organization.getCalculatedStatisticSettings().clear();
        }
        organization.getCalculatedStatisticSettings().addAll(data.getCalculatedStatisticSettings());
        if (!appendMode) {
            organization.getAclSettings().getOrganizationAclRoles().clear();
            organization.getAclSettings().getOrganizationAclRoles().addAll(data.getRoleOrganizations());
        } else {
            CollectionUtil.merge((Collection)organization.getAclSettings().getOrganizationAclRoles(), (Collection)data.getRoleOrganizations(), MiscUtil::equals);
        }
    }
}

