/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.parsers.person;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.parsers.l10n.Messages;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.parsers.person.IbecorpPersonData;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers2.person.PersonValidatePersonExchangeDataProcessor;
import java.util.List;

public class IbecorpPersonValidateExchangeDataProcessor
extends PersonValidatePersonExchangeDataProcessor {
    public void process(MessageContext context) throws Exception {
        String roleUid;
        super.process(context);
        IbecorpPersonData data = (IbecorpPersonData)((Object)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_DATA));
        List personEmploymentList = data.getEmployments();
        PersonEmployment personEmployment = personEmploymentList.stream().filter(e -> e.isMainEmployment()).findFirst().orElse(null);
        String employmentMainUid = null;
        if (personEmployment != null) {
            employmentMainUid = personEmployment.getOrganization().getUid();
        } else {
            context.addMessage(MessageHelper.createWarningMessage((String)Messages.PersonExchangeProcessor_validationRoleOrganization, (String)L10nResourcesManager.getStr((String)Messages.PersonExchangeProcessor_personValidationMainOrganization, (Object[])new Object[0]), (Object[])new Object[0]));
            data.setRole(null);
        }
        if (data.getRole() != null && (TextUtil.nonBlank((String)(roleUid = data.getRole().getUid())) || TextUtil.nonBlank((String)employmentMainUid))) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"containerUid", (Object)employmentMainUid));
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.roleOrganizationUids.name(), (Object)roleUid));
            if (EntityStorage.get().search(OrganizationIndex.class, query).getData().size() == 0) {
                context.addMessage(MessageHelper.createWarningMessage((String)Messages.PersonExchangeProcessor_validationRoleOrganization, (String)L10nResourcesManager.getStr((String)Messages.PersonExchangeProcessor_personValidationRoleOrganization, (Object[])new Object[0]), (Object[])new Object[]{data.getRole().getCaption()}));
                data.setRole(null);
            }
        }
    }
}

