/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.parsers.ssod;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.common.StorageHelper;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import com.gridnine.xtrip.server.parsers.helpers.ParsersHelper;
import com.gridnine.xtrip.server.parsers.ssod.common.PrepairBookingHelper;
import com.gridnine.xtrip.server.parsers.ssod.common.PrepareBookingHelperCustomizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class IbePrepareMixvelBookingHelperCustomizer
implements PrepareBookingHelperCustomizer {
    public ProductSearchResult findBookingByPnrAndTravellerAndStartLocation(String sirenaPnr, Traveller traveller, List<MiscUtil.Pair<DictionaryReference<GeoLocation>, DictionaryReference<GeoLocation>>> segmentsLocations) {
        if (sirenaPnr == null) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchQueryHelper.getRecordLocatorSearchCriterionForCommonProductIndex((String)sirenaPnr));
        ArrayList productSearchResults = new ArrayList();
        for (EntityContainer ctr : StorageHelper.getEntityContainers((SearchQuery)query, CommonProductIndex.class).stream().distinct().collect(Collectors.toList())) {
            List result = ((BookingFile)ctr.getEntity()).getReservations().stream().filter(reservation -> CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)reservation, (String)sirenaPnr)).flatMap(reservation -> reservation.getProducts().stream()).filter(baseProduct -> baseProduct instanceof Product).map(baseProduct -> (Product)baseProduct).filter(product -> product.getTicketType() != TicketType.CORRECTION && product.getStatus() == ProductStatus.BOOKING && product.getTraveller() != null).filter(product -> this.checkSegmentMatching((Product)product, segmentsLocations)).filter(product -> this.checkTravellerMatching((Product)product, traveller)).map(product -> new ProductSearchResult((BookingFile)ctr.getEntity(), (BaseProduct)product, product.getReservation(), ctr, false)).collect(Collectors.toList());
            if (!CollectionUtil.isNotEmpty(result)) continue;
            productSearchResults.addAll(result);
        }
        if (CollectionUtil.isNotEmpty(productSearchResults)) {
            ((ProductSearchResult)productSearchResults.get(0)).setUnique(productSearchResults.size() == 1);
            return (ProductSearchResult)productSearchResults.get(0);
        }
        return null;
    }

    public EntityContainer<BookingFile> findBookingFileByPnr(String pnr) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchQueryHelper.getRecordLocatorSearchCriterionForCommonProductIndex((String)pnr));
        SearchResult searchResult = EntityStorage.get().search(CommonProductIndex.class, query);
        if (searchResult != null) {
            List data = searchResult.getData();
            HashSet bookingFiles = new HashSet();
            data.stream().map(commonProductIndex -> EntityStorage.get().resolve(commonProductIndex.getSource())).forEach(bookingFiles::add);
            if (bookingFiles.size() == 1) {
                return (EntityContainer)CollectionUtil.head(bookingFiles);
            }
        }
        return null;
    }

    public Reservation findReservationInBookingFileByPnr(BookingFile bookingFile, String pnr) {
        return bookingFile.getReservations().stream().filter(res -> CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)res, (String)ParsersHelper.getLatinPnr((String)pnr))).findFirst().orElse(null);
    }

    private boolean checkSegmentMatching(Product product, List<MiscUtil.Pair<DictionaryReference<GeoLocation>, DictionaryReference<GeoLocation>>> segmentsLocations) {
        List segmentTariffs = product.getSegmentTariffs();
        if (CollectionUtil.isEmpty(segmentsLocations) && CollectionUtil.isEmpty((Collection)segmentTariffs)) {
            return true;
        }
        List segments = product.getSegmentTariffs().stream().flatMap(st -> st.getSegments().stream()).collect(Collectors.toList());
        if (segments.size() != segmentsLocations.size()) {
            return false;
        }
        for (int i = 0; i < segmentsLocations.size(); ++i) {
            if (PrepairBookingHelper.isSameCities((DictionaryReference)((DictionaryReference)segmentsLocations.get(i).getFirst()), (DictionaryReference)((Segment)segments.get(i)).getDepartureLocation()) && PrepairBookingHelper.isSameCities((DictionaryReference)((DictionaryReference)segmentsLocations.get(i).getSecond()), (DictionaryReference)((Segment)segments.get(i)).getArriveLocation())) continue;
            return false;
        }
        return true;
    }

    private boolean checkTravellerMatching(Product product, Traveller traveller) {
        if (!TextUtil.isBlank((String)traveller.getName()) && !TextUtil.isBlank((String)product.getTraveller().getName()) && traveller.getName().trim().equalsIgnoreCase(product.getTraveller().getName().trim())) {
            return true;
        }
        return traveller.getPassport() != null && product.getTraveller().getPassport() != null && !TextUtil.isBlank((String)product.getTraveller().getPassport().getNumber()) && !TextUtil.isBlank((String)traveller.getPassport().getNumber()) && product.getTraveller().getPassport().getNumber().trim().equalsIgnoreCase(traveller.getPassport().getNumber().trim());
    }
}

