/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.pg;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.pg.SplitPaymentSupport;
import com.gridnine.xtrip.common.model.system.CardTransactionDetails;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.handlers.CustomProductFopsHandler;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.LoggerFactory;

public class IBECustomProductFopsHandler
implements CustomProductFopsHandler {
    public boolean recreateCustomProductSplitFops(BaseProduct bp, ProductHandler<BaseProduct> handler, SplitPaymentSupport connector) {
        GeneralProductFop fop = new GeneralProductFop();
        fop.setType(connector.getSplitAgencyPaymentType());
        try {
            this.processFop(bp, handler, fop);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(IBECustomProductFopsHandler.class).error("Failed to process fop", (Throwable)e);
        }
        return true;
    }

    public boolean createCustomProductFops(BaseProduct bp, PaymentType paymentType, CardTransactionDetails details) throws Exception {
        ProductHandler handler = Objects.requireNonNull(GeneralProductHelper.getHandler((BaseProduct)bp), "Missing handler for product " + bp.getClass());
        GeneralProductFop fop = new GeneralProductFop();
        fop.setType(paymentType);
        fop.setCard(PaymentHelper.convertCardDetailsToCard((CardTransactionDetails)details));
        this.processFop(bp, (ProductHandler<BaseProduct>)handler, fop);
        return true;
    }

    private void processFop(BaseProduct bp, ProductHandler<BaseProduct> handler, GeneralProductFop fop) throws Exception {
        BigDecimal price = Optional.ofNullable(handler.calculateProductPrice(bp, null)).map(VatAmount::getTotal).orElse(null);
        fop.setEquivalentAmount(price);
        fop.setOperationDate(new Date());
        List contractRelations = handler.getUnmodifiableContractRelations(bp);
        for (GeneralProductContractRelationData contractRelation : contractRelations) {
            contractRelation.getFops().clear();
            contractRelation.getCommissions().clear();
            contractRelation.getFops().add(XCloneHelper.clone((XCloneable)fop, (boolean)true));
        }
        handler.updateContractRelations(bp, contractRelations);
        handler.setContractRulesApplied(bp, false);
    }
}

