/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.pg;

import com.gridnine.bof.midoffice.helper.MidofficeHelper;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.helper.PccHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageLoadParameters;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.mail.MailPart;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.PccParameterName;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.IssuingFailedNotificationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import com.gridnine.xtrip.server.pg.PGRulesHelper;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.handlers.PaymentStatusHandler;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import com.gridnine.xtrip.server.pg.wayforpay.WayForPayHelper;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IBEPaymentStatusHandler
implements PaymentStatusHandler {
    private static final transient Logger log = LoggerFactory.getLogger(IBEPaymentStatusHandler.class);

    public void paymentInitiated(Payment payment, List<Message> messages) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void paymentSucceeded(Payment payment, SalesContext aSalesContext, List<Message> messages, EntityContainer<BookingFile> bookingFileCtr) {
        try {
            bfCtr = ((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(payment.getEntity(), (EntityStorageLoadParameters)new EntityStorageLoadParameters().noCache(true));
            reservations = MidofficeHelper.getReservations((BookingFile)((BookingFile)bfCtr.getEntity()), (Collection)PaymentHelper.getReservations((BookingFile)((BookingFile)bfCtr.getEntity()), (Collection)payment.getReservations()));
            data = new ArrayList<E>();
            sirenaOnlinePaymentType = payment.getPaymentType() == PaymentType.CREDIT_CARD_ONLINE_SIRENA;
            sirenaGdsName = Arrays.stream(GdsName.values()).filter((Predicate<GdsName>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$paymentSucceeded$0(com.gridnine.xtrip.common.model.dict.GdsName ), (Lcom/gridnine/xtrip/common/model/dict/GdsName;)Z)()).collect(Collectors.toSet());
            for (Reservation reservation : reservations) {
                reservation.setStatus(ReservationStatus.PAYED);
                salesContext = SalesContextHandler.get().createSalesContext(reservation);
                if (!sirenaOnlinePaymentType) ** GOTO lbl-1000
                if (CommonReservationGdsNameInfoHelper.getGdsNames((Reservation)reservation).stream().anyMatch((Predicate<GdsName>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Lcom/gridnine/xtrip/common/model/dict/GdsName;)Z)(sirenaGdsName))) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
                sirenaOnline = v0;
                data.stream().filter((Predicate<Data>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$paymentSucceeded$1(com.gridnine.xtrip.common.midoffice.model.SalesContext boolean com.gridnine.xtrip.server.ibecorp.pg.IBEPaymentStatusHandler$Data ), (Lcom/gridnine/xtrip/server/ibecorp/pg/IBEPaymentStatusHandler$Data;)Z)((SalesContext)salesContext, (boolean)sirenaOnline)).findFirst().orElseGet((Supplier<Data>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$paymentSucceeded$2(com.gridnine.xtrip.common.midoffice.model.SalesContext boolean java.util.Collection ), ()Lcom/gridnine/xtrip/server/ibecorp/pg/IBEPaymentStatusHandler$Data;)((SalesContext)salesContext, (boolean)sirenaOnline, data)).getReservations().add(reservation);
            }
            issued = new ArrayList<Reservation>();
            error = new ArrayList<Reservation>();
            wayForPayCorrected = new ArrayList<E>();
            try {
                for (Data item : data) {
                    if (item.isSirenaOnline()) {
                        for (Reservation reservation : item.getReservations()) {
                            try {
                                idata = new HashMap<String, Object>();
                                idata.put(IBusMidofficeContextKeys.SALES_CONTEXT.name(), item.getSalesContext());
                                idata.put(IBusMidofficeContextKeys.RESERVATION.name(), reservation);
                                idata.put(IBusMidofficeContextKeys.GDS_ACCOUNT.name(), EntityStorage.get().resolve(reservation.getGdsNameInfo().getOnlineGdsAccount()));
                                ((IntegrationBusFacade)Environment.getPublished(IntegrationBusFacade.class)).getRequestReplyAdapter("gds:sirena:get-extra-reservation-info:get-extra-reservation-info").processSync(idata);
                                docs = (Collection)idata.get(IBusMidofficeContextKeys.BOOKING_FILE_DOCUMENTS.name());
                                if (docs != null) {
                                    for (BaseFileDocument doc : docs) {
                                        doc.setOwner(bfCtr.toReference());
                                        EntityStorage.get().save(EntityContainer.create((BaseEntity)doc), true);
                                    }
                                }
                                msgs = ((Map)idata.get("messages")).values();
                                SysLogHelper.audit((EntityReference)bfCtr.toReference(), (String)"get-extra-reservation-info", msgs);
                                issued.add(reservation);
                            }
                            catch (Throwable t) {
                                IBEPaymentStatusHandler.log.error("", t);
                                error.add(reservation);
                            }
                        }
                        continue;
                    }
                    toIssue = item.getReservations().stream().filter((Predicate<Reservation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$paymentSucceeded$4(com.gridnine.xtrip.common.model.booking.Reservation ), (Lcom/gridnine/xtrip/common/model/booking/Reservation;)Z)()).collect(Collectors.toList());
                    fop = PaymentHelper.createFop((Payment)payment);
                    ctx = new HashMap<String, Object>();
                    ctx.put("SALES_CONTEXT", item.getSalesContext());
                    ctx.put("BOOKING_FILE", bfCtr);
                    ctx.put(IBusMidofficeContextKeys.BOOKING_FILE_RESERVATIONS.name(), item.getReservations());
                    ctx.put("FOP", fop);
                    ctx.put("PAYMENT_TYPE", payment.getPaymentType());
                    hasErrors = true;
                    try {
                        ((IntegrationBusFacade)Environment.getPublished(IntegrationBusFacade.class)).getRequestReplyAdapter("midoffice:ticket-booking").processSync(ctx);
                        messages.addAll(((Map)ctx.get("messages")).values());
                        bfCtr = (EntityContainer)ctx.get("BOOKING_FILE");
                        ((BookingFile)bfCtr.getEntity()).getReservations().stream().filter((Predicate<Reservation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Lcom/gridnine/xtrip/common/model/booking/Reservation;)Z)((Collection)toIssue)).forEach((Consumer<Reservation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(E ), (Lcom/gridnine/xtrip/common/model/booking/Reservation;)V)(issued));
                        issued.addAll(toIssue);
                        hasErrors = false;
                    }
                    catch (Throwable t) {
                        IBEPaymentStatusHandler.log.error("", t);
                    }
                    if (!hasErrors && !IBEPaymentStatusHandler.hasErrors(messages)) continue;
                    error.addAll(toIssue);
                    IBEPaymentStatusHandler.log.error("auto-ticketing failed (errors in messages)");
                }
            }
            finally {
                if (!issued.isEmpty() || !error.isEmpty()) {
                    bfCtr = (EntityContainer)LockUtil.lock((EntityReference)payment.getEntity(), (LockUtil.CallableWithParameterAndException)(LockUtil.CallableWithParameterAndException)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$paymentSucceeded$5(java.util.Collection java.util.Collection com.gridnine.xtrip.common.pg.model.Payment com.gridnine.xtrip.common.model.EntityContainer ), (Lcom/gridnine/xtrip/common/model/EntityContainer;)Lcom/gridnine/xtrip/common/model/EntityContainer;)((IBEPaymentStatusHandler)this, error, wayForPayCorrected, (Payment)payment));
                }
            }
            reservations = MidofficeHelper.getReservations((BookingFile)((BookingFile)bfCtr.getEntity()), (Collection)PaymentHelper.getReservations((BookingFile)((BookingFile)bfCtr.getEntity()), (Collection)payment.getReservations()));
            error.removeAll(wayForPayCorrected);
            for (Reservation reservation : MidofficeHelper.getReservations((BookingFile)((BookingFile)bfCtr.getEntity()), wayForPayCorrected)) {
                NotificationHelper.sendServiceFeeReceiptNotification((EntityReference<Organization>)reservation.getSubagency(), (EntityReference<Organization>)((BookingFile)bfCtr.getEntity()).getCustomerProfile(), new Locale("ru"), reservation, bfCtr.toReference());
            }
            if (!error.isEmpty()) {
                IBEPaymentStatusHandler.sendIssuingFailedNotification(bfCtr, MidofficeHelper.getReservations((EntityContainer)bfCtr, error), payment);
            }
            IBEPaymentStatusHandler.sendNotifications((EntityContainer<BookingFile>)bfCtr, reservations);
            if (error.isEmpty()) {
                IBEPaymentStatusHandler.createFiscalReceipt((EntityContainer<BookingFile>)bfCtr, reservations, payment);
            }
        }
        catch (Exception ex) {
            IBEPaymentStatusHandler.log.error("auto-ticketing failed", (Throwable)ex);
        }
    }

    private Collection<Reservation> customWayForPayProcessing(EntityContainer<?> bfCtr, Payment payment, Collection<Reservation> reservations) {
        if (payment.getPg() != PgName.WAYFORPAY) {
            return Collections.emptyList();
        }
        ArrayList<Reservation> result = new ArrayList<Reservation>();
        for (Reservation reservation : reservations) {
            try {
                String printer;
                SalesContext salesContext;
                PGParameters pgParameters;
                if (reservation.getStatus() != ReservationStatus.ERROR || WayForPayHelper.isTwoStageMode((String)(pgParameters = PGRulesHelper.getPGParameters((SalesContext)(salesContext = SalesContextHandler.get().createSalesContext(reservation)), (PgName)PgName.WAYFORPAY, (Payment)payment)).getPgAccount(), (PaymentType)payment.getPaymentType())) continue;
                Product baseProduct = (Product)AirProductHelper.getAirProductsList((Reservation)reservation).get(0);
                String pcc = baseProduct.getPcc();
                Validator validator = GDSHelper.findValidatorByPccAndBlankOwner((EntityReference)baseProduct.getSalesPoint(), (String)pcc, (EntityReference)baseProduct.getBlankOwnerRef());
                if (validator == null || validator.getPCC() == null || !TextUtil.isBlank((String)(printer = PccHelper.getPccParameter((Pcc)validator.getPCC(), (PccParameterName)PccParameterName.SABRE_PRINTER_LNIATA)))) continue;
                reservation.setStatus(ReservationStatus.PAYED);
                result.add(reservation);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        return result;
    }

    private static void sendNotifications(EntityContainer<BookingFile> bfCtr, Collection<Reservation> reservations) throws Exception {
        Locale locale = null;
        if (((BookingFile)bfCtr.getEntity()).getCustomer() != null) {
            locale = ((BookingFile)bfCtr.getEntity()).getCustomer().getPreferredLocale();
        }
        if (locale == null) {
            locale = LocaleManager.get().getCurrentLocale();
        }
        for (Reservation reservation : reservations) {
            if (reservation.getStatus() != ReservationStatus.ISSUED) continue;
            NotificationHelper.sendServicesIssuedNotification((EntityReference<Organization>)reservation.getSubagency(), (EntityReference<Organization>)((BookingFile)bfCtr.getEntity()).getCustomerProfile(), locale, reservation, bfCtr.toReference());
        }
    }

    private static void sendIssuingFailedNotification(EntityContainer<?> bfCtr, Collection<Reservation> reservations, Payment payment) throws Exception {
        for (Reservation reservation : reservations) {
            EntityReference agencyRef = reservation.getSubagency();
            Organization agency = (Organization)((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(agencyRef).getEntity();
            LinkedList<String> emailsTo = new LinkedList<String>();
            for (Communication comm : agency.getCommunications()) {
                if (comm.getType() != CommunicationType.EMAIL) continue;
                emailsTo.add(comm.getSense());
            }
            NotificationHelper.sendSimpleNotification(bfCtr.toReference(), (EntityReference<SMSite>)reservation.getBookingFile().getSite(), emailsTo.toArray(new String[emailsTo.size()]), IssuingFailedNotificationHelper.getSubject(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation)), IssuingFailedNotificationHelper.getText(bfCtr, reservation, payment), false, new MailPart[0]);
        }
    }

    private static void createFiscalReceipt(EntityContainer<BookingFile> bookingFile, Collection<Reservation> reservations, Payment payment) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(IBusMidofficeContextKeys.BOOKING_FILE.name(), bookingFile);
        data.put(IBusMidofficeContextKeys.BOOKING_FILE_RESERVATIONS.name(), reservations);
        data.put(IBusPgConnectorContextKeys.PAYMENT.name(), payment);
        ((IntegrationBusFacade)Environment.getPublished(IntegrationBusFacade.class)).sendRouteAsync("ibecorp:fiscal:create-online-receipt", data);
    }

    private static boolean hasErrors(List<Message> messages) {
        for (Message msg : messages) {
            if (msg.getType() != MessageType.ERROR) continue;
            return true;
        }
        return false;
    }

    public void paymentFailed(Payment payment, List<Message> messages) {
    }

    private /* synthetic */ EntityContainer lambda$paymentSucceeded$5(Collection error, Collection wayForPayCorrected, Payment payment, EntityContainer ctr) throws Exception {
        for (Reservation reservation : ((BookingFile)ctr.getEntity()).getReservations()) {
            if (!error.contains(reservation)) continue;
            reservation.setStatus(ReservationStatus.ERROR);
        }
        wayForPayCorrected.addAll(this.customWayForPayProcessing(ctr, payment, MidofficeHelper.getReservations((BookingFile)((BookingFile)ctr.getEntity()), (Collection)PaymentHelper.getReservations((BookingFile)((BookingFile)ctr.getEntity()), (Collection)payment.getReservations()))));
        if (!error.isEmpty() || !wayForPayCorrected.isEmpty()) {
            ctr.getVersionInfo().setVersionNotes("");
            ctr.getVersionInfo().setDataSource("auto-ticketing");
            LogicalStorage.get().getEntityStorage().save(ctr, true);
        }
        return ctr;
    }

    private static /* synthetic */ boolean lambda$paymentSucceeded$4(Reservation r) {
        return r.getProducts().stream().anyMatch(p -> GeneralProductHelper.getStatus((BaseProduct)p) == ProductStatus.BOOKING || GeneralProductHelper.getStatus((BaseProduct)p) == ProductStatus.INTENTION);
    }

    private static /* synthetic */ Data lambda$paymentSucceeded$2(SalesContext salesContext, boolean sirenaOnline, Collection data) {
        Data d = new Data(salesContext, sirenaOnline);
        data.add(d);
        return d;
    }

    private static /* synthetic */ boolean lambda$paymentSucceeded$1(SalesContext salesContext, boolean sirenaOnline, Data d) {
        return Objects.equals(d.getSalesContext().getSalesPoint(), salesContext.getSalesPoint()) && d.isSirenaOnline() == sirenaOnline;
    }

    private static /* synthetic */ boolean lambda$paymentSucceeded$0(GdsName gdsName) {
        return gdsName.name().startsWith("SIRENA");
    }

    private static class Data {
        final SalesContext salesContext;
        final boolean sirenaOnline;
        final Collection<Reservation> reservations = new ArrayList<Reservation>();

        public Data(SalesContext salesContext, boolean sirenaOnline) {
            this.salesContext = salesContext;
            this.sirenaOnline = sirenaOnline;
        }

        public SalesContext getSalesContext() {
            return this.salesContext;
        }

        public boolean isSirenaOnline() {
            return this.sirenaOnline;
        }

        public Collection<Reservation> getReservations() {
            return this.reservations;
        }
    }
}

