/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.pg;

import com.gridnine.bof.midoffice.helper.MidofficeHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.CardTransactionDetails;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.server.pg.handlers.BookingFileUpdateFopTypeHandler;
import java.util.Collection;
import java.util.List;

public class IbeBookingFileUpdateFopTypeHandler
implements BookingFileUpdateFopTypeHandler {
    public void update(EntityContainer<BookingFile> bookingFile, PaymentType bookingPaymentType, EntityReference<Organization> payerRef, CardTransactionDetails cardTransactionDetails) {
        this.update(bookingFile, null, bookingPaymentType, payerRef, cardTransactionDetails);
    }

    public void update(EntityContainer<BookingFile> bookingFile, Collection<Reservation> reservations, PaymentType bookingPaymentType, EntityReference<Organization> payerRef, CardTransactionDetails cardTransactionDetails) {
        this.updateFops((BookingFile)bookingFile.getEntity(), reservations);
    }

    private void updateFops(BookingFile bookingFile, Collection<Reservation> reservations) {
        for (Reservation reservation : MidofficeHelper.getReservations((BookingFile)bookingFile, reservations)) {
            for (BaseProduct product : reservation.getProducts()) {
                List relations = GeneralProductHelper.copyContractRelations((BaseProduct)product);
                for (GeneralProductContractRelationData relation : relations) {
                    ContractType contractType = GeneralProductHelper.getContractType((EntityReference)relation.getDescription());
                    for (GeneralProductFop fop : relation.getFops()) {
                        switch (contractType) {
                            case VENDOR: {
                                fop.setType(PaymentType.INVOICE);
                                fop.setCard(null);
                                break;
                            }
                        }
                    }
                }
                GeneralProductHelper.getHandler((BaseProduct)product).updateContractRelations(product, relations);
            }
        }
    }
}

