/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.rest.TypeHandler;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.web.rest.JsonHelper;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.json.JSONException;
import org.json.JSONObject;

public class CommonTypeHandler
implements TypeHandler {
    private final DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS");

    public boolean isAwareOf(Class<?> type) {
        return Enum.class.isAssignableFrom(type) || DictionaryReference.class.isAssignableFrom(type) || EntityReference.class.isAssignableFrom(type) || LocalDate.class.isAssignableFrom(type) || LocalDateTime.class.isAssignableFrom(type) || LocalTime.class.isAssignableFrom(type);
    }

    public Object unmarshal(Object object, Class<?> type, Class<?> originalType) throws Exception {
        if (Objects.isNull(object) || object.equals(JSONObject.NULL)) {
            return null;
        }
        if (Enum.class.isAssignableFrom(type) || DictionaryReference.class.isAssignableFrom(type) || EntityReference.class.isAssignableFrom(type)) {
            String uid = null;
            if (object instanceof JSONObject) {
                if (object != null) {
                    uid = ((JSONObject)object).getString("uid");
                }
            } else {
                uid = (String)object;
            }
            if (Enum.class.isAssignableFrom(type)) {
                if (!TextUtil.isBlank((String)uid)) {
                    try {
                        return Enum.valueOf(type, uid);
                    }
                    catch (IllegalArgumentException e) {
                        throw Xeption.forDeveloper((String)String.format("Invalid value of type %s", type.getSimpleName()), (Object[])new Object[0]);
                    }
                }
                return null;
            }
            if (DictionaryReference.class.isAssignableFrom(type)) {
                Class<?> dictionaryType = originalType;
                BaseDictionary dict = DictionaryCache.get().findByCode(dictionaryType, uid);
                return Objects.nonNull(dict) ? dict.toReference() : null;
            }
            if (EntityReference.class.isAssignableFrom(type)) {
                return new EntityReference(uid, originalType, null);
            }
        }
        if (LocalDate.class.isAssignableFrom(type)) {
            try {
                return LocalDate.parse((String)object);
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)String.format("Unable to parse LocalDate [%s]", (String)object), (Object[])new Object[0]);
            }
        }
        if (LocalDateTime.class.isAssignableFrom(type)) {
            try {
                return LocalDateTime.parse((String)object);
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)String.format("Unable to parse LocalDateTime [%s]", (String)object), (Object[])new Object[0]);
            }
        }
        if (LocalTime.class.isAssignableFrom(type)) {
            try {
                return LocalTime.parse((String)object);
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)String.format("Unable to parse LocalTime [%s]", (String)object), (Object[])new Object[0]);
            }
        }
        throw Xeption.forDeveloper((String)String.format("Invalid type [%s]", type.getSimpleName()), (Object[])new Object[0]);
    }

    public Object marshal(Object result, Object value, Map<String, Object> data, boolean isValid, List<Object> parents) throws JSONException {
        if (!isValid || Objects.isNull(value)) {
            return null;
        }
        try {
            parents.add(value);
            if (Enum.class.isInstance(value)) {
                String string = ((Enum)value).name();
                return string;
            }
            if (DictionaryReference.class.isInstance(value)) {
                JSONObject json = new JSONObject();
                DictionaryReference dictRef = (DictionaryReference)value;
                json.put("uid", (Object)dictRef.getCode());
                json.put("caption", (Object)(TextUtil.isBlank((String)dictRef.getCode()) ? "" : dictRef.toString()));
                JSONObject jSONObject = json;
                return jSONObject;
            }
            if (EntityReference.class.isInstance(value)) {
                JSONObject json = new JSONObject();
                json.put("uid", (Object)((EntityReference)value).getUid());
                String caption = ((EntityReference)value).getCaption();
                json.put("caption", (Object)(caption == null ? "" : caption));
                JSONObject jSONObject = json;
                return jSONObject;
            }
            if (LocalDate.class.isInstance(value)) {
                String string = ((LocalDate)value).toString();
                return string;
            }
            if (LocalDateTime.class.isInstance(value)) {
                String string = this.dtf.format((LocalDateTime)value);
                return string;
            }
            if (LocalTime.class.isInstance(value)) {
                String string = ((LocalTime)value).toString();
                return string;
            }
            throw Xeption.forDeveloper((String)String.format("Invalid value [%s]", String.valueOf(value)), (Object[])new Object[0]);
        }
        finally {
            parents.remove(value);
        }
    }

    public void validate(Object o, Class<?> cls) {
        JSONObject json = (JSONObject)o;
        if (Enum.class.isAssignableFrom(cls)) {
            JsonHelper.validateJson((JSONObject)json, cls, (String[])new String[]{(String)o});
        }
        if (DictionaryReference.class.isAssignableFrom(cls)) {
            JsonHelper.validateJson((JSONObject)json, cls, (String[])new String[]{(String)o});
        }
        if (EntityReference.class.isAssignableFrom(cls)) {
            JsonHelper.validateJson((JSONObject)json, cls, (String[])new String[]{(String)o});
        }
        throw Xeption.forDeveloper((String)"Invalid value [%s]", (Object[])new Object[]{String.valueOf(cls)});
    }
}

