/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleString;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableNameUtil;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Introspectable;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.CompanyGroup;
import com.gridnine.xtrip.common.model.profile.Holding;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.rest.reports.EnumWrapper;
import com.gridnine.xtrip.server.model.rest.reports.ExtendedLuggageInfoRest;
import com.gridnine.xtrip.server.model.rest.reports.FareDetailsRest;
import com.gridnine.xtrip.server.model.rest.reports.LuggageInfoRest;
import com.gridnine.xtrip.server.model.rest.reports.MoneyRest;
import com.gridnine.xtrip.server.model.rest.reports.PricingParametersRest;
import com.gridnine.xtrip.server.model.rest.reports.ReportPassengerData;
import com.gridnine.xtrip.server.model.rest.reports.ReportProduct;
import com.gridnine.xtrip.server.model.rest.reports.ReportProductAccountManager;
import com.gridnine.xtrip.server.model.rest.reports.ReportProductBillingItemData;
import com.gridnine.xtrip.server.model.rest.reports.ReportProductSegmentData;
import com.gridnine.xtrip.server.model.rest.reports.RestDictionaryReference;
import com.gridnine.xtrip.server.model.rest.reports.RestEntityReference;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RestReportsHelper {
    public static final String undefinedRouteLine = "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e";

    public static double convertReference(BigDecimal value) {
        return value != null ? value.doubleValue() : 0.0;
    }

    public static ProductHandler<BaseProduct> getHandler(BaseProduct product) {
        return HandlersRegistry.get().findProductHandler(product.getClass());
    }

    public static Optional<String> getStr(LocaleString value, Locale locale) {
        return Optional.ofNullable(value.toString(locale));
    }

    public static <R, T extends Introspectable> Optional<R> getValue(T product, String property) {
        try {
            Object value = product.getValue(property);
            return Optional.ofNullable(value);
        }
        catch (Throwable t) {
            return Optional.empty();
        }
    }

    public static <T extends Introspectable> boolean setValue(T item, String property, Object value) {
        boolean res = true;
        try {
            item.setValue(property, value);
        }
        catch (Throwable t) {
            res = false;
        }
        return res;
    }

    public static String getTravellerName(Traveller traveller, EntityReference<Person> passenger, boolean isEnglish) {
        String fullName;
        EntityContainer travellerCtr = EntityStorage.get().resolve(passenger);
        if (travellerCtr != null && (fullName = RestReportsHelper.getFullName((Person)travellerCtr.getEntity(), isEnglish ? LocaleHelper.EN_LOCALE : LocaleHelper.RU_LOCALE, !isEnglish)) != null) {
            return fullName;
        }
        return traveller.getName() != null ? (isEnglish ^ TextUtil.isCyrillic((String)traveller.getName(), (boolean)true) ? traveller.getName() : (traveller.getCyrillicName() != null ? (isEnglish ^ TextUtil.isCyrillic((String)traveller.getCyrillicName(), (boolean)true) ? traveller.getCyrillicName() : null) : null)) : null;
    }

    public static String getTravellerName(boolean isDemon, Traveller traveller, EntityReference<Person> passenger) {
        EntityContainer travellerCtr = EntityStorage.get().resolve(passenger);
        if (travellerCtr == null) {
            return traveller.getName();
        }
        String fullName = RestReportsHelper.getFullName((Person)travellerCtr.getEntity(), isDemon ? LocaleHelper.EN_LOCALE : LocaleHelper.RU_LOCALE, true);
        if (fullName == null) {
            fullName = RestReportsHelper.getFullName((Person)travellerCtr.getEntity(), LocaleHelper.EN_LOCALE, false);
        }
        if (fullName == null) {
            return traveller.getName();
        }
        return fullName;
    }

    public static String getPersonName(EntityReference<Person> passenger, boolean isDemon) {
        if (passenger != null) {
            EntityContainer travellerCtr = EntityStorage.get().resolve(passenger);
            if (travellerCtr == null) {
                return passenger.getCaption();
            }
            String fullName = RestReportsHelper.getFullName((Person)travellerCtr.getEntity(), isDemon ? LocaleHelper.EN_LOCALE : LocaleHelper.RU_LOCALE, true);
            if (fullName == null) {
                fullName = RestReportsHelper.getFullName((Person)travellerCtr.getEntity(), LocaleHelper.EN_LOCALE, false);
            }
            if (fullName == null) {
                return passenger.getCaption();
            }
            return fullName;
        }
        return "";
    }

    private static String getFullName(Person person, Locale locale, boolean strict) {
        if (person == null) {
            return null;
        }
        String lastName = L10nStringHelper.getValue((L10nString)person.getLastName(), (Locale)locale, (boolean)strict);
        String firstName = L10nStringHelper.getValue((L10nString)person.getFirstName(), (Locale)locale, (boolean)strict);
        String middleName = L10nStringHelper.getValue((L10nString)person.getMiddleName(), (Locale)locale, (boolean)strict);
        if (TextUtil.isBlank((String)lastName) && TextUtil.isBlank((String)firstName) && TextUtil.isBlank((String)middleName)) {
            return null;
        }
        return PersonalLocalizableNameUtil.buildFullName((PersonalLocalizableName)person, (boolean)false, (Locale)locale, (boolean)strict);
    }

    public static <T extends BaseProduct> EntityReference<Person> getBookingAgent(T product) {
        Reservation reservation = product.getReservation();
        if (reservation != null) {
            return reservation.getBookingAgent();
        }
        return null;
    }

    public static <T extends BaseProduct> String getRecordLocator(T product) {
        Reservation reservation = product.getReservation();
        if (reservation != null) {
            return MiscUtil.guarded((String)CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation));
        }
        return "";
    }

    public static void fillPossibleEconomy(ReportProduct record, BigDecimal productPrice) {
        if (record.getMinimumPrice().compareTo(BigDecimal.ZERO) == 0 || productPrice == null) {
            return;
        }
        BigDecimal delta = productPrice.subtract(record.getMinimumPrice());
        if (delta.compareTo(BigDecimal.ZERO) > 0) {
            record.setPossibleEconomy(delta);
        }
    }

    public static String getRouteLine(DictionaryReference<GeoLocation> departureCity, DictionaryReference<GeoLocation> destinationCity, boolean isDemon) {
        String departureName = RestReportsHelper.getLocationName(departureCity, isDemon);
        String destinationName = RestReportsHelper.getLocationName(destinationCity, isDemon);
        if (departureName == null || destinationName == null) {
            return "";
        }
        return String.format("%s - %s", departureName, destinationName);
    }

    private static String getLocationName(DictionaryReference<GeoLocation> location, boolean isDemon) {
        if (location == null) {
            return null;
        }
        GeoLocation loc = (GeoLocation)DictHelper.resolve(location);
        if (loc == null) {
            return isDemon ? location.toString(LocaleHelper.EN_LOCALE) : location.getCaption();
        }
        return isDemon ? loc.toString(LocaleHelper.EN_LOCALE) : loc.toString();
    }

    public static boolean booleanFromBoolean(Boolean value) {
        return value != null ? value : false;
    }

    public static int intFromInteger(Integer integer) {
        return integer != null ? integer : 0;
    }

    public static String checkString(String str) {
        return str != null ? str : "";
    }

    public static BigDecimal chekBigDecimal(BigDecimal bigDecimal) {
        return bigDecimal != null ? bigDecimal : BigDecimal.ZERO;
    }

    public static MoneyRest getMoneyZero() {
        return new MoneyRest();
    }

    public static LuggageInfoRest getLuggageInfoZero() {
        return new LuggageInfoRest();
    }

    public static ExtendedLuggageInfoRest getExtendedLuggageInfoRestZero() {
        return new ExtendedLuggageInfoRest();
    }

    public static PricingParametersRest getPricingParametersRestZero() {
        return new PricingParametersRest();
    }

    public static FareDetailsRest getFareDetailsZero() {
        return new FareDetailsRest();
    }

    public static EnumWrapper getEnumWrapperZero() {
        return new EnumWrapper();
    }

    public static ReportProductSegmentData getReportProductSegmentDataZero() {
        return new ReportProductSegmentData();
    }

    public static ReportProductBillingItemData getReportProductBillingItemDataZero() {
        return new ReportProductBillingItemData();
    }

    public static ReportProductAccountManager getReportProductAccountManagerZero() {
        return new ReportProductAccountManager();
    }

    public static String getRoutForSegment(String departureLocation, String arriveLocation) {
        StringBuilder rout = new StringBuilder();
        if (!TextUtil.isBlank((String)departureLocation)) {
            rout.append(departureLocation).append(" - ");
        } else {
            rout.append("*** - ");
        }
        if (!TextUtil.isBlank((String)arriveLocation)) {
            rout.append(arriveLocation);
        } else {
            rout.append("***");
        }
        return rout.toString();
    }

    public static ReportPassengerData getPassengersZero() {
        return new ReportPassengerData();
    }

    public static <E extends BaseEntity> RestEntityReference convertReference(EntityReference<E> entityReference) {
        return RestReportsHelper.convertReference(entityReference, null);
    }

    public static <E extends BaseEntity> RestEntityReference convertReference(EntityReference<E> entityReference, Supplier<String> getter) {
        RestEntityReference reference = new RestEntityReference();
        if (entityReference == null) {
            return reference;
        }
        reference.setUid(TextUtil.nonNullStr((String)entityReference.getUid()));
        String caption = getter == null ? null : getter.get();
        reference.setCaption(TextUtil.nonBlank((String)caption) ? caption : TextUtil.nonNullStr((String)entityReference.getCaption()));
        return reference;
    }

    public static RestDictionaryReference convertReference(DictionaryReference<?> dictionaryReference, boolean isDemon) {
        RestDictionaryReference reference = new RestDictionaryReference();
        if (dictionaryReference == null) {
            return reference;
        }
        reference.setUid(TextUtil.nonNullStr((String)dictionaryReference.getCode()));
        reference.setCaption(TextUtil.nonNullStr((String)(isDemon ? dictionaryReference.toString(LocaleHelper.EN_LOCALE) : dictionaryReference.toString())));
        return reference;
    }

    public static Supplier<String> personNameGetter(EntityReference<Person> reference, EntityStorageContext sc) {
        return () -> {
            EntityContainer personCtr = EntityStorageHelper.resolve((EntityReference)reference, (EntityStorageContext)sc);
            if (personCtr == null) {
                return null;
            }
            return Stream.of(((Person)personCtr.getEntity()).getLastName().toString(LocaleHelper.EN_LOCALE), ((Person)personCtr.getEntity()).getFirstName().toString(LocaleHelper.EN_LOCALE), ((Person)personCtr.getEntity()).getMiddleName().toString(LocaleHelper.EN_LOCALE)).filter(TextUtil::nonBlank).collect(Collectors.joining(" "));
        };
    }

    public static Supplier<String> organizationNameGetter(EntityReference<Organization> reference, EntityStorageContext sc) {
        return () -> {
            EntityContainer container = EntityStorageHelper.resolve((EntityReference)reference, (EntityStorageContext)sc);
            if (container == null) {
                return null;
            }
            return ((Organization)container.getEntity()).getFullName().toString(LocaleHelper.EN_LOCALE);
        };
    }

    public static Supplier<String> holdingNameGetter(EntityReference<Holding> reference, EntityStorageContext sc) {
        return () -> {
            EntityContainer container = EntityStorageHelper.resolve((EntityReference)reference, (EntityStorageContext)sc);
            if (container == null) {
                return null;
            }
            return ((Holding)container.getEntity()).getFullName().toString(LocaleHelper.EN_LOCALE);
        };
    }

    public static Supplier<String> companyGroupNameGetter(EntityReference<CompanyGroup> reference, EntityStorageContext sc) {
        return () -> {
            EntityContainer container = EntityStorageHelper.resolve((EntityReference)reference, (EntityStorageContext)sc);
            if (container == null) {
                return null;
            }
            return ((CompanyGroup)container.getEntity()).getFullName().toString(LocaleHelper.EN_LOCALE);
        };
    }
}

