/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.AuthUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibecorp.rest.reports.IbusReportsRestContextKeys;
import com.gridnine.xtrip.server.ibecorp.rest.reports.auth.XReportsApiKeyProvider;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import com.gridnine.xtrip.server.web.rest.AuthRestInterceptor;
import com.gridnine.xtrip.server.web.rest.GenericRestInterceptorAdapter;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class XtripReportsAuthInterceptor
extends GenericRestInterceptorAdapter
implements AuthRestInterceptor {
    private static final String LOGIN = "login";
    private static final String PASSWORD = "password";
    private static final String AUTH_HEADER = "MOM_AUTH";
    private static final String REPORTS_LOGIN = "REPORTS_LOGIN";

    public void authorize(RestContext context, Map<String, Object> data) {
        String password;
        String login;
        if ("/xreports/auth/authorize".equals(context.getRequest().getPathInfo())) {
            return;
        }
        if ("/xreports/auth/check".equals(context.getRequest().getPathInfo())) {
            return;
        }
        if ("/xreports/auth/getDisplayName".equals(context.getRequest().getPathInfo())) {
            return;
        }
        String authHeader = context.getRequest().getHeader(AUTH_HEADER);
        String reportsLogin = context.getRequest().getHeader(REPORTS_LOGIN);
        if (TextUtil.nonBlank((String)reportsLogin)) {
            if (TextUtil.isBlank((String)authHeader)) {
                throw Xeption.forEndUser((String)"Api key to access reports application wasn't received", (Object[])new Object[0]);
            }
            String apiKey = ((XReportsApiKeyProvider)Environment.getPublished(XReportsApiKeyProvider.class)).getApiKey();
            if (apiKey == null) {
                throw Xeption.forEndUser((String)"Api key to access reports application wasn't found", (Object[])new Object[0]);
            }
            if (!authHeader.equals(apiKey)) {
                throw Xeption.forEndUser((String)"Api key to access reports application doesn't match", (Object[])new Object[0]);
            }
            data.put(IbusReportsRestContextKeys.LOGIN.name(), reportsLogin);
            return;
        }
        if (!StringUtils.isBlank((String)authHeader)) {
            String[] tokens = AuthUtil.decryptToken((Serializable)((Object)authHeader));
            login = tokens[0];
            password = tokens[1];
        } else {
            login = context.getRequest().getHeader(LOGIN);
            password = context.getRequest().getHeader(PASSWORD);
        }
        if (StringUtils.isBlank((String)login)) {
            throw Xeption.forEndUser((String)"Login shouldn't be empty!", (Object[])new Object[0]);
        }
        if (StringUtils.isBlank((String)password)) {
            throw Xeption.forEndUser((String)"Password shouldn't be empty!", (Object[])new Object[0]);
        }
        try {
            LogicalStorage.get().authorize(login, password.toCharArray());
        }
        catch (Exception e) {
            context.setStatus(403);
            throw Xeption.forEndUser((String)"Invalid login or password", (Throwable)e, (Object[])new Object[0]);
        }
        data.put(IbusReportsRestContextKeys.LOGIN.name(), login);
    }
}

