/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports.deleteBookingFilesUids;

import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.TrashBinItemIndex;
import com.gridnine.xtrip.common.model.profile.TrashBinItemType;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.rest.reports.DeleteBookingFilesUidsParameters;
import com.gridnine.xtrip.server.model.rest.reports.DeleteBookingFilesUidsResult;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteBookingFilesUidsProcessor
extends BaseProcessor {
    private static final String MODIFIED = "modified";
    private static final String CONTAINER_UID = "containerUid";
    private final Logger log = LoggerFactory.getLogger((String)"reports-etl");

    public void process(MessageContext ctx) throws Exception {
        DeleteBookingFilesUidsResult result;
        DeleteBookingFilesUidsParameters params = (DeleteBookingFilesUidsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        List<String> messages = this.validateParameters(params);
        if (this.log.isDebugEnabled()) {
            this.log.debug("searching booking files uids, from date is " + params.getFromDate().toString() + " limit = " + params.getLimit());
        }
        messages.forEach(s -> this.logError(ctx, (String)s, null, new Object[0]));
        if (messages.isEmpty()) {
            result = this.searchBookingFilesUids(params);
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("got %s result, timestamp is %s", result.getBookingFilesUids().size(), result.getTimeStamp()));
                this.log.debug("uids:\n" + TextUtil.join((String)"\n", (Iterable)result.getBookingFilesUids()));
            }
        } else {
            result = new DeleteBookingFilesUidsResult();
            result.getErrorMessages().addAll(messages);
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("got error message %s", messages.get(0)));
            }
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private DeleteBookingFilesUidsResult searchBookingFilesUids(DeleteBookingFilesUidsParameters params) {
        LocalDateTime timestamp = this.toLocalDateTime(new Date());
        SearchQuery query = new SearchQuery();
        query.getCriteria().getOrders().put(MODIFIED, SortOrder.ASC);
        if (params.getFromDate() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)MODIFIED, (Object)this.toOldDate(params.getFromDate())));
        }
        query.setLimit(params.getLimit());
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TrashBinItemIndex.Property.type.name(), (Object)TrashBinItemType.BOOKING_FILE));
        query.setResultMode(ResultMode.DATA_ONLY);
        List indices = EntityStorage.get().search(TrashBinItemIndex.class, query).getData();
        if (!indices.isEmpty()) {
            timestamp = this.toLocalDateTime(((TrashBinItemIndex)indices.get(indices.size() - 1)).getModified());
        }
        List uids = indices.stream().map(TrashBinItemIndex::getDeletedUid).filter(Objects::nonNull).collect(Collectors.toList());
        DeleteBookingFilesUidsResult result = new DeleteBookingFilesUidsResult();
        result.getBookingFilesUids().addAll(uids);
        result.setTimeStamp(timestamp);
        return result;
    }

    private LocalDateTime toLocalDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    private Date toOldDate(LocalDateTime fromDate) {
        return Date.from(fromDate.atZone(ZoneId.systemDefault()).toInstant());
    }

    private List<String> validateParameters(DeleteBookingFilesUidsParameters params) {
        ArrayList<String> result = new ArrayList<String>();
        LocalDateTime fromDate = params.getFromDate();
        if (fromDate == null) {
            result.add("from date is undefined");
        }
        if (params.getLimit() <= 0) {
            result.add(String.format("Limit should be a positive value [%d]", params.getLimit()));
        }
        return result;
    }
}

