/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports.deleteMarkerObjects;

import com.gridnine.xtrip.common.ibecorp.storage.XreportsBookingMarkerObject;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.rest.reports.DeleteMarkerObjectsParameters;
import com.gridnine.xtrip.server.model.rest.reports.DeleteMarkerObjectsResult;
import java.util.HashSet;

public class DeleteMarkerObjectsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        DeleteMarkerObjectsParameters params = (DeleteMarkerObjectsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        DeleteMarkerObjectsResult result = new DeleteMarkerObjectsResult();
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
        HashSet<String> deleted = new HashSet<String>();
        for (String uid : params.getMarkerObjectsUids()) {
            try {
                XreportsBookingMarkerObject obj = (XreportsBookingMarkerObject)AssetsStorage.get().load(XreportsBookingMarkerObject.class, uid);
                if (obj != null) {
                    AssetsStorage.get().delete((BaseAsset)obj);
                }
                if (!this.log.isDebugEnabled()) continue;
                deleted.add(obj.getUid());
            }
            catch (Exception e) {
                this.log.error("unable to delete marker object " + uid, (Throwable)e);
                result.getErrorMessages().add("unable to delete marker object " + uid);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("deleted marker objects:\n" + TextUtil.join((String)"\n", deleted));
        }
    }
}

