/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports.getBookingFile;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class CorrectingProductsVirtualizationAdvice
extends BaseAdvice {
    private static final String VIRTUAL_PRODUCTS_UIDS = "VIRTUAL_PRODUCTS_UIDS";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void before(MessageContext ctx) throws Exception {
        HashSet<String> virtualProductUids = new HashSet<String>();
        ctx.putObject(VIRTUAL_PRODUCTS_UIDS, virtualProductUids);
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER);
        for (Reservation res : ((BookingFile)bookingCtr.getEntity()).getReservations()) {
            for (BaseProduct prod : new ArrayList(res.getProducts())) {
                ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)prod);
                TicketType ticketType = handler.getTicketType(prod);
                ProductStatus status = handler.getStatus(prod);
                if (ticketType != TicketType.CORRECTION || status != ProductStatus.SELL && status != ProductStatus.REFUND) continue;
                prod.setReservation(null);
                try {
                    BaseProduct virtualProduct = (BaseProduct)prod.getClass().newInstance();
                    String uid = prod.getUid();
                    uid = uid.charAt(0) != '1' ? "1" + uid.substring(1) : "2" + uid.substring(1);
                    virtualProduct.copyFrom((BaseEntity)prod, false, new HashMap());
                    virtualProduct.setUid(uid);
                    virtualProductUids.add(uid);
                    if (prod.getCorrectionDate() != null) {
                        handler.setIssueDate(virtualProduct, prod.getCorrectionDate());
                    }
                    if (status == ProductStatus.SELL) {
                        handler.setStatus(virtualProduct, ProductStatus.REFUND);
                        handler.setPreviousProduct(virtualProduct, prod);
                    } else {
                        handler.setStatus(virtualProduct, ProductStatus.SELL);
                    }
                    handler.getValidationMessages(virtualProduct).forEach(it -> {
                        String vmUid = it.getUid();
                        vmUid = vmUid.charAt(0) != '1' ? "1" + vmUid.substring(1) : "2" + vmUid.substring(1);
                        it.setUid(vmUid);
                    });
                    virtualProduct.setReservation(res);
                    res.getProducts().add(virtualProduct);
                }
                finally {
                    prod.setReservation(res);
                }
            }
        }
    }

    public void after(MessageContext ctx) throws Exception {
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER);
        Set virtualProductUids = (Set)ctx.getMandatoryObject(VIRTUAL_PRODUCTS_UIDS);
        for (Reservation res : ((BookingFile)bookingCtr.getEntity()).getReservations()) {
            res.getProducts().removeIf(baseProduct -> virtualProductUids.contains(baseProduct.getUid()));
        }
    }
}

