/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports.getBookingFile;

import com.gridnine.xtrip.common.ibecorp.storage.XreportsBookingMarkerObject;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.ibecorp.XreportFailDocument;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.helpers.XreportsIntegrationHelper;
import com.gridnine.xtrip.server.ibecorp.l10n.Messages;
import com.gridnine.xtrip.server.ibecorp.rest.reports.getBookingFile.XreportsBookingNotFoundException;
import com.gridnine.xtrip.server.ibus.IBusMailContextKeys;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.rest.reports.GetBookingFileParameters;
import com.gridnine.xtrip.server.model.rest.reports.GetBookingFileResult;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportGetBookingFileAdvice
extends BaseAdvice {
    private final Logger log = LoggerFactory.getLogger((String)"reports-etl");

    public void before(MessageContext ctx) throws Exception {
        LocaleManager.get().setCurrentLocale(LocaleHelper.RU_LOCALE);
        GetBookingFileParameters params = (GetBookingFileParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        if (this.log.isDebugEnabled()) {
            this.log.debug("get booking file : marker object uid =" + params.getMarkerObjectUid());
        }
    }

    public boolean handleException(Throwable e, MessageContext ctx) throws Exception {
        GetBookingFileResult result = (GetBookingFileResult)ctx.getObject((Enum)IBusRestContextKeys.REST_RESULT);
        GetBookingFileParameters params = (GetBookingFileParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        boolean delete = XreportsIntegrationHelper.deleteMarkerObjects();
        boolean hasOwner = true;
        if (result == null) {
            result = new GetBookingFileResult();
            ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
        }
        String message = null;
        if (e instanceof XreportsBookingNotFoundException) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("booking not found for marker object " + params.getMarkerObjectUid());
            }
            hasOwner = false;
        } else if (e instanceof Xeption) {
            message = ((Xeption)e).getAdminMessage().toString();
            result.getErrorMessages().add(message);
        } else {
            message = String.format("%s:\n%s", e.toString(), ExceptionUtil.getExceptionStackTrace((Throwable)e));
            result.getErrorMessages().add(message);
        }
        if (this.log.isDebugEnabled() && message != null) {
            this.log.debug("get booking file error " + message);
        }
        if (!delete || params.getMarkerObjectUid() == null) {
            return true;
        }
        XreportsBookingMarkerObject markerObject = this.deleteMarkerObject(params.getMarkerObjectUid());
        if (!hasOwner) {
            return true;
        }
        EntityContainer bfCtr = (EntityContainer)ctx.getObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER);
        if (bfCtr == null) {
            if (markerObject == null) {
                return true;
            }
            bfCtr = EntityStorage.get().load(BookingFile.class, markerObject.getBookingUid());
            if (bfCtr == null || bfCtr.getEntity() == null) {
                return true;
            }
        }
        this.createDocument((EntityReference<BookingFile>)bfCtr.toReference(), ((BookingFile)bfCtr.getEntity()).getNumber(), message);
        this.sendEmails(message, ((BookingFile)bfCtr.getEntity()).getNumber());
        return true;
    }

    private XreportsBookingMarkerObject deleteMarkerObject(String uid) {
        try {
            XreportsBookingMarkerObject obj = (XreportsBookingMarkerObject)AssetsStorage.get().load(XreportsBookingMarkerObject.class, uid);
            if (obj != null) {
                AssetsStorage.get().delete((BaseAsset)obj);
                return obj;
            }
        }
        catch (Exception e) {
            this.log.error("unable to delete marker object " + uid, (Throwable)e);
        }
        return null;
    }

    private void createDocument(EntityReference<BookingFile> bfRef, String number, String message) throws NoSuchAlgorithmException {
        List<BasicDocumentIndex> indices = this.getDocuments(bfRef);
        if (!indices.isEmpty()) {
            return;
        }
        EntityContainer docCtr = new EntityContainer(XreportFailDocument.class);
        XreportFailDocument document = (XreportFailDocument)docCtr.getEntity();
        document.setCreated(new Date());
        document.setNavigationKey(bfRef.getUid());
        document.setOwner(bfRef);
        document.setContentType(ContentType.TEXT);
        if (message != null) {
            byte[] content = message.getBytes(StandardCharsets.UTF_8);
            document.setContent(content);
            document.setCheckSum(MiscUtil.getCheckSum((byte[])content));
        }
        String title = "reports-transmission-error-info-" + number;
        document.setTitle(title);
        document.setName(title + ".txt");
        EntityStorage.get().save(docCtr, true);
    }

    private List<BasicDocumentIndex> getDocuments(EntityReference<BookingFile> bfRef) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), bfRef));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.fixed.name(), (Object)false));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"entityType", (Object)XreportFailDocument.class.getName()));
        return EntityStorage.get().search(BasicDocumentIndex.class, query).getData();
    }

    private void sendEmails(String message, String number) {
        List<String> emails = XreportsIntegrationHelper.getEmails();
        if (emails.isEmpty()) {
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(IBusMailContextKeys.MAIL_TO.name(), emails);
        data.put(IBusMailContextKeys.MAIL_SUBJ.name(), L10nResourcesManager.createL10nMessage((String)Messages.XREPORTS_TRANSMISSION_ERROR, (Object[])new Object[]{number}).toString());
        data.put(IBusMailContextKeys.MAIL_BODY.name(), message);
        IntegrationBusFacade.get().sendRouteAsync("standard-model:send-email", data);
    }

    public void after(MessageContext ctx) throws Exception {
        EntityContainer bfCtr;
        GetBookingFileResult result = (GetBookingFileResult)ctx.getObject((Enum)IBusRestContextKeys.REST_RESULT);
        if (result == null || result.getBookingFile() == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("got tickets: " + result.getBookingFile().getProducts().stream().map(ticket -> String.format("%s:%s", ticket.getProductUid(), ticket.getShipmentNumber())).collect(Collectors.toList()));
        }
        if ((bfCtr = (EntityContainer)ctx.getObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER)) == null || !result.getErrorMessages().isEmpty()) {
            return;
        }
        List<BasicDocumentIndex> documents = this.getDocuments((EntityReference<BookingFile>)bfCtr.toReference());
        documents.forEach(d -> {
            EntityContainer docCtr = EntityStorage.get().resolve(d.getSource());
            if (docCtr == null || docCtr.getEntity() == null || !(docCtr.getEntity() instanceof XreportFailDocument)) {
                return;
            }
            XreportFailDocument document = (XreportFailDocument)docCtr.getEntity();
            document.setFixed(true);
            EntityContainer xDocCtr = EntityStorageHelper.createContainer((BaseEntity)document, (EntityStorageContext)new EntityStorageContext());
            xDocCtr.setUid(docCtr.getUid());
            xDocCtr.getVersionInfo().setDataSource("fixed");
            EntityStorage.get().save(xDocCtr, true);
        });
    }
}

