/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports.getBookingFile;

import com.gridnine.xtrip.common.ibecorp.storage.XreportsBookingMarkerObject;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBooking;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBookingHelper;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.server.ibecorp.rest.reports.getBookingFile.XreportsBookingNotFoundException;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.rest.reports.GetBookingFileParameters;
import org.slf4j.LoggerFactory;

public class SearchBookingFileProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GetBookingFileParameters params = (GetBookingFileParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        if (params.getMarkerObjectUid() == null) {
            if (params.getBookingFileUid() != null) {
                EntityContainer result = EntityStorage.get().load(BookingFile.class, params.getBookingFileUid());
                if (result == null) {
                    throw new XreportsBookingNotFoundException();
                }
                ctx.putObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER, (Object)result);
                return;
            }
            throw Xeption.forEndUser((String)"Values for markerObjectUid and bookingFileUid parameter are not specified", (Object[])new Object[0]);
        }
        ctx.putObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER, SearchBookingFileProcessor.searchBookingFile(params.getMarkerObjectUid()));
    }

    private static EntityContainer<BookingFile> searchBookingFile(String uid) throws XreportsBookingNotFoundException {
        EntityContainer archivedBfCnt;
        XreportsBookingMarkerObject markerObject = (XreportsBookingMarkerObject)AssetsStorage.get().load(XreportsBookingMarkerObject.class, uid);
        if (markerObject == null) {
            throw new XreportsBookingNotFoundException();
        }
        LoggerFactory.getLogger(SearchBookingFileProcessor.class).debug(String.format("analyzing marker object %s for booking %s", markerObject.getUid(), markerObject.getBookingUid()));
        EntityContainer result = EntityStorage.get().load(BookingFile.class, markerObject.getBookingUid());
        if ((result == null || result.getEntity() == null) && (archivedBfCnt = EntityStorage.get().load(ArchivedBooking.class, uid)) != null) {
            result = ArchivedBookingHelper.getBookingContainer((ArchivedBooking)((ArchivedBooking)archivedBfCnt.getEntity()));
        }
        if (result == null) {
            throw new XreportsBookingNotFoundException();
        }
        return result;
    }
}

