/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports.getBookingFile.products;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.dict.CountryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.rest.reports.IbusReportsRestContextKeys;
import com.gridnine.xtrip.server.ibecorp.rest.reports.RestReportsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.rest.reports.ReportProduct;
import com.gridnine.xtrip.server.model.rest.reports.RestProductType;
import java.util.Optional;

public class ReportProductAeroexpressFieldsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Boolean isDemon = (Boolean)ctx.getObject((Enum)IbusReportsRestContextKeys.DEMON_KEY);
        ReportProduct record = (ReportProduct)ctx.getMandatoryObject((Enum)IbusReportsRestContextKeys.RECORD);
        AeroexpressTicket product = (AeroexpressTicket)ctx.getMandatoryObject((Enum)IBusRestContextKeys.PRODUCT);
        record.setComments(TextUtil.nonNullStr((String)product.getComments()));
        record.setProductType(RestProductType.AEROEXPRESS);
        record.setDepartureCity(RestReportsHelper.convertReference(new GeoLocationReference("MOW"), isDemon));
        record.setDepartureCountry(RestReportsHelper.convertReference(new CountryReference("RU"), isDemon));
        record.setDestinationCity(RestReportsHelper.convertReference(new GeoLocationReference("MOW"), isDemon));
        record.setDestinationCountry(RestReportsHelper.convertReference(new CountryReference("RU"), isDemon));
        if (product.getSalesPoint() != null) {
            record.setSalesPoint(RestReportsHelper.convertReference(Optional.ofNullable(EntityStorage.get().resolve(product.getSalesPoint())).map(EntityContainer::toReference).orElse(product.getSalesPoint())));
        }
    }
}

