/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports.getBookingFile.products;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.midoffice.model.WeightUnit;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ContractRelationVatDetalization;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SimpleTax;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LegalForm;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.rest.reports.IbusReportsRestContextKeys;
import com.gridnine.xtrip.server.ibecorp.rest.reports.RestReportsHelper;
import com.gridnine.xtrip.server.ibecorp.rest.reports.getBookingFile.products.ReportProductCommonFieldsProcessor;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.rest.reports.EffectivePenaltyCategory;
import com.gridnine.xtrip.server.model.rest.reports.EnumWrapper;
import com.gridnine.xtrip.server.model.rest.reports.ReportProduct;
import com.gridnine.xtrip.server.model.rest.reports.RestProductType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ReportProductAirFieldsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Product exchange;
        StatisticalData statisticalData;
        List segments;
        List cs;
        Airline validatingAirline;
        Boolean isDemon = (Boolean)ctx.getObject((Enum)IbusReportsRestContextKeys.DEMON_KEY);
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        ReportProduct record = (ReportProduct)ctx.getMandatoryObject((Enum)IbusReportsRestContextKeys.RECORD);
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusRestContextKeys.PRODUCT);
        record.setComments(TextUtil.nonNullStr((String)product.getComments()));
        record.setTourCodeExists(this.isTourCodeExists(product));
        if (product.getTourCode() != null && product.getTourCode().length() < 255) {
            record.setTourCode(product.getTourCode());
        }
        record.setFullRouteLineIATA(TextUtil.nonNullStr((String)AirProductHelper.getRouteLine((Product)product, (Locale)(isDemon != false ? LocaleHelper.EN_LOCALE : LocaleHelper.RU_LOCALE), (boolean)true, (CodeSystem)CodeSystem.IATA)));
        record.setRouteDescription(TextUtil.nonNullStr((String)AirProductHelper.getRouteDescription((Product)product, (Locale)(isDemon != false ? LocaleHelper.EN_LOCALE : LocaleHelper.RU_LOCALE), (boolean)true, (CodeSystem)CodeSystem.IATA)));
        if (product.getCarrier() != null) {
            record.setAirline(RestReportsHelper.convertReference(product.getCarrier(), isDemon));
        }
        if ((validatingAirline = (Airline)DictHelper.resolve((DictionaryReference)product.getCarrier())) != null) {
            String code = DictHelper.getCodeVariant((BaseDictionary)validatingAirline, (CodeSystem)CodeSystem.IATA);
            if (code == null) {
                code = DictHelper.getCodeVariant((BaseDictionary)validatingAirline, (CodeSystem)CodeSystem.CRT);
            }
            if (code != null) {
                record.setValidatingCarrierCode(code);
            }
            if (validatingAirline.getAirlineNumber() != null) {
                record.setValidatingCarrierNumber(validatingAirline.getAirlineNumber());
            }
            if (!TextUtil.isBlank((String)validatingAirline.getRegistrationId())) {
                record.setInnCarrier(validatingAirline.getRegistrationId());
            } else {
                record.setInnCarrier("");
            }
            if (!TextUtil.isBlank((String)validatingAirline.getKpp())) {
                record.setKppCarrier(validatingAirline.getKpp());
            } else {
                record.setKppCarrier("");
            }
        }
        record.setNameCarrier("");
        if (product.getCarrier() != null && product.getCarrier().getCaption() != null) {
            Airline airline = (Airline)DictHelper.resolve((DictionaryReference)product.getCarrier());
            if (airline != null) {
                Locale locale = airline.getTranslations().keySet().stream().filter(l -> TextUtil.equals((String)l.getLanguage(), (String)(isDemon != false ? LocaleHelper.EN_LOCALE.getLanguage() : LocaleHelper.RU_LOCALE.getLanguage()), (boolean)false)).findFirst().orElse(null);
                if (airline.getTranslations().get(locale) != null) {
                    LegalForm legalForm = airline.getLegalForm() != null ? (LegalForm)DictHelper.resolve((DictionaryReference)airline.getLegalForm()) : null;
                    Locale lfLocale = legalForm != null ? (Locale)legalForm.getAbbreviations().keySet().stream().filter(l -> TextUtil.equals((String)l.getLanguage(), (String)(isDemon != false ? LocaleHelper.EN_LOCALE.getLanguage() : LocaleHelper.RU_LOCALE.getLanguage()), (boolean)false)).findFirst().orElse(null) : null;
                    record.setNameCarrier(legalForm != null && lfLocale != null && TextUtil.nonBlank((String)((String)legalForm.getAbbreviations().get(lfLocale))) ? (String)legalForm.getAbbreviations().get(lfLocale) + " " + (String)airline.getTranslations().get(locale) : (String)airline.getTranslations().get(locale));
                }
            } else {
                record.setNameCarrier(isDemon != false ? product.getCarrier().toString(LocaleHelper.EN_LOCALE) : product.getCarrier().getCaption());
            }
        }
        if (product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
            record.setInExchangeTo(product.getPreviousProduct().getSystemNumber());
            record.setOperation(ProductStatus.EXCHANGE.name());
        }
        record.setProductType(RestProductType.AIR);
        Money baseFare = AirProductHelper.getBaseFare((Product)product);
        if (baseFare != null) {
            record.setBaseFare(baseFare.getValue());
        }
        EnumWrapper mcoCategoryWrapper = new EnumWrapper();
        mcoCategoryWrapper.setName(product.getMcoCategory() != null ? product.getMcoCategory().name() : "");
        mcoCategoryWrapper.setCaption(product.getMcoCategory() != null ? product.getMcoCategory().toString(isDemon != false ? LocaleHelper.EN_LOCALE : LocaleHelper.RU_LOCALE) : "");
        record.setMcoCategory(mcoCategoryWrapper);
        if (ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            record.setBaseFare(BigDecimal.ZERO);
        } else if (product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE) {
            record.setBaseFare(record.getBaseFare().negate());
        }
        if (product.getMcoCategory() != null) {
            for (BaseProduct relatedProduct : product.getRelatedProducts()) {
                ProductHandler relatedProductHandler = HandlersRegistry.get().findProductHandler(relatedProduct.getClass());
                ProductStatus relatedProductStatus = relatedProductHandler.getStatus(relatedProduct);
                if (relatedProductStatus == ProductStatus.REFUND) {
                    record.setOperation(ProductStatus.REFUND.name());
                    break;
                }
                if (relatedProductStatus == ProductStatus.EXCHANGE) {
                    record.setOperation(ProductStatus.EXCHANGE.name());
                    break;
                }
                if (relatedProductStatus != ProductStatus.SELL || relatedProductHandler.getPreviousProduct(relatedProduct) == null || relatedProductHandler.getStatus(relatedProductHandler.getPreviousProduct(relatedProduct)) != ProductStatus.EXCHANGE) continue;
                record.setOperation(ProductStatus.EXCHANGE.name());
                break;
            }
        }
        if (product.getMcoCategory() == MCOCategory.PENALTY || product.getMcoCategory() == MCOCategory.REBOOKING) {
            record.setEffectivePenaltyCategory(product.getMcoCategory() == MCOCategory.PENALTY ? EffectivePenaltyCategory.REFUND.name() : EffectivePenaltyCategory.EXCHANGE.name());
            record.setEffectivePenalty(MiscUtil.guarded((BigDecimal)AirProductHelper.getEquivalentFare((Product)product)));
        }
        if ((cs = (segments = AirProductHelper.getSegments((Collection)product.getSegmentTariffs())).stream().map(Segment::getServiceClass).filter(Objects::nonNull).distinct().collect(Collectors.toList())).size() > 0) {
            if (cs.size() > 2) {
                record.setClassOfService(ClassOfService.MIXED.name());
            } else if (cs.size() > 1) {
                if (cs.contains(ClassOfService.ECONOMY) && cs.contains(ClassOfService.PREMIUM)) {
                    record.setClassOfService(ClassOfService.ECONOMY.name());
                } else if (cs.contains(ClassOfService.BUSINESS) && cs.contains(ClassOfService.PREMIUM_BUSINESS)) {
                    record.setClassOfService(ClassOfService.BUSINESS.name());
                } else if (cs.contains(ClassOfService.FIRST) && cs.contains(ClassOfService.PREMIUM_FIRST)) {
                    record.setClassOfService(ClassOfService.FIRST.name());
                } else {
                    record.setClassOfService(ClassOfService.MIXED.name());
                }
            } else {
                switch ((ClassOfService)cs.get(0)) {
                    case ECONOMY: 
                    case PREMIUM: {
                        record.setClassOfService(ClassOfService.ECONOMY.name());
                        break;
                    }
                    case BUSINESS: 
                    case PREMIUM_BUSINESS: {
                        record.setClassOfService(ClassOfService.BUSINESS.name());
                        break;
                    }
                    case FIRST: 
                    case PREMIUM_FIRST: {
                        record.setClassOfService(ClassOfService.FIRST.name());
                    }
                }
            }
        } else {
            record.setClassOfService(ClassOfService.ECONOMY.name());
        }
        if (product.getProductCategory() != ProductCategory.AIR) {
            record.setServiceCompleted(false);
            record.setPriceOfCompletedService(BigDecimal.ZERO);
        }
        this.setSegmentsData(product, record, isDemon);
        ReportProductAirFieldsProcessor.updateLocations(product, record, isDemon);
        this.updateTaxForBlank(product, record);
        record.setTaxRI(ReportProductCommonFieldsProcessor.calculateMeasure(AirProductTaxHelper.getEquivalentTaxesAmountByCodes((Collection)product.getTaxes(), (boolean)true, (String[])new String[]{"RI"}), product));
        BigDecimal tripartiteDiscount = ReportProductAirFieldsProcessor.getTripartiteDiscount(product);
        record.setTripartiteDiscount(tripartiteDiscount);
        record.setTripartite(BigDecimal.ZERO.compareTo(tripartiteDiscount) != 0);
        if (product.getTripartiteContractDetails() != null) {
            record.setTripartiteByFlag(product.getTripartiteContractDetails().isIssuedUnder3d());
        }
        record.setFareBasises(segments.stream().map(Segment::getFareBasis).collect(Collectors.joining(", ")));
        record.setRoundTrip(AirProductHelper.isRoundTrip((Product)product));
        if (product.getStatus() == ProductStatus.REFUND) {
            BigDecimal refundTaxAmount = AirProductTaxHelper.getTaxesForBlankEquivalentAmount((Product)product);
            BigDecimal sellTaxAmount = AirProductTaxHelper.getTaxesForBlankEquivalentAmount((Product)product.getPreviousProduct());
            record.setTaxForBlankRetention(sellTaxAmount.subtract(refundTaxAmount));
            BigDecimal refundPSTaxAmount = AirProductTaxHelper.getEquivalentTaxesAmountByCodes((Product)product, (String[])new String[]{"PS"});
            BigDecimal sellPSTaxAmount = AirProductTaxHelper.getEquivalentTaxesAmountByCodes((Product)product.getPreviousProduct(), (String[])new String[]{"PS"});
            record.setTaxPSRetention(sellPSTaxAmount.subtract(refundPSTaxAmount));
        }
        if (record.isServiceCompleted() && (statisticalData = product.getStatisticalData()) != null) {
            record.setMinimumPrice(MiscUtil.guarded((BigDecimal)MiscUtil.minimum((BigDecimal[])new BigDecimal[]{this.getAfsValue(statisticalData.getLaf1Bkg(), statisticalData.getLaf1Tkt()), this.getAfsValue(statisticalData.getLaf2Bkg(), statisticalData.getLaf2Tkt()), this.getAfsValue(statisticalData.getLaf3Bkg(), statisticalData.getLaf3Tkt()), this.getAfsValue(statisticalData.getLpf1Bkg(), statisticalData.getLpf1Tkt()), this.getAfsValue(statisticalData.getLpf2Bkg(), statisticalData.getLpf2Tkt()), this.getAfsValue(statisticalData.getLpf3Bkg(), statisticalData.getLpf3Tkt())})));
            record.setMaximumPrice(MiscUtil.guarded((BigDecimal)MiscUtil.maximum((BigDecimal[])new BigDecimal[]{this.getAfsValue(statisticalData.getHbf1Bkg(), statisticalData.getHbf1Tkt()), this.getAfsValue(statisticalData.getHbf2Bkg(), statisticalData.getHbf2Tkt())})));
            RestReportsHelper.fillPossibleEconomy(record, MiscUtil.sum((BigDecimal[])new BigDecimal[]{AirProductHelper.getEquivalentFare((Product)product), AirProductHelper.calculateTaxesEquivalentAmount((Product)product)}));
        }
        if (product.getStatus() == ProductStatus.REFUND && product.getMcoCategory() == MCOCategory.VOUCHER && (exchange = product.getPreviousProduct().getPreviousProduct()) != null) {
            record.setInExchangeTo(exchange.getSystemNumber());
        }
        if (product.getSalesPoint() != null) {
            record.setSalesPoint(RestReportsHelper.convertReference(Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)product.getSalesPoint(), (EntityStorageContext)sc)).map(EntityContainer::toReference).orElse(product.getSalesPoint())));
        }
        if (product.getSegmentTariffs().stream().map(SegmentTariff::getSegments).flatMap(Collection::stream).map(Segment::getCo2EmissionsKg).allMatch(Objects::nonNull)) {
            int value = product.getSegmentTariffs().stream().map(SegmentTariff::getSegments).flatMap(Collection::stream).mapToInt(Segment::getCo2EmissionsKg).sum();
            record.setCo2emissions(String.format("%d %s", value, isDemon != false ? WeightUnit.KG.toString(LocaleHelper.EN_LOCALE) : WeightUnit.KG));
        }
        this.updateFirstAndLastServiceDateForMco(product, record);
    }

    private void updateFirstAndLastServiceDateForMco(Product product, ReportProduct record) {
        Date firstTravelDate;
        Product relatedProduct;
        ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)product);
        if (product.getMcoCategory() == null) {
            return;
        }
        if (!TextUtil.isBlank((String)record.getFirstServiceDate()) && TextUtil.isBlank((String)record.getLastServiceDate())) {
            record.setLastServiceDate(record.getFirstServiceDate());
        }
        if (product.getSegmentTariffs().isEmpty() && TextUtil.isBlank((String)record.getFirstServiceDate()) && (relatedProduct = this.getRelatedProduct(product)) != null && (firstTravelDate = handler.findFirstTravelDate((BaseProduct)relatedProduct)) != null) {
            record.setFirstServiceDate(ReportProductCommonFieldsProcessor.dateFormat.format(MiscUtil.toLocalDate((Date)firstTravelDate)));
            record.setLastServiceDate(ReportProductCommonFieldsProcessor.dateFormat.format(MiscUtil.toLocalDate((Date)firstTravelDate)));
        }
    }

    private Product getRelatedProduct(Product product) {
        if (!product.getRelatedProducts().isEmpty()) {
            return (Product)product.getRelatedProducts().get(0);
        }
        return null;
    }

    private boolean isTourCodeExists(Product product) {
        return product.getTourCode() != null && !product.getTourCode().equals("");
    }

    private BigDecimal getAfsValue(Double laf1Bkg, Double laf1Tkt) {
        if (laf1Tkt != null) {
            return BigDecimal.valueOf(laf1Tkt);
        }
        return laf1Bkg == null ? null : BigDecimal.valueOf(laf1Bkg);
    }

    private static BigDecimal getTripartiteDiscount(Product product) {
        BigDecimal delta;
        BigDecimal taxes;
        if (product.getStatus() != ProductStatus.SELL || product.getNextProduct() != null) {
            return BigDecimal.ZERO;
        }
        StatisticalData sd = product.getStatisticalData();
        if (sd == null) {
            return BigDecimal.ZERO;
        }
        Double p3d = sd.getP3dTkt();
        if (p3d == null) {
            p3d = sd.getP3dBkg();
        }
        if (p3d == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal p3dbd = BigDecimal.valueOf(p3d);
        BigDecimal fareAndTaxes = BigDecimal.ZERO;
        BigDecimal fare = AirProductHelper.getEquivalentFare((Product)product);
        if (fare != null) {
            fareAndTaxes = fareAndTaxes.add(fare);
        }
        if ((taxes = AirProductHelper.calculateTaxesEquivalentAmount((Product)product)) != null) {
            fareAndTaxes = fareAndTaxes.add(taxes);
        }
        return (delta = p3dbd.subtract(fareAndTaxes)).compareTo(BigDecimal.ZERO) > 0 ? delta : BigDecimal.ZERO;
    }

    private void updateTaxForBlank(Product product, ReportProduct record) {
        EntityContainer blankOwnerCtr = EntityStorage.get().resolve(product.getBlankOwnerRef());
        if (blankOwnerCtr == null || ((Organization)blankOwnerCtr.getEntity()).getAirline() == null) {
            return;
        }
        String[] taxesForBlankCodes = AirProductTaxHelper.getTaxesForBlankCodes((DictionaryReference)((Organization)blankOwnerCtr.getEntity()).getAirline());
        AirProductContractRelationData clientContractRelation = AirProductHelper.getClientContractRelation((Product)product);
        List taxes = clientContractRelation.getServiceData().getDetalization().getTaxes().stream().filter(t -> t.getAmount() != null && this.contains(t.getCode(), taxesForBlankCodes)).collect(Collectors.toList());
        record.setTaxForBlank(ReportProductCommonFieldsProcessor.calculateMeasure(taxes.stream().map(SimpleTax::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add), product));
        ContractRelationVatDetalization vat = clientContractRelation.getServiceData().getDetalization().getVat();
        if (vat != null) {
            record.setTaxForBlankVAT(ReportProductCommonFieldsProcessor.calculateMeasure(vat.getComponents().stream().filter(comp -> comp.getSum() != null && this.contains(comp.getTaxesUids(), taxes)).map(VatComponent::getSum).reduce(BigDecimal.ZERO, BigDecimal::add), product));
        }
    }

    private boolean contains(Set<String> taxesUids, List<SimpleTax> taxes) {
        for (String taxUid : taxesUids) {
            for (SimpleTax tax : taxes) {
                if (!tax.getUid().equals(taxUid)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean contains(String code, String[] taxesForBlankCodes) {
        if (code == null) {
            return false;
        }
        for (String tax : taxesForBlankCodes) {
            if (!code.equals(tax)) continue;
            return true;
        }
        return false;
    }

    private void setSegmentsData(Product product, ReportProduct record, boolean isDemon) {
        ArrayList<String> sr = new ArrayList<String>();
        ArrayList<String> sd = new ArrayList<String>();
        ArrayList<String> sa = new ArrayList<String>();
        for (SegmentTariff segmentTariff : product.getSegmentTariffs()) {
            for (Segment segment : segmentTariff.getSegments()) {
                StringBuilder route = new StringBuilder();
                GeoLocation departureCity = DictHelper.findCity((DictionaryReference)segment.getDepartureLocation());
                GeoLocation arrivalCity = DictHelper.findCity((DictionaryReference)segment.getArriveLocation());
                if (departureCity != null) {
                    if (isDemon) {
                        Optional.ofNullable(MiscUtil.findByLocale((Map)departureCity.getTranslations(), (Locale)LocaleHelper.EN_LOCALE)).ifPresent(route::append);
                    } else {
                        route.append(departureCity);
                    }
                }
                route.append(" - ");
                if (arrivalCity != null) {
                    if (isDemon) {
                        Optional.ofNullable(MiscUtil.findByLocale((Map)arrivalCity.getTranslations(), (Locale)LocaleHelper.EN_LOCALE)).ifPresent(route::append);
                    } else {
                        route.append(arrivalCity);
                    }
                }
                sr.add(route.toString());
                sd.add(segment.getStartDate() != null ? ReportProductCommonFieldsProcessor.strDTF.format(segment.getStartDate()) : " - ");
                sa.add(segment.getEndDate() != null ? ReportProductCommonFieldsProcessor.strDTF.format(segment.getEndDate()) : " - ");
            }
        }
        record.setSegmentsRoute(String.join((CharSequence)", ", sr));
        record.setSegmentsDepartureDate(String.join((CharSequence)", ", sd));
        record.setSegmentsArrivalDate(String.join((CharSequence)", ", sa));
    }

    static void updateLocations(Product product, ReportProduct record, boolean isDemon) {
        GeoLocation departureLocation = null;
        GeoLocation destinationLocation = null;
        HashSet<GeoLocation> cities = new HashSet<GeoLocation>();
        int n = 0;
        for (Segment seg : AirProductHelper.getSegments((Collection)product.getSegmentTariffs())) {
            GeoLocation arrivalCity;
            GeoLocation departureCity = DictHelper.findCity((DictionaryReference)seg.getDepartureLocation());
            if (n == 0) {
                departureLocation = departureCity;
            }
            if (departureCity != null) {
                cities.add(departureCity);
            }
            if ((arrivalCity = DictHelper.findCity((DictionaryReference)seg.getArriveLocation())) != null) {
                if (cities.contains(arrivalCity)) break;
                destinationLocation = arrivalCity;
            }
            ++n;
        }
        if (departureLocation != null) {
            record.setDepartureCity(RestReportsHelper.convertReference(departureLocation.toReference(), isDemon));
            record.setDepartureCountry(RestReportsHelper.convertReference(departureLocation.getCountry(), isDemon));
        }
        if (destinationLocation != null) {
            record.setDestinationCity(RestReportsHelper.convertReference(destinationLocation.toReference(), isDemon));
            record.setDestinationCountry(RestReportsHelper.convertReference(destinationLocation.getCountry(), isDemon));
        }
        if (departureLocation != null && destinationLocation != null) {
            record.setRouteLine(RestReportsHelper.getRouteLine((DictionaryReference<GeoLocation>)departureLocation.toReference(), (DictionaryReference<GeoLocation>)destinationLocation.toReference(), isDemon));
            if (isDemon) {
                record.setFullRouteLine(record.getRouteLine());
            }
        }
    }
}

