/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports.getBookingFile.products;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.bus.BusProduct;
import com.gridnine.xtrip.common.model.booking.bus.BusSegment;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.bus.BusStation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.server.ibecorp.rest.reports.IbusReportsRestContextKeys;
import com.gridnine.xtrip.server.ibecorp.rest.reports.RestReportsHelper;
import com.gridnine.xtrip.server.ibecorp.rest.reports.getBookingFile.products.ReportProductCommonFieldsProcessor;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.rest.reports.ReportProduct;
import com.gridnine.xtrip.server.model.rest.reports.RestProductType;
import java.util.ArrayList;
import java.util.Optional;

public class ReportProductBusProductFieldsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Boolean isDemon = (Boolean)ctx.getObject((Enum)IbusReportsRestContextKeys.DEMON_KEY);
        ReportProduct record = (ReportProduct)ctx.getMandatoryObject((Enum)IbusReportsRestContextKeys.RECORD);
        record.setProductType(RestProductType.BUS);
        BusProduct product = (BusProduct)ctx.getMandatoryObject((Enum)IBusRestContextKeys.PRODUCT);
        ArrayList<String> sr = new ArrayList<String>();
        ArrayList<String> sd = new ArrayList<String>();
        ArrayList<String> sa = new ArrayList<String>();
        for (BusSegment segment : product.getSegments()) {
            DictionaryReference<GeoLocation> departureCity = this.getCity((DictionaryReference<BusStation>)segment.getDeparture());
            DictionaryReference<GeoLocation> arrivalCity = this.getCity((DictionaryReference<BusStation>)segment.getArrival());
            sr.add(RestReportsHelper.getRouteLine(departureCity, arrivalCity, isDemon));
            sd.add(segment.getDepartureDate() != null ? ReportProductCommonFieldsProcessor.strDTF.format(segment.getDepartureDate()) : " - ");
            sa.add(segment.getArrivalDate() != null ? ReportProductCommonFieldsProcessor.strDTF.format(segment.getArrivalDate()) : " - ");
        }
        record.setSegmentsRoute(String.join((CharSequence)", ", sr));
        record.setSegmentsDepartureDate(String.join((CharSequence)", ", sd));
        record.setSegmentsArrivalDate(String.join((CharSequence)", ", sa));
        DictionaryReference<GeoLocation> departureCity = null;
        DictionaryReference<GeoLocation> destinationCity = null;
        if (!product.getSegments().isEmpty()) {
            BusSegment busSegment = (BusSegment)product.getSegments().get(0);
            departureCity = this.getCity((DictionaryReference<BusStation>)busSegment.getDeparture());
            record.setDepartureCity(RestReportsHelper.convertReference(departureCity, isDemon));
            record.setDepartureCountry(RestReportsHelper.convertReference(this.getCountry((DictionaryReference<BusStation>)busSegment.getDeparture()), isDemon));
            busSegment = (BusSegment)product.getSegments().get(product.getSegments().size() - 1);
            destinationCity = this.getCity((DictionaryReference<BusStation>)busSegment.getArrival());
            record.setDestinationCity(RestReportsHelper.convertReference(destinationCity, isDemon));
            record.setDestinationCountry(RestReportsHelper.convertReference(this.getCountry((DictionaryReference<BusStation>)busSegment.getArrival()), isDemon));
        }
        record.setRouteLine(RestReportsHelper.getRouteLine(departureCity, destinationCity, isDemon));
        if (isDemon.booleanValue()) {
            record.setFullRouteLine(record.getRouteLine());
        }
        if (product.getSalesPoint() != null) {
            record.setSalesPoint(RestReportsHelper.convertReference(Optional.ofNullable(EntityStorage.get().resolve(product.getSalesPoint())).map(EntityContainer::toReference).orElse(product.getSalesPoint())));
        }
    }

    private DictionaryReference<Country> getCountry(DictionaryReference<BusStation> departureStation) {
        BusStation busStation = (BusStation)DictionaryCache.get().resolveReference(departureStation);
        if (busStation != null && busStation.getCountry() != null) {
            return busStation.getCountry();
        }
        return null;
    }

    private DictionaryReference<GeoLocation> getCity(DictionaryReference<BusStation> departureStation) {
        BusStation busStation = (BusStation)DictionaryCache.get().resolveReference(departureStation);
        if (busStation != null && busStation.getCity() != null) {
            return busStation.getCity();
        }
        return null;
    }
}

