/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports.getBookingFile.products;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopComponentType;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.MCOFees;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ReportFeeCategoryType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.SimpleTax;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.TravelPolicyViolationType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.bus.BusProduct;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProduct;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoidingType;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayCrimeaMco;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiProduct;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.booking.visa.VisaProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.corteos.CorteosBookingFileData;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.dict.CommissionCategory;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.LegalForm;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageActualizeParameters;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementIndex;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.TransactionSplitIndex;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ModelHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.helpers.XtripPriceStructure;
import com.gridnine.xtrip.common.model.helpers.XtripPriceStructureHelper;
import com.gridnine.xtrip.common.model.profile.AFSType;
import com.gridnine.xtrip.common.model.profile.CalculatedStatisticType;
import com.gridnine.xtrip.common.model.profile.CompanyGroup;
import com.gridnine.xtrip.common.model.profile.ExternalSystem;
import com.gridnine.xtrip.common.model.profile.ExternalSystemCode;
import com.gridnine.xtrip.common.model.profile.ExternalSystemCodeV2;
import com.gridnine.xtrip.common.model.profile.Holding;
import com.gridnine.xtrip.common.model.profile.KeyContact;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PredefinedSalesChainType;
import com.gridnine.xtrip.common.model.profile.ReasonCode;
import com.gridnine.xtrip.common.model.profile.ReasonCodeComparisonType;
import com.gridnine.xtrip.common.model.profile.SalesChainDescription;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.trip.BusinessTripIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.helpers.XreportsIntegrationHelper;
import com.gridnine.xtrip.server.ibecorp.l10n.Messages;
import com.gridnine.xtrip.server.ibecorp.rest.reports.IbusReportsRestContextKeys;
import com.gridnine.xtrip.server.ibecorp.rest.reports.RestReportsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.helpers.ShipmentHelper;
import com.gridnine.xtrip.server.model.rest.reports.BookingAgent;
import com.gridnine.xtrip.server.model.rest.reports.EffectivePenaltyCategory;
import com.gridnine.xtrip.server.model.rest.reports.EnumWrapper;
import com.gridnine.xtrip.server.model.rest.reports.GetBookingFileResult;
import com.gridnine.xtrip.server.model.rest.reports.OnlineReservationCategory;
import com.gridnine.xtrip.server.model.rest.reports.PriceParameter;
import com.gridnine.xtrip.server.model.rest.reports.PriceParameterType;
import com.gridnine.xtrip.server.model.rest.reports.RegionType;
import com.gridnine.xtrip.server.model.rest.reports.ReportBookingFile;
import com.gridnine.xtrip.server.model.rest.reports.ReportProduct;
import com.gridnine.xtrip.server.model.rest.reports.ReportProductAccountManager;
import com.gridnine.xtrip.server.model.rest.reports.ReportRestHotel;
import com.gridnine.xtrip.server.model.rest.reports.RestEntityReference;
import com.gridnine.xtrip.server.model.rest.reports.RestTicketType;
import com.gridnine.xtrip.server.model.rest.reports.TravelPolicy;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class ReportProductCommonFieldsProcessor
extends BaseProcessor {
    public static DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static DateTimeFormatter dateTimeFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS");
    public static DateFormat strDTF = new SimpleDateFormat("dd.MM.yyyy");

    public void process(MessageContext ctx) throws Exception {
        EntityContainer resolve;
        EntityContainer client;
        List productNumbers;
        EntityContainer blankOwner;
        EntityReference retailProfileRef;
        Boolean isDemon = (Boolean)ctx.getObject((Enum)IbusReportsRestContextKeys.DEMON_KEY);
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        GetBookingFileResult res = (GetBookingFileResult)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_RESULT);
        ReportBookingFile reportBookingFile = res.getBookingFile();
        BaseProduct product = (BaseProduct)ctx.getMandatoryObject((Enum)IBusRestContextKeys.PRODUCT);
        ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)product);
        ReportProduct reportProduct = new ReportProduct();
        reportProduct.setProductUid(product.getUid());
        reportBookingFile.getProducts().add(reportProduct);
        TicketType ticketType = handler.getTicketType(product);
        reportProduct.setTicketType(ReportProductCommonFieldsProcessor.getTicketType(ticketType).name());
        XtripPriceStructure xtripPriceStructure = XtripPriceStructureHelper.calculatePriceStructure((BaseProduct)product, (boolean)true);
        boolean filterOutBspCommissions = false;
        if (product instanceof Product) {
            Product prod = (Product)product;
            filterOutBspCommissions = AirProductHelper.isBSPTicket((Product)prod) && AirProductHelper.getSupplier((Product)prod) != null && prod.getBlankOwnerRef() != null && !prod.getBlankOwnerRef().equals((Object)AirProductHelper.getSupplier((Product)prod));
        }
        Collection vendorCommissions = GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getVendorCommissions((BaseProduct)product), (Set)GeneralProductHelper.commissionPropertyTypes, (Set)(filterOutBspCommissions ? GeneralProductHelper.nonBspCommissionTypes : null), (Set)GeneralProductHelper.standardCommissionCategories);
        reportProduct.setSupplierCommission(ReportProductCommonFieldsProcessor.calculateMeasure(GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)vendorCommissions), product));
        reportProduct.setSupplierCommissionRate(MiscUtil.guarded((BigDecimal)GeneralProductHelper.calculateCommissionsRate((Collection)vendorCommissions, (boolean)true)));
        Collection subagencyCommissions = GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getSubagentCommissions((BaseProduct)product), (Set)GeneralProductHelper.commissionPropertyTypes, null, (Set)GeneralProductHelper.standardCommissionCategories);
        reportProduct.setSubagencyCommission(ReportProductCommonFieldsProcessor.calculateMeasure(GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)subagencyCommissions), product));
        reportProduct.setSubagencyCommissionRate(MiscUtil.guarded((BigDecimal)GeneralProductHelper.calculateCommissionsRate((Collection)subagencyCommissions, (boolean)true)));
        reportProduct.setAgencyCommissionIncome(MiscUtil.sum((BigDecimal[])new BigDecimal[]{reportProduct.getSupplierCommission(), MiscUtil.negate((BigDecimal)reportProduct.getSubagencyCommission())}));
        SalesChain salesChain = GeneralProductHelper.getHandler((BaseProduct)product).getSalesChain(product);
        EntityContainer ctr = EntityStorageHelper.resolve((EntityReference)salesChain.getDescription(), (EntityStorageContext)sc);
        PredefinedSalesChainType salesChainType = ctr != null ? ((SalesChainDescription)ctr.getEntity()).getPredefinedType() : null;
        BigDecimal hiddenFeesEquivalentAmount = PredefinedSalesChainType.SUBAGENT == salesChainType || PredefinedSalesChainType.SUBAGENT_TECHNICAL_PROVIDER == salesChainType ? GeneralProductHelper.calculateHiddenFeesEquivalentValue((Collection)GeneralProductHelper.getSubagentCommissions((BaseProduct)product)) : GeneralProductHelper.calculateHiddenFeesEquivalentValue((Collection)GeneralProductHelper.getClientCommissions((BaseProduct)product));
        reportProduct.setHiddenFee(ReportProductCommonFieldsProcessor.calculateMeasure(hiddenFeesEquivalentAmount, product));
        reportProduct.setHiddenFeeVAT(ReportProductCommonFieldsProcessor.calculateMeasure(ReportProductCommonFieldsProcessor.extractHiddenVat(product, sc, FopComponentType.PRODUCT), product));
        GeneralProductContractRelationData subagentContractRelation = GeneralProductHelper.getSubagentContractRelation((BaseProduct)product);
        ReportProductCommonFieldsProcessor.populateContractData(product, reportProduct, sc, isDemon);
        AtomicReference<BigDecimal> voidFee = new AtomicReference<BigDecimal>(new BigDecimal(0));
        AtomicReference<BigDecimal> sellFee = new AtomicReference<BigDecimal>(new BigDecimal(0));
        AtomicReference<BigDecimal> sellFeeVat = new AtomicReference<BigDecimal>(new BigDecimal(0));
        if (ProductStatusHandler.getAllVoidStatuses().contains(handler.getStatus(product))) {
            product.getReservation().getProducts().stream().filter(p -> p instanceof ProductVoiding).map(p -> (ProductVoiding)p).filter(pv -> pv.getRelatedProduct() != null).filter(pv -> product.getUid().equals(pv.getRelatedProduct().getUid())).forEach(pv -> {
                BigDecimal total = XtripPriceStructureHelper.calculatePriceStructure((BaseProduct)pv, (boolean)false).getTotal();
                ProductVoidingType type = pv.getType() == null ? ProductVoidingType.VOIDING_FEE : pv.getType();
                switch (type) {
                    case VOIDING_FEE: {
                        if (total == null) break;
                        voidFee.set(((BigDecimal)voidFee.get()).add(total));
                        reportProduct.setVoidingFeeVat(reportProduct.getVoidingFeeVat().add(ReportProductCommonFieldsProcessor.extractVat((BaseProduct)pv, sc, FopComponentType.values())));
                        break;
                    }
                    case RETAINED_SELL_FEE: {
                        if (total != null) {
                            sellFee.set(((BigDecimal)sellFee.get()).add(total));
                        }
                        sellFeeVat.set(((BigDecimal)sellFeeVat.get()).add(ReportProductCommonFieldsProcessor.extractVat((BaseProduct)pv, sc, FopComponentType.values())));
                    }
                }
            });
        }
        reportProduct.setVoidingFee(voidFee.get());
        if (subagentContractRelation != null) {
            Collection fees = GeneralProductHelper.filterCommissions((Collection)subagentContractRelation.getCommissions(), (Set)GeneralProductHelper.serviceFeePropertyTypes, null, null);
            fees.removeIf(f -> GeneralProductHelper.isHiddenFee((EntityReference)f.getCommissionProperties()));
            reportProduct.setFirstSubagencyFee(ReportProductCommonFieldsProcessor.calculateMeasure(this.calculateFee(fees, ReportFeeCategoryType.CATEGORY_1, false, sc), product));
            reportProduct.setSecondSubagencyFee(ReportProductCommonFieldsProcessor.calculateMeasure(this.calculateFee(fees, ReportFeeCategoryType.CATEGORY_2, false, sc), product));
            XtripPriceStructure subXtripPriceStructure = new XtripPriceStructure();
            XtripPriceStructureHelper.updateFees((XtripPriceStructure)subXtripPriceStructure, (List)subagentContractRelation.getCommissions(), (List)(GeneralProductHelper.getVendorContractRelation((BaseProduct)product) == null ? null : GeneralProductHelper.getVendorContractRelation((BaseProduct)product).getCommissions()), (boolean)true);
            reportProduct.setSubagencyFee(MiscUtil.sum((BigDecimal[])new BigDecimal[]{ReportProductCommonFieldsProcessor.calculateMeasure(subXtripPriceStructure.getAgencyFees(), product), sellFee.get()}));
            reportProduct.setSubagencyPrice(ReportProductCommonFieldsProcessor.calculateMeasure(subagentContractRelation.getServiceData().getTotalPrice(), product));
            reportProduct.setSubagencyTotal(ReportProductCommonFieldsProcessor.calculateMeasure(MiscUtil.sum((BigDecimal[])new BigDecimal[]{reportProduct.getSubagencyPrice(), subXtripPriceStructure.getSupplierFees(), reportProduct.getSubagencyFee(), reportProduct.getTechnicalFee(), reportProduct.getHiddenFee(), voidFee.get()}), product));
            reportProduct.setSubagencyFopSum(ReportProductCommonFieldsProcessor.calculateMeasure(MiscUtil.guarded((BigDecimal)GeneralProductHelper.getSubagentFopAmount((BaseProduct)product)), product));
            reportProduct.setAgencyFee(reportProduct.getSubagencyFee());
            reportProduct.setSupplierFee(ReportProductCommonFieldsProcessor.calculateMeasure(subXtripPriceStructure.getSupplierFees(), product));
        } else {
            reportProduct.setAgencyFee(MiscUtil.sum((BigDecimal[])new BigDecimal[]{ReportProductCommonFieldsProcessor.calculateMeasure(xtripPriceStructure.getAgencyFees(), product), sellFee.get()}));
            reportProduct.setSupplierFee(ReportProductCommonFieldsProcessor.calculateMeasure(xtripPriceStructure.getSupplierFees(), product));
        }
        reportProduct.setSupplierTotal(ReportProductCommonFieldsProcessor.calculateMeasure(MiscUtil.guarded((BigDecimal)GeneralProductHelper.getVendorFopAmount((BaseProduct)product)), product));
        reportProduct.setReasonCode(this.getReasonCode(product));
        reportProduct.setPenalty(MiscUtil.guarded((BigDecimal)handler.getPenalty(product)));
        reportProduct.setAgencyFeeVat(MiscUtil.sum((BigDecimal[])new BigDecimal[]{ReportProductCommonFieldsProcessor.calculateMeasure(ReportProductCommonFieldsProcessor.extractVat(product, sc, FopComponentType.OWN_FEES), product), sellFeeVat.get()}));
        reportProduct.setAgencyFeeIncome(MiscUtil.sum((BigDecimal[])new BigDecimal[]{ReportProductCommonFieldsProcessor.calculateMeasure(xtripPriceStructure.getAgencyFeesIncome(), product), reportProduct.getHiddenFee(), sellFee.get(), voidFee.get()}));
        reportProduct.setSupplierFeeVat(ReportProductCommonFieldsProcessor.calculateMeasure(ReportProductCommonFieldsProcessor.extractVat(product, sc, FopComponentType.VENDOR_FEES), product));
        GeneralProductContractRelationData techRelation = GeneralProductHelper.getTechnicalProviderContractRelation((BaseProduct)product);
        if (techRelation != null) {
            reportProduct.setTechnicalFee(GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)techRelation.getCommissions(), (Set)GeneralProductHelper.feePropertyTypes, null, null)));
            reportProduct.setAgencyBonusDiscount(GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)techRelation.getCommissions(), (Set)GeneralProductHelper.discountPropertyTypes, null, null)));
        }
        reportProduct.setPrice(ReportProductCommonFieldsProcessor.calculateMeasure(xtripPriceStructure.getProductPrice(), product));
        reportProduct.setPriceVat(ReportProductCommonFieldsProcessor.calculateMeasure(MiscUtil.sum((BigDecimal[])new BigDecimal[]{ReportProductCommonFieldsProcessor.extractVat(product, sc, FopComponentType.PRODUCT, FopComponentType.SERVICE, FopComponentType.TAXES, FopComponentType.PENALTY, FopComponentType.DEDUCTION)}), product));
        reportProduct.setTotal(MiscUtil.sum((BigDecimal[])new BigDecimal[]{reportProduct.getPrice(), reportProduct.getSupplierFee(), reportProduct.getAgencyFee(), reportProduct.getTechnicalFee(), reportProduct.getHiddenFee(), voidFee.get()}));
        reportProduct.setTaxesSum(ReportProductCommonFieldsProcessor.calculateMeasure(xtripPriceStructure.getPriceDetalization().getTaxes(), product));
        reportProduct.setEffectivePenalty(reportProduct.getPenalty());
        reportProduct.setPenaltyVAT(ReportProductCommonFieldsProcessor.extractVat(product, sc, FopComponentType.PENALTY).negate());
        if (handler.getStatus(product) == ProductStatus.REFUND && handler.getPenalty(product) != null && BigDecimal.ZERO.compareTo(handler.getPenalty(product)) != 0) {
            reportProduct.setEffectivePenaltyCategory(EffectivePenaltyCategory.REFUND.name());
        } else if (handler.getStatus(product) == ProductStatus.SELL && handler.getPreviousProduct(product) != null && handler.getStatus(handler.getPreviousProduct(product)) == ProductStatus.EXCHANGE && handler.getPenalty(product) != null && BigDecimal.ZERO.compareTo(handler.getPenalty(product)) != 0) {
            reportProduct.setEffectivePenaltyCategory(EffectivePenaltyCategory.EXCHANGE.name());
        } else {
            reportProduct.setEffectivePenaltyCategory("");
        }
        GeneralProductContractRelationData clientContractRelation = GeneralProductHelper.getClientContractRelation((BaseProduct)product);
        if (handler.getStatus(product) == ProductStatus.SELL && handler.getNextProduct(product) == null) {
            reportProduct.setServiceCompleted(true);
            if (clientContractRelation != null && clientContractRelation.getServiceData().getDetalization().getFare() != null) {
                reportProduct.setPriceOfCompletedService(MiscUtil.guarded((BigDecimal)MiscUtil.sum((BigDecimal[])new BigDecimal[]{clientContractRelation.getServiceData().getDetalization().getFare(), this.calculateTaxAmount(clientContractRelation.getServiceData().getDetalization().getTaxes()), clientContractRelation.getServiceData().getDetalization().getPenalty(), clientContractRelation.getServiceData().getDetalization().getDeduction()})));
            } else {
                reportProduct.setPriceOfCompletedService(MiscUtil.guarded((BigDecimal)MiscUtil.sum((BigDecimal[])new BigDecimal[]{handler.getEquivalentFare(product), GeneralProductHelper.getEquivalentTaxAmount((Collection)handler.getTaxes(product)), handler.getPenalty(product)})));
            }
        }
        if (clientContractRelation != null && clientContractRelation.getServiceData().getDetalization().getFare() != null) {
            reportProduct.setEquivalentFare(ReportProductCommonFieldsProcessor.calculateMeasure(clientContractRelation.getServiceData().getDetalization().getFare(), product));
        } else {
            reportProduct.setEquivalentFare(ReportProductCommonFieldsProcessor.calculateMeasure(handler.getEquivalentFare(product), product));
        }
        if (clientContractRelation != null && clientContractRelation.getServiceData().getDetalization().getAdditionalFee() != null) {
            reportProduct.setAdditionalServicesSum(ReportProductCommonFieldsProcessor.calculateMeasure(clientContractRelation.getServiceData().getDetalization().getAdditionalFee(), product));
        }
        if (clientContractRelation != null && clientContractRelation.getServiceData().getDetalization().getDeduction() != null) {
            reportProduct.setDeduction(ReportProductCommonFieldsProcessor.calculateMeasure(clientContractRelation.getServiceData().getDetalization().getDeduction(), product));
        }
        if (clientContractRelation != null) {
            Collection fees = GeneralProductHelper.filterCommissions((Collection)clientContractRelation.getCommissions(), (Set)GeneralProductHelper.serviceFeePropertyTypes, null, null);
            reportProduct.setFirstClientFee(ReportProductCommonFieldsProcessor.calculateMeasure(this.calculateFee(fees, ReportFeeCategoryType.CATEGORY_1, true, sc), product));
            reportProduct.setSecondClientFee(ReportProductCommonFieldsProcessor.calculateMeasure(this.calculateFee(fees, ReportFeeCategoryType.CATEGORY_2, true, sc), product));
        }
        BigDecimal cashFopSum = BigDecimal.ZERO;
        BigDecimal retailFopSum = BigDecimal.ZERO;
        EntityContainer retailProfileContainer = ProfileHelper.getRetailProfileContainer();
        EntityReference entityReference = retailProfileRef = retailProfileContainer != null ? retailProfileContainer.toReference() : null;
        if (clientContractRelation != null) {
            for (GeneralProductFop fop : clientContractRelation.getFops()) {
                if (fop.getEquivalentAmount() == null) continue;
                if (fop.getType() == PaymentType.CASH) {
                    cashFopSum = cashFopSum.add(fop.getEquivalentAmount());
                }
                if (retailProfileRef == null || !retailProfileRef.equals((Object)fop.getPayer())) continue;
                retailFopSum = retailFopSum.add(fop.getEquivalentAmount());
            }
        }
        reportProduct.setCashFopSum(ReportProductCommonFieldsProcessor.calculateMeasure(cashFopSum, product));
        reportProduct.setRetailFopSum(ReportProductCommonFieldsProcessor.calculateMeasure(retailFopSum, product));
        ctx.putObject((Enum)IbusReportsRestContextKeys.RECORD, (Object)reportProduct);
        EntityReference issuingAgentReference = this.actualize(handler.findIssuingAgent(product));
        reportProduct.setAgent(isDemon != false ? RestReportsHelper.convertReference(issuingAgentReference, RestReportsHelper.personNameGetter(issuingAgentReference, sc)) : RestReportsHelper.convertReference(issuingAgentReference));
        if (issuingAgentReference != null) {
            reportProduct.setAgentPhone(this.getPhone(issuingAgentReference, sc));
            reportProduct.setAgentEmail(this.getEmail(issuingAgentReference, sc));
        }
        if ((blankOwner = EntityStorageHelper.resolve((EntityReference)handler.getBlankOwner(product), (EntityStorageContext)sc)) != null && ((Organization)blankOwner.getEntity()).getCode() != null) {
            reportProduct.setBlankOwnerCode(((Organization)blankOwner.getEntity()).getCode());
        }
        reportProduct.setTicketNumber((productNumbers = handler.getProductNumbers(product)).isEmpty() ? "" : (String)productNumbers.get(0));
        EntityReference clientOrganizationReference = this.actualize(product.getReservation().getBookingFile().getCustomerProfile());
        reportProduct.setClient(isDemon != false ? RestReportsHelper.convertReference(clientOrganizationReference, RestReportsHelper.organizationNameGetter(clientOrganizationReference, sc)) : RestReportsHelper.convertReference(clientOrganizationReference));
        reportProduct.setClientFullCaption(ReportProductCommonFieldsProcessor.getFullCaption((EntityReference<Organization>)product.getReservation().getBookingFile().getCustomerProfile(), sc, isDemon));
        if (reportProduct.getClient() != null && (client = EntityStorageHelper.resolve(clientOrganizationReference, (EntityStorageContext)sc)) != null) {
            for (Metadata metadata : ((Organization)client.getEntity()).getMetadata()) {
                if (!"KEY_ORGANIZATION_ACCOUNT_MANAGER".equals(metadata.getKey().getCode())) continue;
                reportProduct.getAccountManagers().add(this.getAccountManager(metadata, product, sc, isDemon));
            }
        }
        StringBuilder accountManagersList = new StringBuilder();
        for (ReportProductAccountManager manager : reportProduct.getAccountManagers()) {
            if (!TextUtil.isBlank((String)accountManagersList.toString())) {
                accountManagersList.append(", ");
            }
            accountManagersList.append(!TextUtil.isBlank((String)manager.getEmployee().getCaption()) ? manager.getEmployee().getCaption() : "*");
        }
        reportProduct.setAccountManagersList(accountManagersList.toString());
        EntityContainer clientCtr = EntityStorageHelper.resolve((EntityReference)product.getReservation().getBookingFile().getCustomerProfile(), (EntityStorageContext)sc);
        if (isDemon.booleanValue()) {
            reportProduct.setHolding(clientCtr == null ? new RestEntityReference() : RestReportsHelper.convertReference(this.actualize(((Organization)clientCtr.getEntity()).getHolding()), RestReportsHelper.holdingNameGetter((EntityReference<Holding>)((Organization)clientCtr.getEntity()).getHolding(), sc)));
            reportProduct.setCompanyGroup(clientCtr == null ? new RestEntityReference() : RestReportsHelper.convertReference(this.actualize(((Organization)clientCtr.getEntity()).getCompanyGroup()), RestReportsHelper.companyGroupNameGetter((EntityReference<CompanyGroup>)((Organization)clientCtr.getEntity()).getCompanyGroup(), sc)));
        } else {
            reportProduct.setHolding(RestReportsHelper.convertReference(this.actualize(clientCtr != null ? ((Organization)clientCtr.getEntity()).getHolding() : null)));
            reportProduct.setCompanyGroup(RestReportsHelper.convertReference(this.actualize(clientCtr != null ? ((Organization)clientCtr.getEntity()).getCompanyGroup() : null)));
        }
        ProductStatus productStatus = handler.getStatus(product);
        String productStatusString = (productStatus != null ? productStatus : ProductStatus.BOOKING).name();
        reportProduct.setStatus(productStatusString);
        reportProduct.setOperation(productStatusString);
        reportProduct.setIssueDate(handler.findIssueDate(product) == null ? "" : dateFormat.format(MiscUtil.toLocalDate((Date)handler.findIssueDate(product))));
        reportProduct.setFirstServiceDate(handler.findFirstTravelDate(product) == null ? "" : dateFormat.format(MiscUtil.toLocalDate((Date)handler.findFirstTravelDate(product))));
        reportProduct.setLastServiceDate(handler.findLastTravelDate(product) == null ? "" : dateFormat.format(MiscUtil.toLocalDate((Date)handler.findLastTravelDate(product))));
        reportProduct.setBookingDate(product.getReservation().getResDate() == null ? "" : dateFormat.format(MiscUtil.toLocalDate((Date)product.getReservation().getResDate())));
        reportProduct.setCreationDate(product.getReservation().getBookingFile().getCreateDate() == null ? "" : dateFormat.format(MiscUtil.toLocalDate((Date)product.getReservation().getBookingFile().getCreateDate())));
        ArrayList travellerNames = new ArrayList();
        ArrayList travellerEnglishNames = new ArrayList();
        ArrayList travellerRussianNames = new ArrayList();
        handler.getTravellers(product).forEach(it -> {
            String name = RestReportsHelper.getTravellerName(isDemon, it, (EntityReference<Person>)it.getPassenger());
            if (name != null) {
                travellerNames.add(name);
            }
            if ((name = RestReportsHelper.getTravellerName(it, (EntityReference<Person>)it.getPassenger(), false)) != null) {
                travellerRussianNames.add(name);
            }
            if ((name = RestReportsHelper.getTravellerName(it, (EntityReference<Person>)it.getPassenger(), true)) != null) {
                travellerEnglishNames.add(name);
            }
            if (XreportsIntegrationHelper.isSendPersonalDataAllowed()) {
                String iin = handler.getTravellers(product).stream().findFirst().map(pers -> EntityStorageHelper.resolve((EntityReference)pers.getPassenger(), (EntityStorageContext)sc)).map(persCtr -> ((Person)persCtr.getEntity()).getRegistrationIdKz()).orElse("");
                reportProduct.setIin(iin);
            }
        });
        reportProduct.setPassengerNames(travellerNames.isEmpty() ? "" : TextUtil.join((String)",", travellerNames));
        reportProduct.setPassengerEnglishNames(travellerEnglishNames.isEmpty() ? "" : TextUtil.join((String)",", travellerEnglishNames));
        reportProduct.setPassengerRussianNames(travellerRussianNames.isEmpty() ? "" : TextUtil.join((String)",", travellerRussianNames));
        int travellersCount = handler.getTravellers(product).size();
        if (travellersCount > Short.MAX_VALUE) {
            throw Xeption.forAdmin((String)Messages.COUNT_OF_ROOMS_TRAVELLERS_BIG, (Object[])new Object[]{String.join((CharSequence)", ", handler.getProductNumbers(product)), product.getReservation().getBookingFile().getNumber(), travellersCount});
        }
        reportProduct.setTravellersCount(travellersCount);
        if (isDemon.booleanValue()) {
            reportProduct.setSubagency(RestReportsHelper.convertReference(this.actualize(GeneralProductHelper.getSubagency((BaseProduct)product)), RestReportsHelper.organizationNameGetter((EntityReference<Organization>)GeneralProductHelper.getSubagency((BaseProduct)product), sc)));
            reportProduct.setAgency(RestReportsHelper.convertReference(this.actualize(GeneralProductHelper.getAgency((BaseProduct)product)), RestReportsHelper.organizationNameGetter((EntityReference<Organization>)GeneralProductHelper.getAgency((BaseProduct)product), sc)));
            reportProduct.setSupplier(RestReportsHelper.convertReference(this.actualize(GeneralProductHelper.getSupplier((BaseProduct)product)), RestReportsHelper.organizationNameGetter((EntityReference<Organization>)GeneralProductHelper.getSupplier((BaseProduct)product), sc)));
        } else {
            reportProduct.setSubagency(RestReportsHelper.convertReference(this.actualize(GeneralProductHelper.getSubagency((BaseProduct)product))));
            reportProduct.setAgency(RestReportsHelper.convertReference(this.actualize(GeneralProductHelper.getAgency((BaseProduct)product))));
            reportProduct.setSupplier(RestReportsHelper.convertReference(this.actualize(GeneralProductHelper.getSupplier((BaseProduct)product))));
        }
        Optional.ofNullable(this.actualize(GeneralProductHelper.getSupplier((BaseProduct)product))).flatMap(s -> Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)s, (EntityStorageContext)sc))).ifPresent(o -> {
            L10nString name;
            L10nString l10nString = name = ((Organization)o.getEntity()).getFullName() != null ? ((Organization)o.getEntity()).getFullName() : ((Organization)o.getEntity()).getShortName();
            if (name != null && name.toString() != null) {
                Locale lfLocale;
                LegalForm legalForm = ((Organization)o.getEntity()).getLegalForm() != null ? (LegalForm)DictHelper.resolve((DictionaryReference)((Organization)o.getEntity()).getLegalForm()) : null;
                Locale locale = lfLocale = legalForm != null ? (Locale)legalForm.getAbbreviations().keySet().stream().filter(l -> TextUtil.equals((String)l.getLanguage(), (String)(isDemon != false ? LocaleHelper.EN_LOCALE.getLanguage() : LocaleHelper.getCurrentLocale().getLanguage()), (boolean)false)).findFirst().orElse(null) : null;
                reportProduct.setNameCarrier(legalForm != null && lfLocale != null && TextUtil.nonBlank((String)((String)legalForm.getAbbreviations().get(lfLocale))) ? (String)legalForm.getAbbreviations().get(lfLocale) + " " + name : (isDemon != false ? name.toString(LocaleHelper.EN_LOCALE) : name.toString()));
            }
            if (!TextUtil.isBlank((String)((Organization)o.getEntity()).getRegistrationId())) {
                reportProduct.setInnCarrier(((Organization)o.getEntity()).getRegistrationId());
            }
            if (!TextUtil.isBlank((String)((Organization)o.getEntity()).getKpp())) {
                reportProduct.setKppCarrier(((Organization)o.getEntity()).getKpp());
            }
            if (!TextUtil.isBlank((String)((Organization)o.getEntity()).getBin())) {
                reportProduct.setBinCarrier(((Organization)o.getEntity()).getBin());
            }
        });
        reportProduct.setBaseFare(reportProduct.getEquivalentFare());
        reportProduct.setRouteLine(handler.getLocalizedRouteLine(product));
        if (reportProduct.getRouteLine() == null) {
            reportProduct.setRouteLine("");
        }
        reportProduct.setFullRouteLine(reportProduct.getRouteLine());
        TransportationType transportationType = handler.getTransportationType(product);
        reportProduct.setRegionType((transportationType == TransportationType.DOMESTIC ? RegionType.DOMESTIC : (transportationType == null || transportationType == TransportationType.NONE ? RegionType.UNKNOWN : RegionType.FOREIGN)).name());
        ReportRestHotel reportRestHotel = new ReportRestHotel();
        reportProduct.setHotel(reportRestHotel);
        Optional.ofNullable(product.getVendorFinanceDocumentsData()).flatMap(fds -> fds.stream().filter(fd -> FinanceDocumentType.INVOICE_FACTURA == fd.getType()).findFirst()).ifPresent(inv -> {
            if (inv.getNumber() != null) {
                reportProduct.setInvoiceFacturaNumber(inv.getNumber());
            }
            reportProduct.setInvoiceFacturaDate(inv.getDate() == null ? "" : dateFormat.format(MiscUtil.toLocalDate((Date)inv.getDate())));
        });
        reportProduct.setRaketaId(product.getReservation().getBookingFile().getExternalCodes().stream().filter(externalCode -> "RAKETA".equals(externalCode.getSystem().getCode())).findFirst().map(ExternalSystemCodeV2::getCode).orElseGet(() -> Optional.ofNullable(product.getReservation().getBookingFile().getExternalCode()).filter(externalCode -> ExternalSystem.RAKETA.equals((Object)externalCode.getSystem())).map(ExternalSystemCode::getCode).orElse("")));
        reportProduct.setCorteosId(Optional.ofNullable(product.getReservation().getBookingFile().getCorteosSettings()).map(CorteosBookingFileData::getCorteosId).map(String::valueOf).orElse(""));
        BookingFile bookingFile = product.getReservation().getBookingFile();
        reportProduct.setCreatedByClient(BookingHelper.isCreatedByClient((Reservation)((Reservation)bookingFile.getReservations().get(0))));
        reportProduct.setOnlineReservation(ReportProductCommonFieldsProcessor.isOnlineReservation(product));
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER);
        ReportProductCommonFieldsProcessor.getItineraryReceiptName((EntityReference<BookingFile>)bookingCtr.toReference(), product, sc).ifPresent(arg_0 -> ((ReportProduct)reportProduct).setItineraryReceiptName(arg_0));
        reportProduct.setBusinessTripNumber(ReportProductCommonFieldsProcessor.getBusinessTrip((EntityReference<BookingFile>)bookingCtr.toReference()));
        BookingAgent bookingAgent = new BookingAgent();
        reportProduct.setBookingAgent(bookingAgent);
        EntityReference<Person> agent = this.actualize(ReportProductCommonFieldsProcessor.getBookingAgent(product));
        if (agent != null) {
            bookingAgent.setUid(agent.getUid());
            bookingAgent.setCaption(RestReportsHelper.getPersonName(agent, isDemon));
            reportProduct.setBookingAgentEmail(this.getEmail(agent, sc));
            reportProduct.setBookingAgentPhone(this.getPhone(agent, sc));
        }
        reportProduct.setRecordLocator(ReportProductCommonFieldsProcessor.getRecordLocator(product));
        reportProduct.setTravelPolicy(ReportProductCommonFieldsProcessor.getTravelPolicy(product));
        reportProduct.setSalesDepth(ReportProductCommonFieldsProcessor.getSalesDepth(product));
        reportProduct.setSelfBookingEconomy(ReportProductCommonFieldsProcessor.calculateMeasure(ReportProductCommonFieldsProcessor.getSelfBookingEconomy(product), product));
        EntityReference customerProfile = bookingFile.getCustomerProfile();
        String afsSettings = null;
        if (customerProfile != null && (resolve = EntityStorageHelper.resolve((EntityReference)customerProfile, (EntityStorageContext)sc)) != null && resolve.getEntity() != null) {
            afsSettings = ((Organization)resolve.getEntity()).getAfsSettings();
            if (((Organization)resolve.getEntity()).getCalculatedStatisticSettings() != null && !((Organization)resolve.getEntity()).getCalculatedStatisticSettings().isEmpty()) {
                reportProduct.getPriceParameters().addAll(ReportProductCommonFieldsProcessor.getPriceParametersCalculatedStatisticType(((Organization)resolve.getEntity()).getCalculatedStatisticSettings(), product));
            }
        }
        if (afsSettings != null) {
            reportProduct.getPriceParameters().addAll(ReportProductCommonFieldsProcessor.getPriceParametersAFSType(StatisticsHelper.getAfsTypesFromString(afsSettings, (boolean)true), product, true));
            reportProduct.getPriceParameters().addAll(ReportProductCommonFieldsProcessor.getPriceParametersAFSType(StatisticsHelper.getAfsTypesFromString((String)afsSettings, (boolean)false), product, false));
        }
        LinkedHashSet fopTypes = new LinkedHashSet();
        GeneralProductHelper.getClientFops((BaseProduct)product).forEach(it -> {
            if (it.getType() != null && it.getType() != PaymentType.TICKET) {
                fopTypes.add(isDemon != false ? it.getType().toString(LocaleHelper.EN_LOCALE) : it.getType().toString());
            }
        });
        reportProduct.setPaymentTypes(CollectionUtil.collectionToString(fopTypes, (String)",", (boolean)true));
        reportProduct.setRelatedProducts(this.getRelatedProducts(product));
        this.setShipmentParameters(reportProduct, product, sc);
        this.setNotInvoicedSum(reportProduct, product, sc);
        reportProduct.setShipmentRelated(ShipmentHelper.hasRelatedShipment((BaseProduct)product));
        EnumWrapper mcoCategoryWrapper = new EnumWrapper();
        mcoCategoryWrapper.setName("");
        mcoCategoryWrapper.setCaption("");
        reportProduct.setMcoCategory(mcoCategoryWrapper);
        EnumWrapper wrapper = new EnumWrapper();
        wrapper.setName("");
        wrapper.setCaption("");
        reportProduct.setAdditionalServiceCategory(wrapper);
        ReservationType reservationType = product.getReservation().getType();
        EnumWrapper reservationTypeWrapper = new EnumWrapper();
        reservationTypeWrapper.setName(Optional.ofNullable(reservationType).map(Enum::name).orElse(""));
        reservationTypeWrapper.setCaption(Optional.ofNullable(reservationType).map(e -> e.toString(isDemon != false ? LocaleHelper.EN_LOCALE : LocaleHelper.RU_LOCALE)).orElse(""));
        reportProduct.setReservationType(reservationTypeWrapper);
        GdsName gdsName = CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)product.getReservation());
        EnumWrapper gdsNameWrapper = new EnumWrapper();
        gdsNameWrapper.setName(Optional.ofNullable(gdsName).map(Enum::name).orElse(""));
        gdsNameWrapper.setCaption(Optional.ofNullable(gdsName).map(e -> e.toString(isDemon != false ? LocaleHelper.EN_LOCALE : LocaleHelper.RU_LOCALE)).orElse(""));
        reportProduct.setGdsName(gdsNameWrapper);
        OnlineReservationCategory onlineReservationCategory = this.getOnlineReservationCategory(product, (ProductHandler<BaseProduct>)handler, sc);
        EnumWrapper onlineReservationCategoryWrapper = new EnumWrapper();
        onlineReservationCategoryWrapper.setName(Optional.of(onlineReservationCategory).map(Enum::name).orElse(""));
        onlineReservationCategoryWrapper.setCaption(Optional.of(onlineReservationCategory).map(orc -> {
            if (isDemon.booleanValue()) {
                switch (orc) {
                    case OFFLINE: {
                        return "Offline reservation";
                    }
                    case ONLINE_NO_TOUCH: {
                        return "Online (no touch) reservation";
                    }
                    case ONLINE_LOW_TOUCH: {
                        return "Online (low touch) reservation";
                    }
                }
                return "";
            }
            return orc.toString();
        }).orElse(""));
        reportProduct.setOnlineReservationCategory(onlineReservationCategoryWrapper);
        if (bookingFile.getCustomer() != null && bookingFile.getCustomer().getKeyContact() != null) {
            KeyContact keyContact = bookingFile.getCustomer().getKeyContact();
            Optional.ofNullable(keyContact.getProfile()).ifPresent(value -> reportProduct.setKeyContactProfile(isDemon != false ? RestReportsHelper.convertReference(value, RestReportsHelper.personNameGetter((EntityReference<Person>)value, sc)) : RestReportsHelper.convertReference(value)));
            Optional.ofNullable(keyContact.getMail()).ifPresent(arg_0 -> ((ReportProduct)reportProduct).setKeyContactEmail(arg_0));
            Optional.ofNullable(keyContact.getPhone()).ifPresent(arg_0 -> ((ReportProduct)reportProduct).setKeyContactPhone(arg_0));
        }
        EnumWrapper wrapper2 = new EnumWrapper();
        wrapper2.setName("");
        wrapper2.setCaption("");
        reportProduct.setOrganizationClient(wrapper2);
        reportProduct.setDocumentNumber("");
        GeneralProductHelper.getClientFops((BaseProduct)product).stream().filter(it -> it.getType() == PaymentType.MTD || it.getType() == PaymentType.MTD_AGENCY).findFirst().ifPresent(it -> {
            EnumWrapper organizationClientWrapper = new EnumWrapper();
            organizationClientWrapper.setName(Optional.ofNullable(it.getPassengerStatus()).map(Enum::name).orElse(""));
            organizationClientWrapper.setCaption(Optional.ofNullable(it.getPassengerStatus()).map(e -> e.toString(isDemon != false ? LocaleHelper.EN_LOCALE : LocaleHelper.RU_LOCALE)).orElse(""));
            reportProduct.setOrganizationClient(organizationClientWrapper);
            reportProduct.setDocumentNumber(Optional.ofNullable(it.getRelatedTicketNumber()).orElse(""));
        });
        reportProduct.setContract3D(false);
        this.setRefundDeduction(reportProduct, product);
        this.setOnHoldSum(reportProduct, product);
    }

    private void setRefundDeduction(ReportProduct reportProduct, BaseProduct product) {
        Product prevProduct;
        if (GeneralProductHelper.getHandler((BaseProduct)product).getStatus(product) != ProductStatus.REFUND) {
            return;
        }
        if (product instanceof Product) {
            prevProduct = ((Product)product).getPreviousProduct();
        } else if (product instanceof RailwayProduct) {
            prevProduct = ((RailwayProduct)product).getPreviousProduct();
        } else if (product instanceof HotelProduct) {
            prevProduct = ((HotelProduct)product).getPreviousProduct();
        } else if (product instanceof VisaProduct) {
            prevProduct = ((VisaProduct)product).getPreviousProduct();
        } else if (product instanceof UniversalProduct) {
            prevProduct = ((UniversalProduct)product).getPreviousProduct();
        } else if (product instanceof Transfer) {
            prevProduct = ((Transfer)product).getPreviousProduct();
        } else if (product instanceof TaxiProduct) {
            prevProduct = ((TaxiProduct)product).getPreviousProduct();
        } else if (product instanceof RailwayMcoProduct) {
            prevProduct = ((RailwayMcoProduct)product).getPreviousProduct();
        } else if (product instanceof RailwayCrimeaMco) {
            prevProduct = ((RailwayCrimeaMco)product).getPreviousProduct();
        } else if (product instanceof MCOFees) {
            prevProduct = ((MCOFees)product).getPreviousMCO();
        } else if (product instanceof InsuranceTouristic) {
            prevProduct = ((InsuranceTouristic)product).getPreviousProduct();
        } else if (product instanceof InsuranceAccident) {
            prevProduct = ((InsuranceAccident)product).getPreviousProduct();
        } else if (product instanceof Delivery) {
            prevProduct = ((Delivery)product).getPreviousProduct();
        } else if (product instanceof CarRentalProduct) {
            prevProduct = ((CarRentalProduct)product).getPreviousProduct();
        } else if (product instanceof AeroexpressTicket) {
            prevProduct = ((AeroexpressTicket)product).getPreviousProduct();
        } else if (product instanceof BusProduct) {
            prevProduct = ((BusProduct)product).getPreviousProduct();
        } else {
            return;
        }
        if (prevProduct == null) {
            return;
        }
        XtripPriceStructure xtripPriceStructure = XtripPriceStructureHelper.calculatePriceStructure((BaseProduct)prevProduct, (boolean)false);
        reportProduct.setRefundDeduction(MiscUtil.sub((BigDecimal)MiscUtil.sum((BigDecimal[])new BigDecimal[]{reportProduct.getPrice(), xtripPriceStructure.getProductPrice()}), (BigDecimal[])new BigDecimal[]{reportProduct.getEffectivePenalty()}));
    }

    private void setOnHoldSum(ReportProduct reportProduct, BaseProduct product) {
        EntityReference subagency = GeneralProductHelper.getSubagency((BaseProduct)product);
        EntityReference organization = subagency == null || subagency.equals((Object)GeneralProductHelper.getAgency((BaseProduct)product)) ? product.getReservation().getBookingFile().getCustomerProfile() : subagency;
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.organization.name(), (Object)organization));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.type.name(), (Object)ChartOfAccountsElementType.SUPPLIER_HOLD_SERVICE));
        Object[] uids = EntityStorage.get().search(ChartOfAccountsElementIndex.class, query).getData().stream().map(ChartOfAccountsElementIndex::getSource).filter(Objects::nonNull).map(EntityReference::getUid).toArray();
        if (uids.length == 0) {
            return;
        }
        SearchQuery query2 = new SearchQuery();
        query2.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.organization.name(), (Object)organization));
        query2.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.productUid.name(), (Object)product.getUid()));
        query2.getCriteria().getCriterions().add(SearchCriterion.in((String)TransactionSplitIndex.Property.accountUid.name(), (Object[])uids));
        List indices = EntityStorage.get().search(TransactionSplitIndex.class, query2).getData();
        reportProduct.setOnHoldSum(indices.stream().map(t -> ModelHelper.long2BigDecimal((long)t.getAmount())).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
    }

    private String getReasonCode(BaseProduct product) {
        ReasonCode reasonCode;
        String result = null;
        ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)product);
        if (handler != null && handler.getStatisticalData(product) != null && (reasonCode = (ReasonCode)handler.getStatisticalData(product).getReasonCodes().stream().filter(Objects::nonNull).filter(code -> code.getComparisonType() != null).filter(code -> code.getComparisonType().equals((Object)ReasonCodeComparisonType.AFS)).findFirst().orElse(null)) != null && reasonCode.getName() != null) {
            result = L10nStringHelper.getValue((L10nString)reasonCode.getRemarks(), (Locale)LocaleHelper.getLocale((String)"RU"), (boolean)false);
        }
        return result == null ? "" : result;
    }

    private BigDecimal calculateTaxAmount(List<SimpleTax> taxes) {
        return taxes.stream().map(SimpleTax::getAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private BigDecimal calculateFee(Collection<GeneralProductCommission> commissions, ReportFeeCategoryType category, boolean strict, EntityStorageContext sc) {
        return commissions.stream().filter(comm -> category == this.getFeeCategory((EntityReference<? extends BaseCommissionProperties>)comm.getCommissionProperties(), strict, sc)).map(c -> MiscUtil.guarded((BigDecimal)c.getEquivalentAmount())).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private ReportFeeCategoryType getFeeCategory(EntityReference<? extends BaseCommissionProperties> commissionProperties, boolean strict, EntityStorageContext sc) {
        EntityContainer propCtr = EntityStorageHelper.resolve(commissionProperties, (EntityStorageContext)sc);
        if (propCtr == null) {
            return ReportFeeCategoryType.CATEGORY_1;
        }
        FeeProperties feeProp = (FeeProperties)propCtr.getEntity();
        CommissionCategory commissionCategory = (CommissionCategory)DictionaryCache.get().resolveReference(feeProp.getCategory());
        if (!(commissionCategory != null && commissionCategory.getReportFeeCategoryType() != null || strict)) {
            return ReportFeeCategoryType.CATEGORY_1;
        }
        return commissionCategory == null ? null : commissionCategory.getReportFeeCategoryType();
    }

    private String getRelatedProducts(BaseProduct product) {
        ArrayList result = new ArrayList();
        ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
        if (handler != null && handler.getMCOCategory(product) == null) {
            List products = product.getReservation().getProducts();
            for (BaseProduct bp : products) {
                ProductHandler handlerbp;
                if (bp.getUid().equals(product.getUid()) || (handlerbp = HandlersRegistry.get().findProductHandler(bp.getClass())).getRelatedProducts(bp).isEmpty() || !((BaseProduct)handlerbp.getRelatedProducts(bp).get(0)).getUid().equals(product.getUid()) || handlerbp.getMCOCategory(bp) == null) continue;
                result.addAll(handlerbp.getProductNumbers(bp));
            }
        }
        return !result.isEmpty() ? String.join((CharSequence)", ", result) : "";
    }

    private OnlineReservationCategory getOnlineReservationCategory(BaseProduct product, ProductHandler<BaseProduct> handler, EntityStorageContext sc) {
        EntityContainer bookingAgent;
        OnlineReservationCategory onlineReservationCategory = OnlineReservationCategory.OFFLINE;
        if (!ProductStatus.REFUND.equals((Object)handler.getStatus(product)) && (bookingAgent = EntityStorageHelper.resolve((EntityReference)product.getReservation().getBookingAgent(), (EntityStorageContext)sc)) != null) {
            EntityContainer issuingAgent;
            EntityContainer organization;
            Optional<EntityReference> bookingOrganization = ProfileHelper.getEmploymentsRefs((Person)((Person)bookingAgent.getEntity()), (boolean)true, (Date)handler.findIssueDate(product)).stream().filter(emp -> !ProfileHelper.isRetailProfile((EntityReference)emp)).findFirst();
            if (!bookingOrganization.isPresent()) {
                bookingOrganization = ProfileHelper.getEmploymentsRefs((Person)((Person)bookingAgent.getEntity()), (boolean)false, (Date)handler.findIssueDate(product)).stream().filter(emp -> !ProfileHelper.isRetailProfile((EntityReference)emp)).findFirst();
            }
            if (bookingOrganization.isPresent() && (organization = EntityStorageHelper.resolve((EntityReference)bookingOrganization.get(), (EntityStorageContext)sc)) != null && !((Organization)organization.getEntity()).getTypes().contains(OrganizationType.AGENCY) && (issuingAgent = EntityStorageHelper.resolve((EntityReference)handler.findIssuingAgent(product), (EntityStorageContext)sc)) != null) {
                Optional<EntityReference> issuingOrganization = ProfileHelper.getEmploymentsRefs((Person)((Person)issuingAgent.getEntity()), (boolean)true, (Date)product.getReservation().getResDate()).stream().filter(emp -> !ProfileHelper.isRetailProfile((EntityReference)emp)).findFirst();
                if (!issuingOrganization.isPresent()) {
                    issuingOrganization = ProfileHelper.getEmploymentsRefs((Person)((Person)issuingAgent.getEntity()), (boolean)false, (Date)product.getReservation().getResDate()).stream().filter(emp -> !ProfileHelper.isRetailProfile((EntityReference)emp)).findFirst();
                }
                if (issuingOrganization.isPresent() && (organization = EntityStorageHelper.resolve((EntityReference)issuingOrganization.get(), (EntityStorageContext)sc)) != null) {
                    onlineReservationCategory = ((Organization)organization.getEntity()).getTypes().contains(OrganizationType.AGENCY) ? OnlineReservationCategory.ONLINE_LOW_TOUCH : OnlineReservationCategory.ONLINE_NO_TOUCH;
                }
            }
        }
        return onlineReservationCategory;
    }

    private void setShipmentParameters(ReportProduct reportProduct, BaseProduct product, EntityStorageContext sc) {
        if (!product.getFopDetalizations().isEmpty()) {
            HashSet numbers = new HashSet();
            product.getFopDetalizations().values().stream().flatMap(detalization -> detalization.getComponents().stream()).forEach(component -> {
                EntityContainer ec = EntityStorageHelper.resolve((EntityReference)component.getShipment(), (EntityStorageContext)sc);
                if (ec != null) {
                    Shipment shipment = (Shipment)ec.getEntity();
                    if (numbers.isEmpty()) {
                        reportProduct.setShipmentDate(shipment.getDate() != null ? dateFormat.format(MiscUtil.toLocalDate((Date)shipment.getDate())) : "");
                        reportProduct.setShipmentPayed(ShipmentHelper.isShipmentPayed((Shipment)shipment, (EntityStorageContext)sc));
                    }
                    numbers.add(shipment.getNumber());
                }
            });
            reportProduct.setShipmentNumber(String.join((CharSequence)", ", numbers));
            BigDecimal shipmentSum = product.getFopDetalizations().entrySet().stream().filter(entry -> ReportProductCommonFieldsProcessor.getFopsBySalesChain(product, sc).stream().anyMatch(fop -> TextUtil.equals((String)fop.getUid(), (String)((String)entry.getKey()), (boolean)false))).map(Map.Entry::getValue).flatMap(detalization -> detalization.getComponents().stream()).filter(fopComponent -> Objects.nonNull(fopComponent.getShipment())).map(FopComponent::getAmount).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(BigDecimal.ZERO);
            reportProduct.setShipmentSum(ReportProductCommonFieldsProcessor.calculateMeasure(shipmentSum, product));
        }
        if (reportProduct.getShipmentDate() == null) {
            reportProduct.setShipmentDate("");
        }
        if (reportProduct.getShipmentNumber() == null) {
            reportProduct.setShipmentNumber("");
        }
        if (reportProduct.getShipmentSum() == null) {
            reportProduct.setShipmentSum(BigDecimal.ZERO);
        }
    }

    private void setNotInvoicedSum(ReportProduct reportProduct, BaseProduct product, EntityStorageContext sc) {
        BigDecimal sum = BigDecimal.ZERO;
        List fopKeys = ReportProductCommonFieldsProcessor.getFopsBySalesChain(product, sc).stream().filter(fop -> PaymentType.TICKET != fop.getType()).map(BaseIdentity::getUid).collect(Collectors.toList());
        if (!product.getFopDetalizations().isEmpty()) {
            sum = product.getFopDetalizations().entrySet().stream().filter(entry -> fopKeys.contains(entry.getKey())).map(Map.Entry::getValue).flatMap(detalization -> detalization.getComponents().stream()).filter(component -> component.getShipment() == null).map(FopComponent::getAmount).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        }
        reportProduct.setNotInvoicedSum(sum);
    }

    private <T extends BaseEntity> EntityReference<T> actualize(EntityReference<T> ettRef) {
        if (ettRef == null) {
            return null;
        }
        return EntityStorage.get().actualize(ettRef, new EntityStorageActualizeParameters().useRemoteCallIfNecessary(true));
    }

    public static String getFullCaption(EntityReference<Organization> ref, EntityStorageContext sc, boolean isDemon) {
        Organization org;
        if (ref == null) {
            return "";
        }
        EntityContainer resolve = EntityStorageHelper.resolve(ref, (EntityStorageContext)sc);
        if (resolve != null && (org = (Organization)resolve.getEntity()) != null && org.getFullName() != null) {
            String result = L10nStringHelper.getValue((L10nString)org.getFullName(), (Locale)(isDemon ? LocaleHelper.EN_LOCALE : LocaleHelper.getCurrentLocale()), (boolean)false);
            return TextUtil.nonBlank((String)result) ? result : "";
        }
        return "";
    }

    private static <T extends BaseProduct> Set<PriceParameter> getPriceParametersAFSType(List<AFSType> afs, T product, boolean isTicketing) {
        if (afs == null || afs.isEmpty()) {
            return Collections.emptySet();
        }
        StatisticalData statisticalData = null;
        if (GeneralProductHelper.getHandler(product) != null) {
            statisticalData = GeneralProductHelper.getHandler(product).getStatisticalData(product);
        }
        String afsType = isTicketing ? "_T" : "_B";
        HashSet<PriceParameter> result = new HashSet<PriceParameter>();
        if (statisticalData != null) {
            block14: for (AFSType type : afs) {
                PriceParameter priceParameters = new PriceParameter();
                priceParameters.setName(type.name() + afsType);
                priceParameters.setCode(type.name() + afsType);
                switch (type) {
                    case HBF1: {
                        if (isTicketing) {
                            ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getHbf1Tkt(), priceParameters);
                            break;
                        }
                        ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getHbf1Bkg(), priceParameters);
                        break;
                    }
                    case HBF2: {
                        if (isTicketing) {
                            ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getHbf2Tkt(), priceParameters);
                            break;
                        }
                        ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getHbf2Bkg(), priceParameters);
                        break;
                    }
                    case ATF1: {
                        if (isTicketing) {
                            ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getAtf1Tkt(), priceParameters);
                            break;
                        }
                        ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getAtf1Bkg(), priceParameters);
                        break;
                    }
                    case ATF2: {
                        if (isTicketing) {
                            ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getAtf2Tkt(), priceParameters);
                            break;
                        }
                        ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getAtf2Bkg(), priceParameters);
                        break;
                    }
                    case LAF1: {
                        if (isTicketing) {
                            ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getLaf1Tkt(), priceParameters);
                            break;
                        }
                        ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getLaf1Bkg(), priceParameters);
                        break;
                    }
                    case LAF2: {
                        if (isTicketing) {
                            ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getLaf2Tkt(), priceParameters);
                            break;
                        }
                        ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getLaf2Bkg(), priceParameters);
                        break;
                    }
                    case LAF3: {
                        if (isTicketing) {
                            ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getLaf3Tkt(), priceParameters);
                            break;
                        }
                        ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getLaf3Bkg(), priceParameters);
                        break;
                    }
                    case LPF1: {
                        if (isTicketing) {
                            ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getLpf1Tkt(), priceParameters);
                            break;
                        }
                        ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getLpf1Bkg(), priceParameters);
                        break;
                    }
                    case LPF2: {
                        if (isTicketing) {
                            ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getLpf2Tkt(), priceParameters);
                            break;
                        }
                        ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getLpf2Bkg(), priceParameters);
                        break;
                    }
                    case LPF3: {
                        if (isTicketing) {
                            ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getLpf3Tkt(), priceParameters);
                            break;
                        }
                        ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getLpf3Bkg(), priceParameters);
                        break;
                    }
                    case P3D: {
                        if (isTicketing) {
                            ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getP3dTkt(), priceParameters);
                            break;
                        }
                        ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getP3dBkg(), priceParameters);
                        break;
                    }
                    case CTF: {
                        if (isTicketing) {
                            ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getCtfTkt(), priceParameters);
                            break;
                        }
                        ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getCtfBkg(), priceParameters);
                        break;
                    }
                    default: {
                        continue block14;
                    }
                }
                result.add(priceParameters);
            }
        }
        return result;
    }

    static <P extends BaseProduct> BigDecimal calculateMeasure(BigDecimal measure, P product) {
        ProductStatus status = GeneralProductHelper.getStatus(product);
        if (status == null) {
            return BigDecimal.ZERO;
        }
        if (ProductStatusHandler.getAllVoidStatuses().contains(status)) {
            return BigDecimal.ZERO;
        }
        if (status == ProductStatus.EXCHANGE || status == ProductStatus.REFUND) {
            return MiscUtil.guarded((BigDecimal)measure).negate();
        }
        return MiscUtil.guarded((BigDecimal)measure);
    }

    private static BigDecimal extractVat(BaseProduct product, EntityStorageContext sc, FopComponentType ... ownFees) {
        BigDecimal result = BigDecimal.ZERO;
        List<GeneralProductFop> fops = ReportProductCommonFieldsProcessor.getFopsBySalesChain(product, sc);
        for (GeneralProductFop fop : fops) {
            FopDetalization detalization = (FopDetalization)product.getFopDetalizations().get(fop.getUid());
            if (detalization == null) continue;
            block1: for (FopComponent comp : detalization.getComponents()) {
                for (FopComponentType fct : ownFees) {
                    if (fct != comp.getType() || comp.isHidden()) continue;
                    result = result.add(MiscUtil.guarded((BigDecimal)comp.getVatAmount()));
                    continue block1;
                }
            }
        }
        return result;
    }

    private static BigDecimal extractHiddenVat(BaseProduct product, EntityStorageContext sc, FopComponentType ... ownFees) {
        BigDecimal result = BigDecimal.ZERO;
        List<GeneralProductFop> fops = ReportProductCommonFieldsProcessor.getFopsBySalesChain(product, sc);
        for (GeneralProductFop fop : fops) {
            FopDetalization detalization = (FopDetalization)product.getFopDetalizations().get(fop.getUid());
            if (detalization == null) continue;
            block1: for (FopComponent comp : detalization.getComponents()) {
                for (FopComponentType fct : ownFees) {
                    if (fct != comp.getType() || !comp.isHidden()) continue;
                    result = result.add(MiscUtil.guarded((BigDecimal)comp.getVatAmount()));
                    continue block1;
                }
            }
        }
        return result;
    }

    private static <T extends BaseProduct> boolean isOnlineReservation(T product) {
        if (product.getReservation() != null) {
            ReservationType type = product.getReservation().getType();
            return type == ReservationType.INTERNET || type == ReservationType.IBE || type == ReservationType.CORTEOS;
        }
        return false;
    }

    private static String getBusinessTrip(EntityReference<BookingFile> bookingFile) {
        SearchQuery searchQuery = new SearchQuery();
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.contains((String)BusinessTripIndex.Property.bookingFiles.name(), (Object)bookingFile.getUid()));
        List data = EntityStorage.get().search(BusinessTripIndex.class, searchQuery).getData();
        return !data.isEmpty() && ((BusinessTripIndex)data.get(0)).getNumber() != null ? ((BusinessTripIndex)data.get(0)).getNumber() : "";
    }

    private static Optional<String> getItineraryReceiptName(EntityReference<BookingFile> bookingFile, BaseProduct product, EntityStorageContext sc) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), (Object)bookingFile.getUid()));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.type.name(), (Object)DocumentType.RECEIPT));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.contentType.name(), (Object)ContentType.JASPERPRINT));
        SearchResult searchResult = EntityStorage.get().search(BasicDocumentIndex.class, query);
        if (searchResult.getTotalCount() > 0) {
            return searchResult.getData().stream().sorted(Comparator.comparing(BasicDocumentIndex::getCreated).reversed()).map(bdi -> EntityStorageHelper.resolve((EntityReference)bdi.getSource(), (EntityStorageContext)sc)).filter(Objects::nonNull).filter(bd -> product.getUid().equals(((BaseFileDocument)bd.getEntity()).getNavigationKey())).map(bd -> ((BaseFileDocument)bd.getEntity()).getName()).filter(Objects::nonNull).findFirst();
        }
        return Optional.empty();
    }

    private static <T extends BaseProduct> EntityReference<Person> getBookingAgent(T product) {
        Reservation reservation = product.getReservation();
        if (reservation != null) {
            return reservation.getBookingAgent();
        }
        return null;
    }

    private static <T extends BaseProduct> String getRecordLocator(T product) {
        Reservation reservation = product.getReservation();
        if (reservation == null) {
            return "";
        }
        return TextUtil.nonNullStr((String)CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation));
    }

    private static <T extends BaseProduct> TravelPolicy getTravelPolicy(T product) {
        TravelPolicy result = new TravelPolicy();
        ProductHandler handler = GeneralProductHelper.getHandler(product);
        StatisticalData statisticalData = handler.getStatisticalData(product);
        if (statisticalData == null) {
            result.setViolation(com.gridnine.xtrip.server.model.rest.reports.TravelPolicyViolationType.NO_VIOLATION);
            result.setAuthorization(false);
            result.setLimit("");
            result.setSalesDepthLimit("");
            return result;
        }
        result.setAuthorization(statisticalData.getTravelPolicyAuthorization() != null ? statisticalData.getTravelPolicyAuthorization() : false);
        if (statisticalData.getTravelPolicyViolation() != null) {
            switch (statisticalData.getTravelPolicyViolation()) {
                case VIOLATION: {
                    result.setViolation(com.gridnine.xtrip.server.model.rest.reports.TravelPolicyViolationType.VIOLATION);
                    break;
                }
                case VIOLATION_STRICT: {
                    result.setViolation(com.gridnine.xtrip.server.model.rest.reports.TravelPolicyViolationType.VIOLATION_STRICT);
                }
            }
        } else {
            result.setViolation(com.gridnine.xtrip.server.model.rest.reports.TravelPolicyViolationType.NO_VIOLATION);
        }
        result.setLimit(statisticalData.getTravelPolicyLimit() == null ? "" : String.valueOf(statisticalData.getTravelPolicyLimit()));
        Integer salesDepthLimit = statisticalData.getTravelPolicySalesDeepsLimit();
        if (salesDepthLimit != null && salesDepthLimit > Short.MAX_VALUE) {
            throw Xeption.forAdmin((String)Messages.SALES_DEPTH_LIMIT_TOO_BIG, (Object[])new Object[]{String.join((CharSequence)", ", handler.getProductNumbers(product)), product.getReservation().getBookingFile().getNumber(), salesDepthLimit});
        }
        result.setSalesDepthLimit(salesDepthLimit == null ? "" : String.valueOf(salesDepthLimit));
        return result;
    }

    private static List<GeneralProductFop> getFopsBySalesChain(BaseProduct product, EntityStorageContext sc) {
        SalesChain salesChain = GeneralProductHelper.getHandler((BaseProduct)product).getSalesChain(product);
        EntityContainer ctr = EntityStorageHelper.resolve((EntityReference)salesChain.getDescription(), (EntityStorageContext)sc);
        PredefinedSalesChainType salesChainType = ctr != null ? ((SalesChainDescription)ctr.getEntity()).getPredefinedType() : null;
        return PredefinedSalesChainType.SUBAGENT == salesChainType ? GeneralProductHelper.getSubagentFops((BaseProduct)product) : GeneralProductHelper.getClientFops((BaseProduct)product);
    }

    private static <T extends BaseProduct> String getSalesDepth(T product) {
        Integer salesDepth;
        ProductHandler handler = GeneralProductHelper.getHandler(product);
        StatisticalData statisticalData = handler.getStatisticalData(product);
        Integer n = salesDepth = statisticalData != null ? statisticalData.getSalesDeeps() : null;
        if (salesDepth != null && salesDepth > Short.MAX_VALUE) {
            throw Xeption.forAdmin((String)Messages.SALES_DEPTH_TOO_BIG, (Object[])new Object[]{String.join((CharSequence)", ", handler.getProductNumbers(product)), product.getReservation().getBookingFile().getNumber(), salesDepth});
        }
        return salesDepth != null ? String.valueOf(salesDepth) : "";
    }

    private static <T extends BaseProduct> BigDecimal getSelfBookingEconomy(T product) {
        StatisticalData statisticalData = GeneralProductHelper.getHandler(product).getStatisticalData(product);
        if (statisticalData == null) {
            return BigDecimal.ZERO;
        }
        return statisticalData.getSelfBookingEconomy() != null ? BigDecimal.valueOf(statisticalData.getSelfBookingEconomy()) : BigDecimal.ZERO;
    }

    private static <T extends BaseProduct> Set<PriceParameter> getPriceParametersCalculatedStatisticType(Set<CalculatedStatisticType> afs, T product) {
        if (afs == null || afs.isEmpty()) {
            return Collections.emptySet();
        }
        StatisticalData statisticalData = null;
        if (GeneralProductHelper.getHandler(product) != null) {
            statisticalData = GeneralProductHelper.getHandler(product).getStatisticalData(product);
        }
        HashSet<PriceParameter> result = new HashSet<PriceParameter>();
        if (statisticalData != null) {
            block11: for (CalculatedStatisticType type : afs) {
                PriceParameter priceParameters = new PriceParameter();
                priceParameters.setName(type.toString());
                priceParameters.setCode(type.name() + "_C");
                switch (type) {
                    case TRAVEL_POLICY_LIMIT: {
                        ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getTravelPolicyLimit(), priceParameters);
                        break;
                    }
                    case MIN_PRICE_PER_ROOM: {
                        ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getMinPricePerRoom(), priceParameters);
                        break;
                    }
                    case SELF_BOOKING_ECONOMY: {
                        ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getSelfBookingEconomy(), priceParameters);
                        break;
                    }
                    case FLIGHT_DURATION: {
                        ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getFlightDuration(), priceParameters);
                        break;
                    }
                    case RACK_RATE_PRICE: {
                        ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getRackRatePrice(), priceParameters);
                        break;
                    }
                    case SALES_DEEPS: {
                        ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getSalesDeeps(), priceParameters);
                        break;
                    }
                    case TRAVEL_POLICY_VIOLATION: {
                        ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getTravelPolicyViolation(), priceParameters);
                        break;
                    }
                    case TRAVEL_POLICY_AUTHORIZATION: {
                        ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getTravelPolicyAuthorization(), priceParameters);
                        break;
                    }
                    case TRAVEL_POLICY_SALES_DEEPS_LIMIT: {
                        ReportProductCommonFieldsProcessor.fillPriceParameters(statisticalData.getTravelPolicySalesDeepsLimit(), priceParameters);
                        break;
                    }
                    default: {
                        continue block11;
                    }
                }
                result.add(priceParameters);
            }
        }
        return result;
    }

    private static void fillPriceParameters(Boolean type, PriceParameter priceParameters) {
        priceParameters.setType(PriceParameterType.BOOLEAN);
        priceParameters.setValue(TextUtil.objToNotNullString((Object)type));
    }

    private static void fillPriceParameters(TravelPolicyViolationType type, PriceParameter priceParameters) {
        priceParameters.setType(PriceParameterType.TRAVEL_POLICY_VIOLATION_TYPE);
        priceParameters.setValue(type == null ? com.gridnine.xtrip.server.model.rest.reports.TravelPolicyViolationType.NO_VIOLATION.toString() : type.toString());
    }

    private static void fillPriceParameters(BigDecimal type, PriceParameter priceParameters) {
        priceParameters.setType(PriceParameterType.BIG_DECIMAL);
        priceParameters.setValue(TextUtil.objToNotNullString((Object)type));
    }

    private static void fillPriceParameters(Double type, PriceParameter priceParameters) {
        priceParameters.setType(PriceParameterType.DOUBLE);
        priceParameters.setValue(type == null ? Double.toString(0.0) : type.toString());
    }

    private static void fillPriceParameters(Integer type, PriceParameter priceParameters) {
        priceParameters.setType(PriceParameterType.DOUBLE);
        priceParameters.setValue(TextUtil.objToNotNullString((Object)type));
    }

    private String getEmail(EntityReference<Person> personRef, EntityStorageContext sc) {
        if (personRef == null) {
            return "";
        }
        EntityContainer personCtr = EntityStorageHelper.resolve(personRef, (EntityStorageContext)sc);
        if (personCtr == null) {
            return "";
        }
        if (((Person)personCtr.getEntity()).getCommunications().isEmpty()) {
            return "";
        }
        String email = "";
        for (PersonCommunication communication : ((Person)personCtr.getEntity()).getCommunications()) {
            if (!CommunicationType.EMAIL.equals((Object)communication.getType()) || TextUtil.isBlank((String)communication.getSense())) continue;
            email = communication.getSense();
        }
        return email;
    }

    private String getPhone(EntityReference<Person> personRef, EntityStorageContext sc) {
        if (personRef == null) {
            return "";
        }
        EntityContainer personCtr = EntityStorageHelper.resolve(personRef, (EntityStorageContext)sc);
        if (personCtr == null) {
            return "";
        }
        if (((Person)personCtr.getEntity()).getCommunications().isEmpty()) {
            return "";
        }
        String phone = "";
        for (PersonCommunication communication : ((Person)personCtr.getEntity()).getCommunications()) {
            if (!CommunicationType.MOBILE.equals((Object)communication.getType())) continue;
            String countryCode = !TextUtil.isBlank((String)communication.getCountryCode()) ? communication.getCountryCode() : "*";
            String cityCode = !TextUtil.isBlank((String)communication.getCityCode()) ? communication.getCityCode() : "*";
            String number = !TextUtil.isBlank((String)communication.getSense()) ? communication.getSense() : "*";
            phone = countryCode + "-" + cityCode + "-" + number;
        }
        return phone;
    }

    private ReportProductAccountManager getAccountManager(Metadata metadata, BaseProduct product, EntityStorageContext sc, boolean isDemon) {
        EntityReference personRef = (EntityReference)metadata.getValue();
        ReportProductAccountManager manager = RestReportsHelper.getReportProductAccountManagerZero();
        if (personRef == null) {
            return manager;
        }
        manager.setComment(RestReportsHelper.checkString(metadata.getRemarks()));
        manager.setEmployee(isDemon ? RestReportsHelper.convertReference(personRef, RestReportsHelper.personNameGetter((EntityReference<Person>)personRef, sc)) : RestReportsHelper.convertReference(personRef));
        manager.setEmail(this.getEmail((EntityReference<Person>)personRef, sc));
        manager.setPhone(this.getPhone((EntityReference<Person>)personRef, sc));
        EntityContainer personCtr = EntityStorageHelper.resolve((EntityReference)personRef, (EntityStorageContext)sc);
        if (personCtr == null) {
            return manager;
        }
        Person person = (Person)personCtr.getEntity();
        if (product.getReservation() != null && product.getReservation().getBookingFile() != null) {
            manager.setBookingFileUid(product.getReservation().getBookingFile().getUid());
        }
        if (person.getEmployments().size() > 1) {
            person.getEmployments().stream().filter(PersonEmployment::isMainEmployment).map(PersonEmployment::getPosition).filter(Objects::nonNull).findFirst().ifPresent(value -> manager.setPosition(RestReportsHelper.convertReference(value, isDemon)));
        } else if (person.getEmployments().size() == 1) {
            manager.setPosition(RestReportsHelper.convertReference(((PersonEmployment)person.getEmployments().get(0)).getPosition(), isDemon));
        }
        return manager;
    }

    private static void populateContractData(BaseProduct product, ReportProduct reportProduct, EntityStorageContext entityStorageContext, boolean isDemon) {
        GeneralProductHelper.getContract((BaseProduct)product, (ContractType)ContractType.CLIENT, (EntityStorageContext)entityStorageContext).ifPresent(clientContract -> {
            reportProduct.setClientContractName(TextUtil.nonNullStr((String)clientContract.getName()));
            reportProduct.setClientContractNumber(TextUtil.nonNullStr((String)clientContract.getNumber()));
            reportProduct.setClientContractType(isDemon ? (clientContract.getAgreementType() == null ? "" : clientContract.getAgreementType().toString(LocaleHelper.EN_LOCALE)) : TextUtil.objToNotNullString((Object)clientContract.getAgreementType()));
            reportProduct.setClientContractStartDate(ReportProductCommonFieldsProcessor.formatDate(clientContract.getStartDate()));
            reportProduct.setClientContractEndDate(ReportProductCommonFieldsProcessor.formatDate(clientContract.getEndDate()));
        });
        GeneralProductHelper.getContract((BaseProduct)product, (ContractType)ContractType.VENDOR, (EntityStorageContext)entityStorageContext).ifPresent(vendorContract -> {
            reportProduct.setVendorContractName(TextUtil.nonNullStr((String)vendorContract.getName()));
            reportProduct.setVendorContractNumber(TextUtil.nonNullStr((String)vendorContract.getNumber()));
            reportProduct.setVendorContractType(isDemon ? (vendorContract.getAgreementType() == null ? "" : vendorContract.getAgreementType().toString(LocaleHelper.EN_LOCALE)) : TextUtil.objToNotNullString((Object)vendorContract.getAgreementType()));
            reportProduct.setVendorContractStartDate(ReportProductCommonFieldsProcessor.formatDate(vendorContract.getStartDate()));
            reportProduct.setVendorContractEndDate(ReportProductCommonFieldsProcessor.formatDate(vendorContract.getEndDate()));
        });
    }

    private static RestTicketType getTicketType(TicketType ticketType) {
        if (ticketType == null) {
            return RestTicketType.UNKNOWN;
        }
        switch (ticketType) {
            case OWN: {
                return RestTicketType.OWN;
            }
            case EXTERNAL: {
                return RestTicketType.EXTERNAL;
            }
            case NOT_OWN: {
                return RestTicketType.NOT_OWN;
            }
            case FAKE: {
                return RestTicketType.FAKE;
            }
            case REFERRAL: {
                return RestTicketType.REFERRAL;
            }
            case CORRECTION: {
                return RestTicketType.CORRECTION;
            }
        }
        return RestTicketType.UNKNOWN;
    }

    private static String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        return dateFormat.format(MiscUtil.toLocalDate((Date)date));
    }
}

