/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports.getBookingFile.products;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.TravellerCostCodes;
import com.gridnine.xtrip.common.model.dict.CostCodeCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.helpers.XreportsIntegrationHelper;
import com.gridnine.xtrip.server.ibecorp.rest.reports.IbusReportsRestContextKeys;
import com.gridnine.xtrip.server.ibecorp.rest.reports.RestReportsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.rest.reports.PriceParameter;
import com.gridnine.xtrip.server.model.rest.reports.ReportCostCode;
import com.gridnine.xtrip.server.model.rest.reports.ReportPassengerData;
import com.gridnine.xtrip.server.model.rest.reports.ReportProduct;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReportProductFillPassengerDataProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Boolean isDemon = (Boolean)ctx.getObject((Enum)IbusReportsRestContextKeys.DEMON_KEY);
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        ReportProduct record = (ReportProduct)ctx.getMandatoryObject((Enum)IbusReportsRestContextKeys.RECORD);
        BaseProduct product = (BaseProduct)ctx.getMandatoryObject((Enum)IBusRestContextKeys.PRODUCT);
        ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)product);
        ArrayList<Traveller> travellers = new ArrayList<Traveller>(handler.getTravellers(product));
        int countPayers = this.getCountPayers(travellers, product, (ProductHandler<BaseProduct>)handler);
        int countAllPassengers = travellers.size();
        for (int n = 0; n < travellers.size(); ++n) {
            TravellerCostCodes travellerCostCodes;
            StatisticalData statisticalData;
            Traveller traveller = (Traveller)travellers.get(n);
            boolean infantWithoutSeat = this.isInfantWithoutSeat(traveller, product, (ProductHandler<BaseProduct>)handler);
            ReportPassengerData data = RestReportsHelper.getPassengersZero();
            record.getPassengers().add(data);
            data.setTravellerUid(String.format("%s_%s", product.getUid(), traveller.getUid()));
            String travellerName = RestReportsHelper.getTravellerName(isDemon, traveller, (EntityReference<Person>)traveller.getPassenger());
            String travellerEnglishName = RestReportsHelper.getTravellerName(traveller, (EntityReference<Person>)traveller.getPassenger(), true);
            String travellerRussianName = RestReportsHelper.getTravellerName(traveller, (EntityReference<Person>)traveller.getPassenger(), false);
            data.setPassengerName(TextUtil.objToNotNullString((Object)travellerName));
            data.setPassengerEnglishName(TextUtil.objToNotNullString((Object)travellerEnglishName));
            data.setPassengerRussianName(TextUtil.objToNotNullString((Object)travellerRussianName));
            if (traveller.getPassport() != null && TextUtil.nonBlank((String)traveller.getPassport().getNumber()) && XreportsIntegrationHelper.isSendPersonalDataAllowed()) {
                data.setPassportNumber(traveller.getPassport().getNumber());
            }
            if (traveller.getPassenger() != null) {
                EntityReference aclRole;
                if (isDemon.booleanValue()) {
                    data.setPassengerProfile(RestReportsHelper.convertReference(traveller.getPassenger(), RestReportsHelper.personNameGetter((EntityReference<Person>)traveller.getPassenger(), sc)));
                } else {
                    data.setPassengerProfile(RestReportsHelper.convertReference(traveller.getPassenger()));
                    data.getPassengerProfile().setCaption(data.getPassengerName());
                }
                EntityContainer person = EntityStorageHelper.resolve((EntityReference)traveller.getPassenger(), (EntityStorageContext)sc);
                if (person != null) {
                    data.setEmployeeCategory(ProfileHelper.getEmployeeCategory((Person)((Person)person.getEntity()), (Date)handler.findIssueDate(product)));
                }
                if (person != null && person.getEntity() != null && (aclRole = ((Person)person.getEntity()).getAclSettings().getAclRole()) != null) {
                    data.setPassengerRole(aclRole.getCaption());
                }
            }
            if (!handler.isMultiTraveller() || !infantWithoutSeat) {
                data.setAgencyFee(this.calculateMeasure(record.getAgencyFee(), n, countPayers, countAllPassengers));
                data.setAgencyFeeVat(this.calculateMeasure(record.getAgencyFeeVat(), n, countPayers, countAllPassengers));
                data.setHiddenFee(this.calculateMeasure(record.getHiddenFee(), n, countPayers, countAllPassengers));
                data.setHiddenFeeVAT(this.calculateMeasure(record.getHiddenFeeVAT(), n, countPayers, countAllPassengers));
                data.setSubagencyFee(this.calculateMeasure(record.getSubagencyFee(), n, countPayers, countAllPassengers));
                data.setVoidingFee(this.calculateMeasure(record.getVoidingFee(), n, countPayers, countAllPassengers));
                data.setVoidingFeeVat(this.calculateMeasure(record.getVoidingFeeVat(), n, countPayers, countAllPassengers));
                data.setBaseFare(this.calculateMeasure(record.getBaseFare(), n, countPayers, countAllPassengers));
                data.setEquivalentFare(this.calculateMeasure(record.getEquivalentFare(), n, countPayers, countAllPassengers));
                data.setPenalty(this.calculateMeasure(record.getPenalty(), n, countPayers, countAllPassengers));
                data.setEffectivePenalty(this.calculateMeasure(record.getEffectivePenalty(), n, countPayers, countAllPassengers));
                data.setPrice(this.calculateMeasure(record.getPrice(), n, countPayers, countAllPassengers));
                data.setPriceVat(this.calculateMeasure(record.getPriceVat(), n, countPayers, countAllPassengers));
                data.setSubagencyPrice(this.calculateMeasure(record.getSubagencyPrice(), n, countPayers, countAllPassengers));
                data.setOnHoldSum(this.calculateMeasure(record.getOnHoldSum(), n, countPayers, countAllPassengers));
                data.setSelfBookingEconomy(this.calculateMeasure(record.getSelfBookingEconomy(), n, countPayers, countAllPassengers));
                data.setSupplierFee(this.calculateMeasure(record.getSupplierFee(), n, countPayers, countAllPassengers));
                data.setTotal(this.calculateMeasure(record.getTotal(), n, countPayers, countAllPassengers));
                data.setSubagencyTotal(this.calculateMeasure(record.getSubagencyTotal(), n, countPayers, countAllPassengers));
                data.setSupplierTotal(this.calculateMeasure(record.getSupplierTotal(), n, countPayers, countAllPassengers));
                data.setSubagencyFopSum(this.calculateMeasure(record.getSubagencyFopSum(), n, countPayers, countAllPassengers));
                data.setSupplierFeeVat(this.calculateMeasure(record.getSupplierFeeVat(), n, countPayers, countAllPassengers));
                data.setTripartiteDiscount(this.calculateMeasure(record.getTripartiteDiscount(), n, countPayers, countAllPassengers));
                data.setSupplierCommission(this.calculateMeasure(record.getSupplierCommission(), n, countPayers, countAllPassengers));
                data.setTaxesSum(this.calculateMeasure(record.getTaxesSum(), n, countPayers, countAllPassengers));
                data.setAdditionalServicesSum(this.calculateMeasure(record.getAdditionalServicesSum(), n, countPayers, countAllPassengers));
                data.setDeduction(this.calculateMeasure(record.getDeduction(), n, countPayers, countAllPassengers));
                data.setRefundDeduction(this.calculateMeasure(record.getRefundDeduction(), n, countPayers, countAllPassengers));
                data.setSubagencyCommission(this.calculateMeasure(record.getSubagencyCommission(), n, countPayers, countAllPassengers));
                data.setFirstClientFee(this.calculateMeasure(record.getFirstClientFee(), n, countPayers, countAllPassengers));
                data.setSecondClientFee(this.calculateMeasure(record.getSecondClientFee(), n, countPayers, countAllPassengers));
                data.setFirstSubagencyFee(this.calculateMeasure(record.getFirstSubagencyFee(), n, countPayers, countAllPassengers));
                data.setSecondSubagencyFee(this.calculateMeasure(record.getSecondSubagencyFee(), n, countPayers, countAllPassengers));
                data.setTechnicalFee(this.calculateMeasure(record.getTechnicalFee(), n, countPayers, countAllPassengers));
                data.setAgencyBonusDiscount(this.calculateMeasure(record.getAgencyBonusDiscount(), n, countPayers, countAllPassengers));
                data.setTaxRI(this.calculateMeasure(record.getTaxRI(), n, countPayers, countAllPassengers));
                data.setTaxForBlank(this.calculateMeasure(record.getTaxForBlank(), n, countPayers, countAllPassengers));
                data.setTaxForBlankVAT(this.calculateMeasure(record.getTaxForBlankVAT(), n, countPayers, countAllPassengers));
                data.setRailwayService(this.calculateMeasure(record.getRailwayService(), n, countPayers, countAllPassengers));
                data.setRailwayServiceVAT(this.calculateMeasure(record.getRailwayServiceVAT(), n, countPayers, countAllPassengers));
                data.setCashFopSum(this.calculateMeasure(record.getCashFopSum(), n, countPayers, countAllPassengers));
                data.setRetailFopSum(this.calculateMeasure(record.getRetailFopSum(), n, countPayers, countAllPassengers));
                data.setEarlyCheckInCost(this.calculateMeasure(record.getEarlyCheckInCost(), n, countPayers, countAllPassengers));
                data.setLateCheckOutCost(this.calculateMeasure(record.getLateCheckOutCost(), n, countPayers, countAllPassengers));
                data.setTaxForBlankRetention(this.calculateMeasure(record.getTaxForBlankRetention(), n, countPayers, countAllPassengers));
                data.setTaxPSRetention(this.calculateMeasure(record.getTaxPSRetention(), n, countPayers, countAllPassengers));
                data.setPriceOfCompletedService(this.calculateMeasure(record.getPriceOfCompletedService(), n, countPayers, countAllPassengers));
                data.setPenaltyVAT(this.calculateMeasure(record.getPenaltyVAT(), n, countPayers, countAllPassengers));
                data.setMaximumPrice(this.calculateMeasure(record.getMaximumPrice(), n, countPayers, countAllPassengers));
                data.setMinimumPrice(this.calculateMeasure(record.getMinimumPrice(), n, countPayers, countAllPassengers));
                data.setPossibleEconomy(this.calculateMeasure(record.getPossibleEconomy(), n, countPayers, countAllPassengers));
                data.setPriceRetention(BigDecimal.ZERO);
                int _n = n;
                record.getPriceParameters().forEach(param -> {
                    PriceParameter priceParameter = new PriceParameter();
                    data.getPriceParameters().add(param);
                    priceParameter.setCode(param.getCode());
                    priceParameter.setName(param.getName());
                    priceParameter.setType(param.getType());
                    priceParameter.setValue(param.getValue());
                    if (!TextUtil.isBlank((String)param.getValue())) {
                        switch (param.getType()) {
                            case DOUBLE: {
                                priceParameter.setValue(Double.toString(this.calculateMeasure(new BigDecimal(param.getValue()), _n, countPayers, countAllPassengers).doubleValue()));
                                break;
                            }
                            case BIG_DECIMAL: {
                                priceParameter.setValue(this.calculateMeasure(new BigDecimal(param.getValue()), _n, countPayers, countAllPassengers).toString());
                                break;
                            }
                            case INTEGER: {
                                priceParameter.setValue(Integer.toString(this.calculateMeasure(new BigDecimal(param.getValue()), _n, countPayers, countAllPassengers).intValue()));
                            }
                        }
                    }
                });
            }
            if ((statisticalData = handler.getStatisticalData(product)) == null || (travellerCostCodes = (TravellerCostCodes)statisticalData.getTravellerCostCodes().stream().filter(tcc -> traveller != null && traveller.equals((Object)tcc.getTraveller())).findFirst().orElse(null)) == null) continue;
            this.fillCostCodes(data.getCostCodes(), travellerCostCodes.getCostCodes());
        }
    }

    private void fillCostCodes(List<ReportCostCode> recordCostCodes, List<CostCode> costCodes) {
        costCodes.forEach(cc -> {
            CostCodeCategory category = (CostCodeCategory)DictionaryCache.get().resolveReference(cc.getCostCodeProperties() != null ? cc.getCostCodeProperties().getCategory() : null);
            if (category != null && !TextUtil.isBlank((String)cc.getValue())) {
                ReportCostCode rcc = new ReportCostCode();
                rcc.setCode(category.getCode());
                rcc.setName(category.toString(LocaleHelper.RU_LOCALE).replaceAll("'", " "));
                if (cc.getValue() != null) {
                    rcc.setValue(cc.getValue().replaceAll("'", " "));
                }
                if (cc.getLocalValue() != null) {
                    rcc.setLocalValue(cc.getLocalValue().replaceAll("'", " "));
                }
                if (cc.getEnglishValue() != null) {
                    rcc.setEnglishValue(cc.getEnglishValue().replaceAll("'", " "));
                }
                recordCostCodes.add(rcc);
            }
        });
    }

    private BigDecimal calculateMeasure(BigDecimal value, int n, int countPayers, int countAllPassengers) {
        boolean isLast;
        boolean bl = isLast = n == countAllPassengers - 1;
        if (isLast) {
            return value.subtract(value.divide(BigDecimal.valueOf(countPayers), 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(countPayers - 1)));
        }
        return value.divide(BigDecimal.valueOf(countPayers), 2, RoundingMode.HALF_UP);
    }

    private BigDecimal calculateMeasure(BigDecimal total, BaseProduct product, Traveller trav, Map<BaseProduct, Set<Traveller>> productsMap) {
        boolean isLast;
        Collection travs;
        ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)product);
        BigDecimal multiplier = BigDecimal.ONE;
        ProductStatus status = GeneralProductHelper.getStatus((BaseProduct)product);
        if (status == null) {
            return BigDecimal.ZERO;
        }
        if (ProductStatusHandler.getAllVoidStatuses().contains(status)) {
            return BigDecimal.ZERO;
        }
        if (status == ProductStatus.EXCHANGE || status == ProductStatus.REFUND) {
            multiplier = multiplier.negate();
        }
        if ((travs = handler.getTravellers(product)).isEmpty() || trav == null || travs.size() == 1) {
            return total.multiply(multiplier);
        }
        int totalCount = travs.size();
        Set travellers = productsMap.computeIfAbsent(product, k -> new HashSet());
        travellers.add(trav);
        boolean bl = isLast = travellers.size() == totalCount;
        if (isLast) {
            return total.subtract(total.divide(BigDecimal.valueOf(totalCount), 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(totalCount - 1))).multiply(multiplier);
        }
        return total.divide(BigDecimal.valueOf(totalCount), 2, RoundingMode.HALF_UP).multiply(multiplier);
    }

    private int getCountPayers(List<Traveller> travellers, BaseProduct product, ProductHandler<BaseProduct> handler) {
        if (!handler.isMultiTraveller()) {
            return 1;
        }
        int count = 0;
        for (Traveller traveller : travellers) {
            boolean withoutSeat = this.isInfantWithoutSeat(traveller, product, handler);
            if (!withoutSeat) continue;
            ++count;
        }
        return travellers.size() - count;
    }

    private boolean isInfantWithoutSeat(Traveller traveller, BaseProduct product, ProductHandler<BaseProduct> handler) {
        DictionaryReference passengerTypeRef = handler.getPassengerType(product, traveller);
        PassengerType passengerType = (PassengerType)DictionaryCache.get().resolveReference(passengerTypeRef);
        if (passengerType != null) {
            return passengerType.isWithoutSeat();
        }
        return false;
    }
}

