/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports.getBookingFile.products;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.server.ibecorp.rest.reports.IbusReportsRestContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.rest.reports.ReportProduct;
import com.gridnine.xtrip.server.model.rest.reports.ReportValidationData;
import java.util.ArrayList;
import java.util.List;

public class ReportProductFillValidationDataProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Boolean isDemon = (Boolean)ctx.getObject((Enum)IbusReportsRestContextKeys.DEMON_KEY);
        ReportProduct record = (ReportProduct)ctx.getMandatoryObject((Enum)IbusReportsRestContextKeys.RECORD);
        BaseProduct product = (BaseProduct)ctx.getMandatoryObject((Enum)IBusRestContextKeys.PRODUCT);
        List validationMessages = GeneralProductHelper.getValidationMessages((BaseProduct)product);
        ArrayList<ReportValidationData> reportValidationData = new ArrayList<ReportValidationData>();
        for (ValidationMessage validationMessage : validationMessages) {
            ValidationMessageSeverity severity = validationMessage.getSeverity();
            if (severity.equals((Object)ValidationMessageSeverity.MESSAGE)) continue;
            ReportValidationData data = new ReportValidationData();
            data.setSeverity(severity.name());
            data.setCategory(validationMessage.getCategory().name());
            data.setErrorCode(validationMessage.getErrorCode());
            data.setDetails(validationMessage.getDetails());
            L10nMessage message = validationMessage.getMessage();
            message.getParameters().replaceAll(o -> "?");
            data.setMessage(isDemon != false ? LocaleManager.get().getL10nResourceManager().getMessage(message, LocaleHelper.EN_LOCALE) : message.toString());
            data.setValidationMessageUid(validationMessage.getUid());
            reportValidationData.add(data);
        }
        record.getValidationMessages().addAll(reportValidationData);
    }
}

