/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports.getBookingFile.products;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalServiceType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.l10n.Messages;
import com.gridnine.xtrip.server.ibecorp.rest.reports.IbusReportsRestContextKeys;
import com.gridnine.xtrip.server.ibecorp.rest.reports.RestReportsHelper;
import com.gridnine.xtrip.server.ibecorp.rest.reports.getBookingFile.products.ReportProductCommonFieldsProcessor;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.rest.reports.ReportProduct;
import com.gridnine.xtrip.server.model.rest.reports.ReportRestHotel;
import com.gridnine.xtrip.server.model.rest.reports.RestProductType;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public class ReportProductHotelFieldsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List rooms;
        int stars;
        GeoLocation destinationCity;
        Boolean isDemon = (Boolean)ctx.getObject((Enum)IbusReportsRestContextKeys.DEMON_KEY);
        ReportProduct record = (ReportProduct)ctx.getMandatoryObject((Enum)IbusReportsRestContextKeys.RECORD);
        HotelProduct product = (HotelProduct)ctx.getMandatoryObject((Enum)IBusRestContextKeys.PRODUCT);
        record.setProductType(RestProductType.HOTEL);
        record.setComments(TextUtil.objToNotNullString((Object)product.getComments()));
        DictionaryReference destinationCityReference = product.getHotelLocation();
        record.setDestinationCity(RestReportsHelper.convertReference(DictHelper.getCity((DictionaryReference)destinationCityReference), isDemon));
        if (destinationCityReference != null && (destinationCity = (GeoLocation)DictionaryCache.get().resolveReference(destinationCityReference)) != null) {
            record.setProviderCityName(DictHelper.getTranslation((BaseDictionary)destinationCity, (Locale)(isDemon != false ? LocaleHelper.EN_LOCALE : LocaleHelper.RU_LOCALE), (boolean)false));
        }
        if (TextUtil.isBlank((String)record.getProviderCityName())) {
            record.setProviderCityName(product.getCityProviderData() == null ? null : product.getCityProviderData().getProviderName());
            if (record.getProviderCityName() == null) {
                record.setProviderCityName("");
            }
        }
        if (product.getSalesPoint() != null) {
            record.setSalesPoint(RestReportsHelper.convertReference(Optional.ofNullable(EntityStorage.get().resolve(product.getSalesPoint())).map(EntityContainer::toReference).orElse(product.getSalesPoint())));
        }
        DictionaryReference countryDictionaryReference = product.getHotelCountry() != null ? product.getHotelCountry() : DictHelper.getCountry((DictionaryReference)product.getHotelLocation());
        record.setDestinationCountry(RestReportsHelper.convertReference(countryDictionaryReference, isDemon));
        ReportRestHotel restHotel = new ReportRestHotel();
        restHotel.setId(TextUtil.objToNotNullString((Object)product.getHotelPropertyId()));
        restHotel.setHotelName(TextUtil.objToNotNullString((Object)product.getHotelName()));
        record.setHotel(restHotel);
        String routeLine = null;
        if (destinationCityReference != null) {
            routeLine = DictHelper.getTranslation((DictionaryReference)destinationCityReference, (Locale)(isDemon != false ? LocaleHelper.EN_LOCALE : LocaleHelper.RU_LOCALE), (boolean)false);
        } else if (product.getCityProviderData() != null) {
            routeLine = product.getCityProviderData().getProviderName();
        }
        if (routeLine == null) {
            routeLine = "";
        }
        record.setRouteLine(routeLine);
        record.setFullRouteLine(routeLine);
        this.fillHotelTicketByProduct(record, product);
        BigDecimal earlyCheckInCost = BigDecimal.ZERO;
        BigDecimal lateCheckOutCost = BigDecimal.ZERO;
        boolean hasLateCheckOut = false;
        boolean hasEarlyCheckIn = false;
        for (Object service : product.getAdditionalServices()) {
            if (service.getType() == AdditionalServiceType.EARLIER_CHECKIN) {
                if (service.getEquivalentAmount() != null) {
                    earlyCheckInCost = earlyCheckInCost.add(service.getEquivalentAmount());
                }
                hasEarlyCheckIn = true;
            }
            if (service.getType() != AdditionalServiceType.LATER_CHECKOUT) continue;
            if (service.getEquivalentAmount() != null) {
                lateCheckOutCost = lateCheckOutCost.add(service.getEquivalentAmount());
            }
            hasLateCheckOut = true;
        }
        record.setLateCheckOut(hasLateCheckOut);
        record.setEarlyCheckIn(hasEarlyCheckIn);
        record.setLateCheckOutCost(ReportProductCommonFieldsProcessor.calculateMeasure(lateCheckOutCost, product));
        record.setEarlyCheckInCost(ReportProductCommonFieldsProcessor.calculateMeasure(earlyCheckInCost, product));
        int n = stars = product.getHotelStars() != null && product.getHotelStars() > 0 ? product.getHotelStars() : 0;
        if (stars > 5) {
            throw Xeption.forAdmin((String)Messages.HOTEL_STARS_TOO_MUCH, (Object[])new Object[]{product.getSystemNumber(), product.getReservation().getBookingFile().getNumber(), stars});
        }
        record.setHotelStars(stars);
        product.getRooms().stream().map(Room::getRoomName).filter(Objects::nonNull).findFirst().ifPresent(arg_0 -> ((ReportProduct)record).setRoomName(arg_0));
        for (Room room : product.getRooms()) {
            if (!Boolean.TRUE.equals(room.getVat())) continue;
            record.setRoomWithVat(true);
            break;
        }
        if (record.hasRoomWithVat()) {
            record.setCountOfNightsWithVat(record.getCountOfNight());
        }
        StatisticalData statisticalData = product.getStatisticalData();
        if (record.isServiceCompleted() && statisticalData != null) {
            record.setMinimumPrice(MiscUtil.guarded((BigDecimal)statisticalData.getMinPriceHotel()));
            RestReportsHelper.fillPossibleEconomy(record, record.getPrice());
        }
        record.setContract3D(product.isTripartiteAgreement());
        if (!TextUtil.isBlank((String)product.getClientTariffCode())) {
            record.setCodeSaleForContract3D(product.getClientTariffCode());
        }
        if (!(rooms = product.getRooms()).isEmpty() && ((Room)rooms.get(0)).getRackRate() != null) {
            record.setRackRate(((Room)rooms.get(0)).getRackRate());
        }
        record.setProviderHotelCode(MiscUtil.guarded((String)product.getProviderHotelCode()));
    }

    private void fillHotelTicketByProduct(ReportProduct record, HotelProduct product) {
        int countOfNights = this.getCountOfNights(product);
        if (countOfNights > Short.MAX_VALUE) {
            throw Xeption.forAdmin((String)Messages.COUNT_OF_NIGHTS_TOO_BIG, (Object[])new Object[]{product.getSystemNumber(), product.getReservation().getBookingFile().getNumber(), countOfNights});
        }
        record.setCountOfNight(countOfNights);
        int countOfRooms = this.getCountOfRooms(product);
        if (countOfRooms > Short.MAX_VALUE) {
            throw Xeption.forAdmin((String)Messages.COUNT_OF_ROOMS_TOO_BIG, (Object[])new Object[]{product.getSystemNumber(), product.getReservation().getBookingFile().getNumber(), countOfRooms});
        }
        record.setCountOfRooms(countOfRooms);
    }

    private int getCountOfRooms(HotelProduct hotelProduct) {
        int countOfRooms = hotelProduct.getRooms().size();
        if (hotelProduct.getStatus() == ProductStatus.REFUND || hotelProduct.getStatus() == ProductStatus.EXCHANGE) {
            int sellCountOfNights = this.getCountOfNights(hotelProduct);
            if (hotelProduct.getPreviousProduct() == null) {
                throw Xeption.forAdmin((String)Messages.REFUND_EXCHANGE_WITHOUT_SELL, (Object[])new Object[]{hotelProduct.getSystemNumber(), hotelProduct.getReservation().getBookingFile().getNumber()});
            }
            int refundCountOfNights = this.getCountOfNights(hotelProduct.getPreviousProduct());
            if (sellCountOfNights > refundCountOfNights) {
                return 0;
            }
            return -countOfRooms;
        }
        return countOfRooms;
    }

    private int getCountOfNights(HotelProduct hotelProduct) {
        if (hotelProduct.getRooms() == null || hotelProduct.getRooms().isEmpty()) {
            return 0;
        }
        Date startDate = ((Room)hotelProduct.getRooms().get(0)).getCheckInDate();
        Date endDate = ((Room)hotelProduct.getRooms().get(0)).getCheckOutDate();
        return HotelProductHelper.calculateNights((Date)startDate, (Date)endDate);
    }
}

